/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.commands.commands;

import baritone.api.BaritoneAPI;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Arrays;
import java.util.List;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.commands.Command;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2172;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2767;
import net.minecraft.class_3417;
import net.minecraft.class_5250;

public class LocateCommand
extends Command {
    private class_243 firstStart;
    private class_243 firstEnd;
    private class_243 secondStart;
    private class_243 secondEnd;
    private final List<class_2248> netherFortressBlocks = Arrays.asList(class_2246.field_10266, class_2246.field_10364, class_2246.field_9974);
    private final List<class_2248> monumentBlocks = Arrays.asList(class_2246.field_10006, class_2246.field_10174, class_2246.field_10297);
    private final List<class_2248> strongholdBlocks = Arrays.asList(class_2246.field_10398);

    public LocateCommand() {
        super("locate", "Locates structures", "loc");
    }

    @Override
    public void build(LiteralArgumentBuilder<class_2172> builder) {
        builder.then(LocateCommand.literal("buried_treasure").executes(s -> {
            class_1799 stack = MeteorClient.mc.field_1724.method_31548().method_7391();
            if (stack.method_7909() != class_1802.field_8204) {
                this.error("You need to hold a treasure map first", new Object[0]);
                return 1;
            }
            class_2487 tag = stack.method_7969();
            class_2499 nbt1 = (class_2499)tag.method_10580("Decorations");
            if (nbt1 == null) {
                this.error("Couldn't locate the cross. Are you holding a (highlight)treasure map(default)?", new Object[0]);
                return 1;
            }
            class_2487 iconNBT = nbt1.method_10602(0);
            if (iconNBT == null) {
                this.error("Couldn't locate the cross. Are you holding a (highlight)treasure map(default)?", new Object[0]);
                return 1;
            }
            class_243 coords = new class_243(iconNBT.method_10574("x"), iconNBT.method_10574("y"), iconNBT.method_10574("z"));
            class_5250 text = class_2561.method_43470((String)"Buried Treasure located at ");
            text.method_10852((class_2561)ChatUtils.formatCoords(coords));
            text.method_27693(".");
            this.info((class_2561)text);
            return 1;
        }));
        builder.then(LocateCommand.literal("lodestone").executes(s -> {
            class_1799 stack = MeteorClient.mc.field_1724.method_31548().method_7391();
            if (stack.method_7909() != class_1802.field_8251) {
                this.error("You need to hold a lodestone compass", new Object[0]);
                return 1;
            }
            class_2487 tag = stack.method_7969();
            if (tag == null) {
                this.error("Couldn't get the NBT data. Are you holding a (highlight)lodestone(default) compass?", new Object[0]);
                return 1;
            }
            class_2487 nbt1 = tag.method_10562("LodestonePos");
            if (nbt1 == null) {
                this.error("Couldn't get the NBT data. Are you holding a (highlight)lodestone(default) compass?", new Object[0]);
                return 1;
            }
            class_243 coords = new class_243(nbt1.method_10574("X"), nbt1.method_10574("Y"), nbt1.method_10574("Z"));
            class_5250 text = class_2561.method_43470((String)"Lodestone located at ");
            text.method_10852((class_2561)ChatUtils.formatCoords(coords));
            text.method_27693(".");
            this.info((class_2561)text);
            return 1;
        }));
        builder.then(LocateCommand.literal("mansion").executes(s -> {
            class_1799 stack = MeteorClient.mc.field_1724.method_31548().method_7391();
            if (stack.method_7909() != class_1802.field_8204) {
                this.error("You need to hold a woodland explorer map first", new Object[0]);
                return 1;
            }
            class_2487 tag = stack.method_7969();
            class_2499 nbt1 = (class_2499)tag.method_10580("Decorations");
            if (nbt1 == null) {
                this.error("Couldn't locate the mansion. Are you holding a (highlight)woodland explorer map(default)?", new Object[0]);
                return 1;
            }
            class_2487 iconNBT = nbt1.method_10602(0);
            if (iconNBT == null) {
                this.error("Couldn't locate the mansion. Are you holding a (highlight)woodland explorer map(default)?", new Object[0]);
                return 1;
            }
            class_243 coords = new class_243(iconNBT.method_10574("x"), iconNBT.method_10574("y"), iconNBT.method_10574("z"));
            class_5250 text = class_2561.method_43470((String)"Mansion located at ");
            text.method_10852((class_2561)ChatUtils.formatCoords(coords));
            text.method_27693(".");
            this.info((class_2561)text);
            return 1;
        }));
        builder.then(LocateCommand.literal("stronghold").executes(s -> {
            boolean foundEye = InvUtils.testInHotbar(class_1802.field_8449);
            if (foundEye) {
                BaritoneAPI.getProvider().getPrimaryBaritone().getCommandManager().execute("follow entity minecraft:eye_of_ender");
                this.firstStart = null;
                this.firstEnd = null;
                this.secondStart = null;
                this.secondEnd = null;
                MeteorClient.EVENT_BUS.subscribe(this);
                this.info("Please throw the first Eye of Ender", new Object[0]);
            } else {
                class_243 coords = this.findByBlockList(this.strongholdBlocks);
                if (coords == null) {
                    this.error("No stronghold found nearby. You can use (highlight)Ender Eyes(default) for more success.", new Object[0]);
                    return 1;
                }
                class_5250 text = class_2561.method_43470((String)"Stronghold located at ");
                text.method_10852((class_2561)ChatUtils.formatCoords(coords));
                text.method_27693(".");
                this.info((class_2561)text);
            }
            return 1;
        }));
        builder.then(LocateCommand.literal("nether_fortress").executes(s -> {
            class_243 coords = this.findByBlockList(this.netherFortressBlocks);
            if (coords == null) {
                this.error("No nether fortress found.", new Object[0]);
                return 1;
            }
            class_5250 text = class_2561.method_43470((String)"Fortress located at ");
            text.method_10852((class_2561)ChatUtils.formatCoords(coords));
            text.method_27693(".");
            this.info((class_2561)text);
            return 1;
        }));
        builder.then(LocateCommand.literal("monument").executes(s -> {
            class_2487 iconNBT;
            class_2499 nbt1;
            class_2487 tag;
            class_1799 stack = MeteorClient.mc.field_1724.method_31548().method_7391();
            if (stack.method_7909() == class_1802.field_8204 && (tag = stack.method_7969()) != null && (nbt1 = (class_2499)tag.method_10580("Decorations")) != null && (iconNBT = nbt1.method_10602(0)) != null) {
                class_243 coords = new class_243(iconNBT.method_10574("x"), iconNBT.method_10574("y"), iconNBT.method_10574("z"));
                class_5250 text = class_2561.method_43470((String)"Monument located at ");
                text.method_10852((class_2561)ChatUtils.formatCoords(coords));
                text.method_27693(".");
                this.info((class_2561)text);
                return 1;
            }
            class_243 coords = this.findByBlockList(this.monumentBlocks);
            if (coords == null) {
                this.error("No monument found. You can try using a (highlight)Ocean explorer map(default) for more success.", new Object[0]);
                return 1;
            }
            class_5250 text = class_2561.method_43470((String)"Monument located at ");
            text.method_10852((class_2561)ChatUtils.formatCoords(coords));
            text.method_27693(".");
            this.info((class_2561)text);
            return 1;
        }));
        builder.then(LocateCommand.literal("cancel").executes(s -> {
            this.cancel();
            return 1;
        }));
    }

    private void cancel() {
        this.warning("Locate canceled", new Object[0]);
        MeteorClient.EVENT_BUS.unsubscribe(this);
    }

    private class_243 findByBlockList(List<class_2248> blockList) {
        List posList = BaritoneAPI.getProvider().getWorldScanner().scanChunkRadius(BaritoneAPI.getProvider().getPrimaryBaritone().getPlayerContext(), blockList, 64, 10, 32);
        if (posList.isEmpty()) {
            return null;
        }
        if (posList.size() < 3) {
            this.warning("Only %d block(s) found. This search might be a false positive.", posList.size());
        }
        return new class_243((double)((class_2338)posList.get(0)).method_10263(), (double)((class_2338)posList.get(0)).method_10264(), (double)((class_2338)posList.get(0)).method_10260());
    }

    @EventHandler
    private void onReadPacket(PacketEvent.Receive event) {
        class_2604 packet;
        class_2596<?> class_25962 = event.packet;
        if (class_25962 instanceof class_2604 && (packet = (class_2604)class_25962).method_11169() == class_1299.field_6061) {
            this.firstPosition(packet.method_11175(), packet.method_11174(), packet.method_11176());
        }
        if ((class_25962 = event.packet) instanceof class_2767 && (packet = (class_2767)class_25962).method_11894().comp_349() == class_3417.field_15210) {
            this.lastPosition(packet.method_11890(), packet.method_11889(), packet.method_11893());
        }
    }

    private void firstPosition(double x, double y, double z) {
        class_243 pos = new class_243(x, y, z);
        if (this.firstStart == null) {
            this.firstStart = pos;
        } else {
            this.secondStart = pos;
        }
    }

    private void lastPosition(double x, double y, double z) {
        this.info("%s Eye of Ender's trajectory saved.", this.firstEnd == null ? "First" : "Second");
        class_243 pos = new class_243(x, y, z);
        if (this.firstEnd == null) {
            this.firstEnd = pos;
            this.info("Please throw the second Eye Of Ender from a different location.", new Object[0]);
        } else {
            this.secondEnd = pos;
            this.findStronghold();
        }
    }

    private void findStronghold() {
        if (this.firstStart == null || this.firstEnd == null || this.secondStart == null || this.secondEnd == null) {
            this.error("Missing position data", new Object[0]);
            this.cancel();
            return;
        }
        double[] start = new double[]{this.secondStart.field_1352, this.secondStart.field_1350, this.secondEnd.field_1352, this.secondEnd.field_1350};
        double[] end = new double[]{this.firstStart.field_1352, this.firstStart.field_1350, this.firstEnd.field_1352, this.firstEnd.field_1350};
        double[] intersection = this.calcIntersection(start, end);
        if (Double.isNaN(intersection[0]) || Double.isNaN(intersection[1]) || Double.isInfinite(intersection[0]) || Double.isInfinite(intersection[1])) {
            this.error("Lines are parallel", new Object[0]);
            this.cancel();
            return;
        }
        BaritoneAPI.getProvider().getPrimaryBaritone().getCommandManager().execute("stop");
        MeteorClient.EVENT_BUS.unsubscribe(this);
        class_243 coords = new class_243(intersection[0], 0.0, intersection[1]);
        class_5250 text = class_2561.method_43470((String)"Stronghold roughly located at ");
        text.method_10852((class_2561)ChatUtils.formatCoords(coords));
        text.method_27693(".");
        this.info((class_2561)text);
    }

    private double[] calcIntersection(double[] line, double[] line2) {
        double a1 = line[3] - line[1];
        double b1 = line[0] - line[2];
        double c1 = a1 * line[0] + b1 * line[1];
        double a2 = line2[3] - line2[1];
        double b2 = line2[0] - line2[2];
        double c2 = a2 * line2[0] + b2 * line2[1];
        double delta = a1 * b2 - a2 * b1;
        return new double[]{(b2 * c1 - b1 * c2) / delta, (a1 * c2 - a2 * c1) / delta};
    }
}

