/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.commands.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.commands.Command;
import meteordevelopment.meteorclient.commands.arguments.CompoundNbtTagArgumentType;
import meteordevelopment.meteorclient.systems.config.Config;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2172;
import net.minecraft.class_2203;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2596;
import net.minecraft.class_2873;
import net.minecraft.class_5250;

public class NbtCommand
extends Command {
    public NbtCommand() {
        super("nbt", "Modifies NBT data for an item, example: .nbt add {display:{Name:'{\"text\":\"$cRed Name\"}'}}", new String[0]);
    }

    @Override
    public void build(LiteralArgumentBuilder<class_2172> builder) {
        builder.then(NbtCommand.literal("add").then(NbtCommand.argument("nbt", CompoundNbtTagArgumentType.create()).executes(s -> {
            class_1799 stack = MeteorClient.mc.field_1724.method_31548().method_7391();
            if (this.validBasic(stack)) {
                class_2487 tag = CompoundNbtTagArgumentType.get(s);
                class_2487 source = stack.method_7948();
                if (tag != null) {
                    source.method_10543(tag);
                    this.setStack(stack);
                } else {
                    this.error("Some of the NBT data could not be found, try using: " + Config.get().prefix.get() + "nbt set {nbt}", new Object[0]);
                }
            }
            return 1;
        })));
        builder.then(NbtCommand.literal("set").then(NbtCommand.argument("nbt", CompoundNbtTagArgumentType.create()).executes(context -> {
            class_1799 stack = MeteorClient.mc.field_1724.method_31548().method_7391();
            if (this.validBasic(stack)) {
                stack.method_7980(CompoundNbtTagArgumentType.get(context));
                this.setStack(stack);
            }
            return 1;
        })));
        builder.then(NbtCommand.literal("remove").then(NbtCommand.argument("nbt_path", class_2203.method_9360()).executes(context -> {
            class_1799 stack = MeteorClient.mc.field_1724.method_31548().method_7391();
            if (this.validBasic(stack)) {
                class_2203.class_2209 path = (class_2203.class_2209)context.getArgument("nbt_path", class_2203.class_2209.class);
                path.method_9372((class_2520)stack.method_7969());
            }
            return 1;
        })));
        builder.then(NbtCommand.literal("get").executes(context -> {
            class_1799 stack = MeteorClient.mc.field_1724.method_31548().method_7391();
            if (stack == null) {
                this.error("You must hold an item in your main hand.", new Object[0]);
            } else {
                class_2487 tag = stack.method_7969();
                class_5250 copyButton = class_2561.method_43470((String)"NBT");
                copyButton.method_10862(copyButton.method_10866().method_27706(class_124.field_1073).method_10958(new class_2558(class_2558.class_2559.field_11750, this.toString("copy"))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Copy the NBT data to your clipboard."))));
                class_5250 text = class_2561.method_43470((String)"");
                text.method_10852((class_2561)copyButton);
                if (tag == null) {
                    text.method_27693("{}");
                } else {
                    text.method_27693(" ").method_10852(class_2512.method_32270((class_2520)tag));
                }
                this.info((class_2561)text);
            }
            return 1;
        }));
        builder.then(NbtCommand.literal("copy").executes(context -> {
            class_1799 stack = MeteorClient.mc.field_1724.method_31548().method_7391();
            if (stack == null) {
                this.error("You must hold an item in your main hand.", new Object[0]);
            } else {
                class_2487 tag = stack.method_7948();
                MeteorClient.mc.field_1774.method_1455(tag.toString());
                class_5250 nbt = class_2561.method_43470((String)"NBT");
                nbt.method_10862(nbt.method_10866().method_27706(class_124.field_1073).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2512.method_32270((class_2520)tag))));
                class_5250 text = class_2561.method_43470((String)"");
                text.method_10852((class_2561)nbt);
                text.method_10852((class_2561)class_2561.method_43470((String)" data copied!"));
                this.info((class_2561)text);
            }
            return 1;
        }));
        builder.then(NbtCommand.literal("paste").executes(context -> {
            class_1799 stack = MeteorClient.mc.field_1724.method_31548().method_7391();
            if (this.validBasic(stack)) {
                stack.method_7980(new CompoundNbtTagArgumentType().parse(new StringReader(MeteorClient.mc.field_1774.method_1460())));
                this.setStack(stack);
            }
            return 1;
        }));
        builder.then(NbtCommand.literal("count").then(NbtCommand.argument("count", IntegerArgumentType.integer((int)-127, (int)127)).executes(context -> {
            class_1799 stack = MeteorClient.mc.field_1724.method_31548().method_7391();
            if (this.validBasic(stack)) {
                int count = IntegerArgumentType.getInteger((CommandContext)context, (String)"count");
                stack.method_7939(count);
                this.setStack(stack);
                this.info("Set mainhand stack count to %s.", count);
            }
            return 1;
        })));
    }

    private void setStack(class_1799 stack) {
        MeteorClient.mc.field_1724.field_3944.method_2883((class_2596)new class_2873(36 + MeteorClient.mc.field_1724.method_31548().field_7545, stack));
    }

    private boolean validBasic(class_1799 stack) {
        if (!MeteorClient.mc.field_1724.method_31549().field_7477) {
            this.error("Creative mode only.", new Object[0]);
            return false;
        }
        if (stack == null) {
            this.error("You must hold an item in your main hand.", new Object[0]);
            return false;
        }
        return true;
    }
}

