/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.commands.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import joptsimple.internal.Strings;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.commands.Command;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.utils.world.TickRate;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2596;
import net.minecraft.class_2639;
import net.minecraft.class_2805;
import net.minecraft.class_5250;
import net.minecraft.class_639;
import net.minecraft.class_642;
import org.apache.commons.lang3.StringUtils;

public class ServerCommand
extends Command {
    private static final List<String> ANTICHEAT_LIST = Arrays.asList("nocheatplus", "negativity", "warden", "horizon", "illegalstack", "coreprotect", "exploitsx", "vulcan", "abc", "spartan", "kauri", "anticheatreloaded", "witherac", "godseye", "matrix", "wraith");
    private static final String completionStarts = "/:abcdefghijklmnopqrstuvwxyz0123456789-";
    private int ticks = 0;
    private boolean bukkitMode = false;
    private final List<String> plugins = new ArrayList<String>();

    public ServerCommand() {
        super("server", "Prints server information", new String[0]);
    }

    @Override
    public void build(LiteralArgumentBuilder<class_2172> builder) {
        builder.executes(context -> {
            this.basicInfo();
            return 1;
        });
        builder.then(ServerCommand.literal("info").executes(ctx -> {
            this.basicInfo();
            return 1;
        }));
        builder.then(((LiteralArgumentBuilder)ServerCommand.literal("plugins").then(ServerCommand.literal("BukkitVer").executes(ctx -> {
            this.getPlugins(true);
            return 1;
        }))).then(ServerCommand.literal("MassScan").executes(ctx -> {
            this.getPlugins(false);
            return 1;
        })));
        builder.then(ServerCommand.literal("tps").executes(ctx -> {
            float tps = TickRate.INSTANCE.getTickRate();
            class_124 color = tps > 17.0f ? class_124.field_1060 : (tps > 12.0f ? class_124.field_1054 : class_124.field_1061);
            this.info("Current TPS: %s%.2f(default).", color, Float.valueOf(tps));
            return 1;
        }));
    }

    private void getPlugins(boolean bukkit) {
        this.bukkitMode = bukkit;
        this.ticks = 0;
        this.plugins.clear();
        Random random = new Random();
        MeteorClient.EVENT_BUS.subscribe(this);
        if (bukkit) {
            if (MeteorClient.mc.method_1496()) {
                this.printPlugins();
                return;
            }
            MeteorClient.mc.field_1724.field_3944.method_2883((class_2596)new class_2805(random.nextInt(200), "bukkit:ver "));
        } else {
            this.info("Please wait around 5 seconds...", new Object[0]);
            new Thread(() -> completionStarts.chars().forEach(i -> {
                MeteorClient.mc.field_1724.field_3944.method_2883((class_2596)new class_2805(random.nextInt(200), Character.toString(i)));
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            })).start();
        }
    }

    private void printPlugins() {
        Collections.sort(this.plugins);
        for (int i = 0; i < this.plugins.size(); ++i) {
            this.plugins.set(i, this.formatName(this.plugins.get(i)));
        }
        if (!this.plugins.isEmpty()) {
            this.info("Plugins (%d): %s ", this.plugins.size(), Strings.join((String[])this.plugins.toArray(new String[0]), (String)", "));
        } else {
            this.error("No plugins found.", new Object[0]);
        }
        this.ticks = 0;
        this.plugins.clear();
        MeteorClient.EVENT_BUS.unsubscribe(this);
    }

    private void basicInfo() {
        class_5250 ipText;
        if (MeteorClient.mc.method_1496()) {
            class_1132 server = MeteorClient.mc.method_1576();
            this.info("Singleplayer", new Object[0]);
            if (server != null) {
                this.info("Version: %s", server.method_3827());
            }
            return;
        }
        class_642 server = MeteorClient.mc.method_1558();
        if (server == null) {
            this.info("Couldn't obtain any server information.", new Object[0]);
            return;
        }
        String ipv4 = "";
        try {
            ipv4 = InetAddress.getByName(server.field_3761).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (ipv4.isEmpty()) {
            ipText = class_2561.method_43470((String)(class_124.field_1080 + server.field_3761));
            ipText.method_10862(ipText.method_10866().method_10958(new class_2558(class_2558.class_2559.field_21462, server.field_3761)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Copy to clipboard"))));
        } else {
            ipText = class_2561.method_43470((String)(class_124.field_1080 + server.field_3761));
            ipText.method_10862(ipText.method_10866().method_10958(new class_2558(class_2558.class_2559.field_21462, server.field_3761)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Copy to clipboard"))));
            class_5250 ipv4Text = class_2561.method_43470((String)String.format("%s (%s)", class_124.field_1080, ipv4));
            ipv4Text.method_10862(ipText.method_10866().method_10958(new class_2558(class_2558.class_2559.field_21462, ipv4)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Copy to clipboard"))));
            ipText.method_10852((class_2561)ipv4Text);
        }
        this.info((class_2561)class_2561.method_43470((String)String.format("%sIP: ", class_124.field_1080)).method_10852((class_2561)ipText));
        this.info("Port: %d", class_639.method_2950((String)server.field_3761).method_2954());
        this.info("Type: %s", MeteorClient.mc.field_1724.method_3135() != null ? MeteorClient.mc.field_1724.method_3135() : "unknown");
        this.info("Motd: %s", server.field_3757 != null ? server.field_3757.getString() : "unknown");
        this.info("Version: %s", server.field_3760.getString());
        this.info("Protocol version: %d", server.field_3756);
        this.info("Difficulty: %s (Local: %.2f)", MeteorClient.mc.field_1687.method_8407().method_5463().getString(), Float.valueOf(MeteorClient.mc.field_1687.method_8404(MeteorClient.mc.field_1724.method_24515()).method_5457()));
        this.info("Day: %d", MeteorClient.mc.field_1687.method_8532() / 24000L);
        this.info("Permission level: %s", this.formatPerms());
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        ++this.ticks;
        if (this.bukkitMode) {
            if (this.ticks >= 200) {
                this.error("Plugins check timed out. Either the packet has been dropped, or you dont have access to the bukkit:ver command.", new Object[0]);
                MeteorClient.EVENT_BUS.unsubscribe(this);
                this.ticks = 0;
            }
        } else if (this.ticks >= 100) {
            this.printPlugins();
        }
    }

    @EventHandler
    private void onReadPacket(PacketEvent.Receive event) {
        try {
            class_2596<?> class_25962 = event.packet;
            if (class_25962 instanceof class_2639) {
                class_2639 packet = (class_2639)class_25962;
                Suggestions matches = packet.method_11397();
                if (matches == null) {
                    this.error("Invalid Packet.", new Object[0]);
                    return;
                }
                for (Suggestion suggestion : matches.getList()) {
                    String pluginName;
                    if (this.bukkitMode) {
                        String pluginName2 = suggestion.getText();
                        if (this.plugins.contains(pluginName2)) continue;
                        this.plugins.add(pluginName2);
                        continue;
                    }
                    String[] command = suggestion.getText().split(":");
                    if (command.length <= 1 || this.plugins.contains(pluginName = command[0].replace("/", ""))) continue;
                    this.plugins.add(pluginName);
                }
                if (this.bukkitMode) {
                    this.printPlugins();
                }
            }
        }
        catch (Exception e) {
            this.error("An error occurred while trying to find plugins.", new Object[0]);
        }
    }

    private String formatName(String name) {
        if (ANTICHEAT_LIST.contains(name.toLowerCase())) {
            return String.format("%s%s(default)", class_124.field_1061, name);
        }
        if (StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"exploit") || StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"cheat") || StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"illegal")) {
            return String.format("%s%s(default)", class_124.field_1061, name);
        }
        return String.format("(highlight)%s(default)", name);
    }

    public String formatPerms() {
        int p;
        for (p = 5; !MeteorClient.mc.field_1724.method_5687(p) && p > 0; --p) {
        }
        return switch (p) {
            case 0 -> "0 (No Perms)";
            case 1 -> "1 (No Perms)";
            case 2 -> "2 (Player Command Access)";
            case 3 -> "3 (Server Command Access)";
            case 4 -> "4 (Operator)";
            default -> p + " (Unknown)";
        };
    }
}

