/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.gui.tabs.builtin;

import baritone.api.BaritoneAPI;
import baritone.api.Settings;
import baritone.api.utils.SettingsUtil;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.tabs.Tab;
import meteordevelopment.meteorclient.gui.tabs.TabScreen;
import meteordevelopment.meteorclient.gui.tabs.WindowTabScreen;
import meteordevelopment.meteorclient.gui.widgets.input.WTextBox;
import meteordevelopment.meteorclient.settings.BlockListSetting;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.ItemListSetting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.Settings;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_437;

public class BaritoneTab
extends Tab {
    private static Settings settings;
    private static Map<String, String> descriptions;

    public BaritoneTab() {
        super("Baritone");
    }

    private static Settings getSettings() {
        if (settings != null) {
            return settings;
        }
        settings = new Settings();
        SettingGroup sgBool = settings.createGroup("Checkboxes");
        SettingGroup sgDouble = settings.createGroup("Numbers");
        SettingGroup sgInt = settings.createGroup("Whole Numbers");
        SettingGroup sgString = settings.createGroup("Strings");
        SettingGroup sgColor = settings.createGroup("Colors");
        SettingGroup sgBlockLists = settings.createGroup("Block Lists");
        SettingGroup sgItemLists = settings.createGroup("Item Lists");
        try {
            Class<?> klass = BaritoneAPI.getSettings().getClass();
            for (Field field : klass.getDeclaredFields()) {
                Object obj = field.get(BaritoneAPI.getSettings());
                if (!(obj instanceof Settings.Setting)) continue;
                Settings.Setting setting = (Settings.Setting)obj;
                Object value = setting.value;
                if (value instanceof Boolean) {
                    sgBool.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name(setting.getName())).description(BaritoneTab.getDescription(setting.getName()))).defaultValue(Boolean.valueOf((Boolean)setting.defaultValue))).onChanged(aBoolean -> {
                        setting.value = aBoolean;
                    })).onModuleActivated(booleanSetting -> booleanSetting.set((Boolean)setting.value))).build());
                    continue;
                }
                if (value instanceof Double) {
                    sgDouble.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name(setting.getName())).description(BaritoneTab.getDescription(setting.getName()))).defaultValue((Double)setting.defaultValue).onChanged(aDouble -> {
                        setting.value = aDouble;
                    })).onModuleActivated(doubleSetting -> doubleSetting.set((Double)setting.value))).build());
                    continue;
                }
                if (value instanceof Float) {
                    sgDouble.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name(setting.getName())).description(BaritoneTab.getDescription(setting.getName()))).defaultValue(((Float)setting.defaultValue).doubleValue()).onChanged(aDouble -> {
                        setting.value = Float.valueOf(aDouble.floatValue());
                    })).onModuleActivated(doubleSetting -> doubleSetting.set(((Float)setting.value).doubleValue()))).build());
                    continue;
                }
                if (value instanceof Integer) {
                    sgInt.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name(setting.getName())).description(BaritoneTab.getDescription(setting.getName()))).defaultValue(Integer.valueOf((Integer)setting.defaultValue))).onChanged(integer -> {
                        setting.value = integer;
                    })).onModuleActivated(integerSetting -> integerSetting.set((Integer)setting.value))).build());
                    continue;
                }
                if (value instanceof Long) {
                    sgInt.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name(setting.getName())).description(BaritoneTab.getDescription(setting.getName()))).defaultValue(((Long)setting.defaultValue).intValue())).onChanged(integer -> {
                        setting.value = integer.longValue();
                    })).onModuleActivated(integerSetting -> integerSetting.set(((Long)setting.value).intValue()))).build());
                    continue;
                }
                if (value instanceof String) {
                    sgString.add(((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name(setting.getName())).description(BaritoneTab.getDescription(setting.getName()))).defaultValue((String)setting.defaultValue)).onChanged(string -> {
                        setting.value = string;
                    })).onModuleActivated(stringSetting -> stringSetting.set((String)setting.value))).build());
                    continue;
                }
                if (value instanceof Color) {
                    Color c = (Color)setting.value;
                    sgColor.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name(setting.getName())).description(BaritoneTab.getDescription(setting.getName()))).defaultValue(new SettingColor(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha())).onChanged(color -> {
                        setting.value = new Color(color.r, color.g, color.b, color.a);
                    })).onModuleActivated(colorSetting -> colorSetting.set(new SettingColor(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha())))).build());
                    continue;
                }
                if (!(value instanceof List)) continue;
                Type listType = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                Type type = ((ParameterizedType)listType).getActualTypeArguments()[0];
                if (type == class_2248.class) {
                    sgBlockLists.add(((BlockListSetting.Builder)((BlockListSetting.Builder)((BlockListSetting.Builder)((BlockListSetting.Builder)((BlockListSetting.Builder)new BlockListSetting.Builder().name(setting.getName())).description(BaritoneTab.getDescription(setting.getName()))).defaultValue((List)setting.defaultValue)).onChanged(blockList -> {
                        setting.value = blockList;
                    })).onModuleActivated(blockListSetting -> blockListSetting.set((List)setting.value))).build());
                    continue;
                }
                if (type != class_1792.class) continue;
                sgItemLists.add(((ItemListSetting.Builder)((ItemListSetting.Builder)((ItemListSetting.Builder)((ItemListSetting.Builder)((ItemListSetting.Builder)new ItemListSetting.Builder().name(setting.getName())).description(BaritoneTab.getDescription(setting.getName()))).defaultValue((List)setting.defaultValue)).onChanged(itemList -> {
                    setting.value = itemList;
                })).onModuleActivated(itemListSetting -> itemListSetting.set((List)setting.value))).build());
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return settings;
    }

    @Override
    public TabScreen createScreen(GuiTheme theme) {
        return new BaritoneScreen(theme, this);
    }

    @Override
    public boolean isScreen(class_437 screen) {
        return screen instanceof BaritoneScreen;
    }

    private static void addDescription(String settingName, String description) {
        descriptions.put(settingName.toLowerCase(), description);
    }

    private static String getDescription(String settingName) {
        if (descriptions == null) {
            BaritoneTab.loadDescriptions();
        }
        return descriptions.get(settingName.toLowerCase());
    }

    private static void loadDescriptions() {
        descriptions = new HashMap<String, String>();
        BaritoneTab.addDescription("acceptableThrowawayItems", "Blocks that Baritone is allowed to place (as throwaway, for sneak bridging, pillaring, etc.)");
        BaritoneTab.addDescription("allowBreak", "Allow Baritone to break blocks");
        BaritoneTab.addDescription("allowBreakAnyway", "Blocks that baritone will be allowed to break even with allowBreak set to false");
        BaritoneTab.addDescription("allowDiagonalAscend", "Allow diagonal ascending");
        BaritoneTab.addDescription("allowDiagonalDescend", "Allow descending diagonally");
        BaritoneTab.addDescription("allowDownward", "Allow mining the block directly beneath its feet");
        BaritoneTab.addDescription("allowInventory", "Allow Baritone to move items in your inventory to your hotbar");
        BaritoneTab.addDescription("allowJumpAt256", "If true, parkour is allowed to make jumps when standing on blocks at the maximum height, so player feet is y=256");
        BaritoneTab.addDescription("allowOnlyExposedOres", "This will only allow baritone to mine exposed ores, can be used to stop ore obfuscators on servers that use them.");
        BaritoneTab.addDescription("allowOnlyExposedOresDistance", "When allowOnlyExposedOres is enabled this is the distance around to search.");
        BaritoneTab.addDescription("allowOvershootDiagonalDescend", "Is it okay to sprint through a descend followed by a diagonal? The player overshoots the landing, but not enough to fall off.");
        BaritoneTab.addDescription("allowParkour", "You know what it is");
        BaritoneTab.addDescription("allowParkourAscend", "This should be monetized it's so good");
        BaritoneTab.addDescription("allowParkourPlace", "Actually pretty reliable.");
        BaritoneTab.addDescription("allowPlace", "Allow Baritone to place blocks");
        BaritoneTab.addDescription("allowSprint", "Allow Baritone to sprint");
        BaritoneTab.addDescription("allowVines", "Enables some more advanced vine features.");
        BaritoneTab.addDescription("allowWalkOnBottomSlab", "Slab behavior is complicated, disable this for higher path reliability.");
        BaritoneTab.addDescription("allowWaterBucketFall", "Allow Baritone to fall arbitrary distances and place a water bucket beneath it.");
        BaritoneTab.addDescription("antiCheatCompatibility", "Will cause some minor behavioral differences to ensure that Baritone works on anticheats.");
        BaritoneTab.addDescription("assumeExternalAutoTool", "Disable baritone's auto-tool at runtime, but still assume that another mod will provide auto tool functionality");
        BaritoneTab.addDescription("assumeSafeWalk", "Assume safe walk functionality; don't sneak on a backplace traverse.");
        BaritoneTab.addDescription("assumeStep", "Assume step functionality; don't jump on an Ascend.");
        BaritoneTab.addDescription("assumeWalkOnLava", "If you have Fire Resistance and Jesus then I guess you could turn this on lol");
        BaritoneTab.addDescription("assumeWalkOnWater", "Allow Baritone to assume it can walk on still water just like any other block.");
        BaritoneTab.addDescription("autoTool", "Automatically select the best available tool");
        BaritoneTab.addDescription("avoidance", "Toggle the following 4 settings");
        BaritoneTab.addDescription("avoidBreakingMultiplier", "this multiplies the break speed, if set above 1 it's \"encourage breaking\" instead");
        BaritoneTab.addDescription("avoidUpdatingFallingBlocks", "If this setting is true, Baritone will never break a block that is adjacent to an unsupported falling block.");
        BaritoneTab.addDescription("axisHeight", "The \"axis\" command (aka GoalAxis) will go to a axis, or diagonal axis, at this Y level.");
        BaritoneTab.addDescription("backfill", "Fill in blocks behind you (stealth +100)");
        BaritoneTab.addDescription("backtrackCostFavoringCoefficient", "Set to 1.0 to effectively disable this feature");
        BaritoneTab.addDescription("blacklistClosestOnFailure", "When GetToBlockProcess or MineProcess fails to calculate a path, instead of just giving up, mark the closest instance of that block as \"unreachable\" and go towards the next closest.");
        BaritoneTab.addDescription("blockBreakAdditionalPenalty", "This is just a tiebreaker to make it less likely to break blocks if it can avoid it.");
        BaritoneTab.addDescription("blockPlacementPenalty", "It doesn't actually take twenty ticks to place a block, this cost is so high because we want to generally conserve blocks which might be limited.");
        BaritoneTab.addDescription("blockReachDistance", "Block reach distance");
        BaritoneTab.addDescription("blocksToAvoid", "Blocks that Baritone will attempt to avoid (Used in avoidance)");
        BaritoneTab.addDescription("blocksToAvoidBreaking", "blocks that baritone shouldn't break, but can if it needs to.");
        BaritoneTab.addDescription("blocksToDisallowBreaking", "Blocks that Baritone is not allowed to break");
        BaritoneTab.addDescription("breakCorrectBlockPenaltyMultiplier", "Multiply the cost of breaking a block that's correct in the builder's schematic by this coefficient");
        BaritoneTab.addDescription("breakFromAbove", "Allow standing above a block while mining it, in BuilderProcess");
        BaritoneTab.addDescription("builderTickScanRadius", "Distance to scan every tick for updates.");
        BaritoneTab.addDescription("buildIgnoreBlocks", "A list of blocks to be treated as if they're air.");
        BaritoneTab.addDescription("buildIgnoreDirection", "If this is true, the builder will ignore directionality of certain blocks like glazed terracotta.");
        BaritoneTab.addDescription("buildIgnoreExisting", "If this is true, the builder will treat all non-air blocks as correct.");
        BaritoneTab.addDescription("buildInLayers", "Don't consider the next layer in builder until the current one is done");
        BaritoneTab.addDescription("buildOnlySelection", "Only build the selected part of schematics");
        BaritoneTab.addDescription("buildRepeat", "How far to move before repeating the build.");
        BaritoneTab.addDescription("buildRepeatCount", "How many times to buildrepeat.");
        BaritoneTab.addDescription("buildRepeatSneaky", "Don't notify schematics that they are moved.");
        BaritoneTab.addDescription("buildSkipBlocks", "A list of blocks to be treated as correct.");
        BaritoneTab.addDescription("buildSubstitutes", "A mapping of blocks to blocks to be built instead");
        BaritoneTab.addDescription("buildValidSubstitutes", "A mapping of blocks to blocks treated as correct in their position.");
        BaritoneTab.addDescription("cachedChunksExpirySeconds", "Cached chunks (regardless of if they're in RAM or saved to disk) expire and are deleted after this number of seconds -1 to disable");
        BaritoneTab.addDescription("cachedChunksOpacity", "0.0f = not visible, fully transparent (instead of setting this to 0, turn off renderCachedChunks) 1.0f = fully opaque");
        BaritoneTab.addDescription("cancelOnGoalInvalidation", "Cancel the current path if the goal has changed, and the path originally ended in the goal but doesn't anymore.");
        BaritoneTab.addDescription("censorCoordinates", "Censor coordinates in goals and block positions");
        BaritoneTab.addDescription("censorRanCommands", "Censor arguments to ran commands, to hide, for example, coordinates to #goal");
        BaritoneTab.addDescription("chatControl", "Allow chat based control of Baritone.");
        BaritoneTab.addDescription("chatControlAnyway", "Some clients like Impact try to force chatControl to off, so here's a second setting to do it anyway");
        BaritoneTab.addDescription("chatDebug", "Print all the debug messages to chat");
        BaritoneTab.addDescription("chunkCaching", "The big one.");
        BaritoneTab.addDescription("colorBestPathSoFar", "The color of the best path so far");
        BaritoneTab.addDescription("colorBlocksToBreak", "The color of the blocks to break");
        BaritoneTab.addDescription("colorBlocksToPlace", "The color of the blocks to place");
        BaritoneTab.addDescription("colorBlocksToWalkInto", "The color of the blocks to walk into");
        BaritoneTab.addDescription("colorCurrentPath", "The color of the current path");
        BaritoneTab.addDescription("colorGoalBox", "The color of the goal box");
        BaritoneTab.addDescription("colorInvertedGoalBox", "The color of the goal box when it's inverted");
        BaritoneTab.addDescription("colorMostRecentConsidered", "The color of the path to the most recent considered node");
        BaritoneTab.addDescription("colorNextPath", "The color of the next path");
        BaritoneTab.addDescription("colorSelection", "The color of all selections");
        BaritoneTab.addDescription("colorSelectionPos1", "The color of the selection pos 1");
        BaritoneTab.addDescription("colorSelectionPos2", "The color of the selection pos 2");
        BaritoneTab.addDescription("considerPotionEffects", "For example, if you have Mining Fatigue or Haste, adjust the costs of breaking blocks accordingly.");
        BaritoneTab.addDescription("costHeuristic", "This is the big A* setting.");
        BaritoneTab.addDescription("costVerificationLookahead", "Stop 5 movements before anything that made the path COST_INF.");
        BaritoneTab.addDescription("cutoffAtLoadBoundary", "After calculating a path (potentially through cached chunks), artificially cut it off to just the part that is entirely within currently loaded chunks.");
        BaritoneTab.addDescription("desktopNotifications", "Desktop notifications");
        BaritoneTab.addDescription("disableCompletionCheck", "Turn this on if your exploration filter is enormous, you don't want it to check if it's done, and you are just fine with it just hanging on completion");
        BaritoneTab.addDescription("disconnectOnArrival", "Disconnect from the server upon arriving at your goal");
        BaritoneTab.addDescription("distanceTrim", "Trim incorrect positions too far away, helps performance but hurts reliability in very large schematics");
        BaritoneTab.addDescription("doBedWaypoints", "Allows baritone to save bed waypoints when interacting with beds");
        BaritoneTab.addDescription("doDeathWaypoints", "Allows baritone to save death waypoints");
        BaritoneTab.addDescription("echoCommands", "Echo commands to chat when they are run");
        BaritoneTab.addDescription("enterPortal", "When running a goto towards a nether portal block, walk all the way into the portal instead of stopping one block before.");
        BaritoneTab.addDescription("exploreChunkSetMinimumSize", "Take the 10 closest chunks, even if they aren't strictly tied for distance metric from origin.");
        BaritoneTab.addDescription("exploreForBlocks", "When GetToBlock or non-legit Mine doesn't know any locations for the desired block, explore randomly instead of giving up.");
        BaritoneTab.addDescription("exploreMaintainY", "Attempt to maintain Y coordinate while exploring");
        BaritoneTab.addDescription("extendCacheOnThreshold", "When the cache scan gives less blocks than the maximum threshold (but still above zero), scan the main world too.");
        BaritoneTab.addDescription("fadePath", "Start fading out the path at 20 movements ahead, and stop rendering it entirely 30 movements ahead.");
        BaritoneTab.addDescription("failureTimeoutMS", "Pathing can never take longer than this, even if that means failing to find any path at all");
        BaritoneTab.addDescription("followOffsetDirection", "The actual GoalNear is set in this direction from the entity you're following.");
        BaritoneTab.addDescription("followOffsetDistance", "The actual GoalNear is set this distance away from the entity you're following");
        BaritoneTab.addDescription("followRadius", "The radius (for the GoalNear) of how close to your target position you actually have to be");
        BaritoneTab.addDescription("forceInternalMining", "When mining block of a certain type, try to mine two at once instead of one.");
        BaritoneTab.addDescription("freeLook", "Move without having to force the client-sided rotations");
        BaritoneTab.addDescription("goalBreakFromAbove", "As well as breaking from above, set a goal to up and to the side of all blocks to break.");
        BaritoneTab.addDescription("goalRenderLineWidthPixels", "Line width of the goal when rendered, in pixels");
        BaritoneTab.addDescription("incorrectSize", "The set of incorrect blocks can never grow beyond this size");
        BaritoneTab.addDescription("internalMiningAirException", "Modification to the previous setting, only has effect if forceInternalMining is true If true, only apply the previous setting if the block adjacent to the goal isn't air.");
        BaritoneTab.addDescription("itemSaver", "Stop using tools just before they are going to break.");
        BaritoneTab.addDescription("itemSaverThreshold", "Durability to leave on the tool when using itemSaver");
        BaritoneTab.addDescription("jumpPenalty", "Additional penalty for hitting the space bar (ascend, pillar, or parkour) because it uses hunger");
        BaritoneTab.addDescription("layerHeight", "How high should the individual layers be?");
        BaritoneTab.addDescription("layerOrder", "false = build from bottom to top");
        BaritoneTab.addDescription("legitMine", "Disallow MineBehavior from using X-Ray to see where the ores are.");
        BaritoneTab.addDescription("legitMineIncludeDiagonals", "Magically see ores that are separated diagonally from existing ores.");
        BaritoneTab.addDescription("legitMineYLevel", "What Y level to go to for legit strip mining");
        BaritoneTab.addDescription("logAsToast", "Shows popup message in the upper right corner, similarly to when you make an advancement");
        BaritoneTab.addDescription("mapArtMode", "Build in map art mode, which makes baritone only care about the top block in each column");
        BaritoneTab.addDescription("maxCachedWorldScanCount", "After finding this many instances of the target block in the cache, it will stop expanding outward the chunk search.");
        BaritoneTab.addDescription("maxCostIncrease", "If a movement's cost increases by more than this amount between calculation and execution (due to changes in the environment / world), cancel and recalculate");
        BaritoneTab.addDescription("maxFallHeightBucket", "How far are you allowed to fall onto solid ground (with a water bucket)? It's not that reliable, so I've set it below what would kill an unarmored player (23)");
        BaritoneTab.addDescription("maxFallHeightNoWater", "How far are you allowed to fall onto solid ground (without a water bucket)? 3 won't deal any damage.");
        BaritoneTab.addDescription("maxPathHistoryLength", "If we are more than 300 movements into the current path, discard the oldest segments, as they are no longer useful");
        BaritoneTab.addDescription("mineDropLoiterDurationMSThanksLouca", "While mining, wait this number of milliseconds after mining an ore to see if it will drop an item instead of immediately going onto the next one");
        BaritoneTab.addDescription("mineGoalUpdateInterval", "Rescan for the goal once every 5 ticks.");
        BaritoneTab.addDescription("mineScanDroppedItems", "While mining, should it also consider dropped items of the correct type as a pathing destination (as well as ore blocks)?");
        BaritoneTab.addDescription("minimumImprovementRepropagation", "Don't repropagate cost improvements below 0.01 ticks.");
        BaritoneTab.addDescription("minYLevelWhileMining", "Sets the minimum y level whilst mining - set to 0 to turn off. if world has negative y values, subtract the min world height to get the value to put here");
        BaritoneTab.addDescription("mobAvoidanceCoefficient", "Set to 1.0 to effectively disable this feature");
        BaritoneTab.addDescription("mobAvoidanceRadius", "Distance to avoid mobs.");
        BaritoneTab.addDescription("mobSpawnerAvoidanceCoefficient", "Set to 1.0 to effectively disable this feature");
        BaritoneTab.addDescription("mobSpawnerAvoidanceRadius", "Distance to avoid mob spawners.");
        BaritoneTab.addDescription("movementTimeoutTicks", "If a movement takes this many ticks more than its initial cost estimate, cancel it");
        BaritoneTab.addDescription("notificationOnBuildFinished", "Desktop notification on build finished");
        BaritoneTab.addDescription("notificationOnExploreFinished", "Desktop notification on explore finished");
        BaritoneTab.addDescription("notificationOnFarmFail", "Desktop notification on farm fail");
        BaritoneTab.addDescription("notificationOnMineFail", "Desktop notification on mine fail");
        BaritoneTab.addDescription("notificationOnPathComplete", "Desktop notification on path complete");
        BaritoneTab.addDescription("notifier", "The function that is called when Baritone will send a desktop notification.");
        BaritoneTab.addDescription("okIfAir", "A list of blocks to become air");
        BaritoneTab.addDescription("okIfWater", "Override builder's behavior to not attempt to correct blocks that are currently water");
        BaritoneTab.addDescription("overshootTraverse", "If we overshoot a traverse and end up one block beyond the destination, mark it as successful anyway.");
        BaritoneTab.addDescription("pathCutoffFactor", "Static cutoff factor.");
        BaritoneTab.addDescription("pathCutoffMinimumLength", "Only apply static cutoff for paths of at least this length (in terms of number of movements)");
        BaritoneTab.addDescription("pathHistoryCutoffAmount", "If the current path is too long, cut off this many movements from the beginning.");
        BaritoneTab.addDescription("pathingMapDefaultSize", "Default size of the Long2ObjectOpenHashMap used in pathing");
        BaritoneTab.addDescription("pathingMapLoadFactor", "Load factor coefficient for the Long2ObjectOpenHashMap used in pathing");
        BaritoneTab.addDescription("pathingMaxChunkBorderFetch", "The maximum number of times it will fetch outside loaded or cached chunks before assuming that pathing has reached the end of the known area, and should therefore stop.");
        BaritoneTab.addDescription("pathRenderLineWidthPixels", "Line width of the path when rendered, in pixels");
        BaritoneTab.addDescription("pathThroughCachedOnly", "Exclusively use cached chunks for pathing");
        BaritoneTab.addDescription("pauseMiningForFallingBlocks", "When breaking blocks for a movement, wait until all falling blocks have settled before continuing");
        BaritoneTab.addDescription("planAheadFailureTimeoutMS", "Planning ahead while executing a segment can never take longer than this, even if that means failing to find any path at all");
        BaritoneTab.addDescription("planAheadPrimaryTimeoutMS", "Planning ahead while executing a segment ends after this amount of time, but only if a path has been found");
        BaritoneTab.addDescription("planningTickLookahead", "Start planning the next path once the remaining movements tick estimates sum up to less than this value");
        BaritoneTab.addDescription("preferSilkTouch", "Always prefer silk touch tools over regular tools.");
        BaritoneTab.addDescription("prefix", "The command prefix for chat control");
        BaritoneTab.addDescription("prefixControl", "Whether or not to allow you to run Baritone commands with the prefix");
        BaritoneTab.addDescription("primaryTimeoutMS", "Pathing ends after this amount of time, but only if a path has been found");
        BaritoneTab.addDescription("pruneRegionsFromRAM", "On save, delete from RAM any cached regions that are more than 1024 blocks away from the player");
        BaritoneTab.addDescription("randomLooking", "How many degrees to randomize the pitch and yaw every tick.");
        BaritoneTab.addDescription("randomLooking113", "How many degrees to randomize the yaw every tick. Set to 0 to disable");
        BaritoneTab.addDescription("renderCachedChunks", "Render cached chunks as semitransparent.");
        BaritoneTab.addDescription("renderGoal", "Render the goal");
        BaritoneTab.addDescription("renderGoalAnimated", "Render the goal as a sick animated thingy instead of just a box (also controls animation of GoalXZ if renderGoalXZBeacon is enabled)");
        BaritoneTab.addDescription("renderGoalIgnoreDepth", "Ignore depth when rendering the goal");
        BaritoneTab.addDescription("renderGoalXZBeacon", "Renders X/Z type Goals with the vanilla beacon beam effect.");
        BaritoneTab.addDescription("renderPath", "Render the path");
        BaritoneTab.addDescription("renderPathAsLine", "Render the path as a line instead of a frickin thingy");
        BaritoneTab.addDescription("renderPathIgnoreDepth", "Ignore depth when rendering the path");
        BaritoneTab.addDescription("renderSelection", "Render selections");
        BaritoneTab.addDescription("renderSelectionBoxes", "Render selection boxes");
        BaritoneTab.addDescription("renderSelectionBoxesIgnoreDepth", "Ignore depth when rendering the selection boxes (to break, to place, to walk into)");
        BaritoneTab.addDescription("renderSelectionCorners", "Render selection corners");
        BaritoneTab.addDescription("renderSelectionIgnoreDepth", "Ignore depth when rendering selections");
        BaritoneTab.addDescription("repackOnAnyBlockChange", "Whenever a block changes, repack the whole chunk that it's in");
        BaritoneTab.addDescription("replantCrops", "Replant normal Crops while farming and leave cactus and sugarcane to regrow");
        BaritoneTab.addDescription("replantNetherWart", "Replant nether wart while farming.");
        BaritoneTab.addDescription("rightClickContainerOnArrival", "When running a goto towards a container block (chest, ender chest, furnace, etc), right click and open it once you arrive.");
        BaritoneTab.addDescription("rightClickSpeed", "How many ticks between right clicks are allowed.");
        BaritoneTab.addDescription("schematicFallbackExtension", "The fallback used by the build command when no extension is specified.");
        BaritoneTab.addDescription("schematicOrientationX", "When this setting is true, build a schematic with the highest X coordinate being the origin, instead of the lowest");
        BaritoneTab.addDescription("schematicOrientationY", "When this setting is true, build a schematic with the highest Y coordinate being the origin, instead of the lowest");
        BaritoneTab.addDescription("schematicOrientationZ", "When this setting is true, build a schematic with the highest Z coordinate being the origin, instead of the lowest");
        BaritoneTab.addDescription("selectionLineWidth", "Line width of the goal when rendered, in pixels");
        BaritoneTab.addDescription("selectionOpacity", "The opacity of the selection.");
        BaritoneTab.addDescription("shortBaritonePrefix", "Use a short Baritone prefix [B] instead of [Baritone] when logging to chat");
        BaritoneTab.addDescription("simplifyUnloadedYCoord", "If your goal is a GoalBlock in an unloaded chunk, assume it's far enough away that the Y coord doesn't matter yet, and replace it with a GoalXZ to the same place before calculating a path.");
        BaritoneTab.addDescription("skipFailedLayers", "If a layer is unable to be constructed, just skip it.");
        BaritoneTab.addDescription("slowPath", "For debugging, consider nodes much much slower");
        BaritoneTab.addDescription("slowPathTimeDelayMS", "Milliseconds between each node");
        BaritoneTab.addDescription("slowPathTimeoutMS", "The alternative timeout number when slowPath is on");
        BaritoneTab.addDescription("splicePath", "When a new segment is calculated that doesn't overlap with the current one, but simply begins where the current segment ends, splice it on and make a longer combined path.");
        BaritoneTab.addDescription("sprintAscends", "Sprint and jump a block early on ascends wherever possible");
        BaritoneTab.addDescription("sprintInWater", "Continue sprinting while in water");
        BaritoneTab.addDescription("startAtLayer", "Start building the schematic at a specific layer.");
        BaritoneTab.addDescription("toaster", "The function that is called when Baritone will show a toast.");
        BaritoneTab.addDescription("toastTimer", "The time of how long the message in the pop-up will display");
        BaritoneTab.addDescription("useSwordToMine", "Use sword to mine.");
        BaritoneTab.addDescription("verboseCommandExceptions", "Print out ALL command exceptions as a stack trace to stdout, even simple syntax errors");
        BaritoneTab.addDescription("walkOnWaterOnePenalty", "Walking on water uses up hunger really quick, so penalize it");
        BaritoneTab.addDescription("walkWhileBreaking", "Don't stop walking forward when you need to break blocks in your way");
        BaritoneTab.addDescription("worldExploringChunkOffset", "While exploring the world, offset the closest unloaded chunk by this much in both axes.");
        BaritoneTab.addDescription("yLevelBoxSize", "The size of the box that is rendered when the current goal is a GoalYLevel");
    }

    private static class BaritoneScreen
    extends WindowTabScreen {
        public BaritoneScreen(GuiTheme theme, Tab tab) {
            super(theme, tab);
            BaritoneTab.getSettings().onActivated();
        }

        @Override
        public void initWidgets() {
            WTextBox filter = this.add(this.theme.textBox("")).minWidth(400.0).expandX().widget();
            filter.setFocused(true);
            filter.action = () -> {
                this.clear();
                this.add(filter);
                this.add(this.theme.settings(BaritoneTab.getSettings(), filter.get().trim())).expandX();
            };
            this.add(this.theme.settings(BaritoneTab.getSettings(), filter.get().trim())).expandX();
        }

        @Override
        protected void onClosed() {
            SettingsUtil.save((baritone.api.Settings)BaritoneAPI.getSettings());
        }
    }
}

