/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.gui.widgets;

import meteordevelopment.meteorclient.gui.widgets.WLabel;
import meteordevelopment.meteorclient.gui.widgets.containers.WHorizontalList;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.utils.misc.Keybind;

public class WKeybind
extends WHorizontalList {
    public Runnable action;
    public Runnable actionOnSet;
    private WLabel label;
    private final Keybind keybind;
    private final Keybind defaultValue;
    private boolean listening;

    public WKeybind(Keybind keybind, Keybind defaultValue) {
        this.keybind = keybind;
        this.defaultValue = defaultValue;
    }

    @Override
    public void init() {
        this.label = this.add(this.theme.label("")).widget();
        WButton set = this.add(this.theme.button("Set")).widget();
        set.action = () -> {
            this.listening = true;
            this.label.set("...");
            if (this.actionOnSet != null) {
                this.actionOnSet.run();
            }
        };
        this.refreshLabel();
    }

    public boolean onAction(boolean isKey, int value) {
        if (this.listening && this.keybind.canBindTo(isKey, value)) {
            this.keybind.set(isKey, value);
            this.reset();
            return true;
        }
        return false;
    }

    public void resetBind() {
        this.keybind.set(this.defaultValue);
        this.reset();
    }

    public void reset() {
        this.listening = false;
        this.refreshLabel();
        if (Modules.get().isBinding()) {
            Modules.get().setModuleToBind(null);
        }
    }

    private void refreshLabel() {
        this.label.set(this.keybind.toString());
    }
}

