/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.mixin;

import meteordevelopment.meteorclient.mixin.BufferBuilderAccessor;
import meteordevelopment.meteorclient.systems.modules.render.Xray;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_778;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_778.class})
public class BlockModelRendererMixin {
    @Unique
    private final ThreadLocal<Integer> alphas = new ThreadLocal();

    @Inject(method={"render(Lnet/minecraft/world/BlockRenderView;Lnet/minecraft/client/render/model/BakedModel;Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;ZLnet/minecraft/util/math/random/Random;JI)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRender(class_1920 world, class_1087 model, class_2680 state, class_2338 pos, class_4587 matrices, class_4588 vertexConsumer, boolean cull, class_5819 random, long seed, int overlay, CallbackInfo info) {
        int alpha = Xray.getAlpha(state, pos);
        if (alpha == 0) {
            info.cancel();
        } else {
            this.alphas.set(alpha);
        }
    }

    @Inject(method={"renderQuad(Lnet/minecraft/world/BlockRenderView;Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/render/VertexConsumer;Lnet/minecraft/client/util/math/MatrixStack$Entry;Lnet/minecraft/client/render/model/BakedQuad;FFFFIIIII)V"}, at={@At(value="TAIL")})
    private void onRenderQuad(class_1920 world, class_2680 state, class_2338 pos, class_4588 vertexConsumer, class_4587.class_4665 matrixEntry, class_777 quad, float brightness0, float brightness1, float brightness2, float brightness3, int light0, int light1, int light2, int light3, int overlay, CallbackInfo ci) {
        int alpha = this.alphas.get();
        if (alpha != -1) {
            this.rewriteBuffer(vertexConsumer, alpha);
        }
    }

    @Unique
    private void rewriteBuffer(class_4588 vertexConsumer, int alpha) {
        class_287 bufferBuilder;
        BufferBuilderAccessor bufferBuilderAccessor;
        int prevOffset;
        if (vertexConsumer instanceof class_287 && (prevOffset = (bufferBuilderAccessor = (BufferBuilderAccessor)(bufferBuilder = (class_287)vertexConsumer)).getElementOffset()) > 0) {
            int i = bufferBuilderAccessor.getVertexFormat().method_1362();
            for (int l = 1; l <= 4; ++l) {
                bufferBuilderAccessor.setElementOffset(prevOffset - i * l);
                bufferBuilder.method_22896(15, (byte)alpha);
            }
            bufferBuilderAccessor.setElementOffset(prevOffset);
        }
    }
}

