/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.regex.Pattern;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.game.ReceiveMessageEvent;
import meteordevelopment.meteorclient.mixininterface.IChatHud;
import meteordevelopment.meteorclient.mixininterface.IChatHudLine;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.misc.BetterChat;
import meteordevelopment.meteorclient.systems.modules.render.NoRender;
import meteordevelopment.meteorclient.utils.misc.MeteorIdentifier;
import meteordevelopment.meteorclient.utils.misc.text.StringCharacterVisitor;
import net.minecraft.class_1659;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_338;
import net.minecraft.class_3532;
import net.minecraft.class_408;
import net.minecraft.class_4587;
import net.minecraft.class_5224;
import net.minecraft.class_640;
import net.minecraft.class_7469;
import net.minecraft.class_7591;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_338.class})
public abstract class ChatHudMixin
implements IChatHud {
    private static final class_310 mc = class_310.method_1551();
    private static final Pattern METEOR_PREFIX_REGEX = Pattern.compile("^\\s{0,2}(<[0-9]{1,2}:[0-9]{1,2}>\\s)?\\[Meteor]");
    private static final Pattern BARITONE_PREFIX_REGEX = Pattern.compile("^\\s{0,2}(<[0-9]{1,2}:[0-9]{1,2}>\\s)?\\[Baritone]");
    private static final class_2960 METEOR_CHAT_ICON = new MeteorIdentifier("textures/icons/chat/meteor.png");
    private static final class_2960 BARITONE_CHAT_ICON = new MeteorIdentifier("textures/icons/chat/baritone.png");
    @Shadow
    @Final
    private List<class_303.class_7590> field_2064;
    @Shadow
    private int field_2066;
    @Unique
    private int nextId;
    @Unique
    private boolean skipOnAddMessage;
    @Shadow
    @Final
    private List<class_303> field_2061;

    @Override
    public void add(class_2561 message, int id) {
        this.nextId = id;
        this.method_1812(message);
        this.nextId = 0;
    }

    @Inject(method={"addMessage(Lnet/minecraft/text/Text;Lnet/minecraft/network/message/MessageSignatureData;ILnet/minecraft/client/gui/hud/MessageIndicator;Z)V"}, at={@At(value="INVOKE", target="Ljava/util/List;add(ILjava/lang/Object;)V", ordinal=0, shift=At.Shift.AFTER)})
    private void onAddMessageAfterNewChatHudLineVisible(class_2561 message, class_7469 signature, int ticks, class_7591 indicator, boolean refresh, CallbackInfo info) {
        ((IChatHudLine)this.field_2064.get(0)).setId(this.nextId);
    }

    @Inject(method={"addMessage(Lnet/minecraft/text/Text;Lnet/minecraft/network/message/MessageSignatureData;ILnet/minecraft/client/gui/hud/MessageIndicator;Z)V"}, at={@At(value="INVOKE", target="Ljava/util/List;add(ILjava/lang/Object;)V", ordinal=1, shift=At.Shift.AFTER)})
    private void onAddMessageAfterNewChatHudLine(class_2561 message, class_7469 signature, int ticks, class_7591 indicator, boolean refresh, CallbackInfo info) {
        ((IChatHudLine)this.field_2061.get(0)).setId(this.nextId);
    }

    @Inject(at={@At(value="HEAD")}, method={"addMessage(Lnet/minecraft/text/Text;Lnet/minecraft/network/message/MessageSignatureData;ILnet/minecraft/client/gui/hud/MessageIndicator;Z)V"}, cancellable=true)
    private void onAddMessage(class_2561 message, @Nullable class_7469 signature, int ticks, @Nullable class_7591 indicator, boolean refresh, CallbackInfo info) {
        if (this.skipOnAddMessage) {
            return;
        }
        ReceiveMessageEvent event = MeteorClient.EVENT_BUS.post(ReceiveMessageEvent.get(message, indicator, this.nextId));
        if (event.isCancelled()) {
            info.cancel();
        } else {
            this.field_2064.removeIf(msg -> ((IChatHudLine)msg).getId() == this.nextId && this.nextId != 0);
            this.field_2061.removeIf(msg -> ((IChatHudLine)msg).getId() == this.nextId && this.nextId != 0);
            if (event.isModified()) {
                info.cancel();
                this.skipOnAddMessage = true;
                this.method_1815(event.getMessage(), signature, ticks, event.getIndicator(), refresh);
                this.skipOnAddMessage = false;
            }
        }
    }

    @ModifyExpressionValue(method={"addMessage(Lnet/minecraft/text/Text;Lnet/minecraft/network/message/MessageSignatureData;ILnet/minecraft/client/gui/hud/MessageIndicator;Z)V"}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/client/gui/hud/ChatHud;visibleMessages:Ljava/util/List;"))}, at={@At(value="INVOKE", target="Ljava/util/List;size()I")})
    private int addMessageListSizeProxy(int size) {
        BetterChat betterChat = Modules.get().get(BetterChat.class);
        if (betterChat.isLongerChat() && betterChat.getChatLength() >= 100) {
            return size - betterChat.getChatLength();
        }
        return size;
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRender(class_4587 matrices, int currentTick, int mouseX, int mouseY, CallbackInfo info) {
        if (!Modules.get().get(BetterChat.class).displayPlayerHeads()) {
            return;
        }
        if (ChatHudMixin.mc.field_1690.method_42539().method_41753() == class_1659.field_7536) {
            return;
        }
        int maxLineCount = ChatHudMixin.mc.field_1705.method_1743().method_1813();
        double d = (Double)ChatHudMixin.mc.field_1690.method_42542().method_41753() * (double)0.9f + (double)0.1f;
        double g = 9.0 * ((Double)ChatHudMixin.mc.field_1690.method_42546().method_41753() + 1.0);
        double h = -8.0 * ((Double)ChatHudMixin.mc.field_1690.method_42546().method_41753() + 1.0) + 4.0 * (Double)ChatHudMixin.mc.field_1690.method_42546().method_41753() + 8.0;
        float chatScale = (float)this.method_1814();
        float scaledHeight = mc.method_22683().method_4502();
        matrices.method_22903();
        matrices.method_22905(chatScale, chatScale, 1.0f);
        matrices.method_22904(2.0, (double)class_3532.method_15375((float)((scaledHeight - 40.0f) / chatScale)) - g - (double)0.1f, 10.0);
        RenderSystem.enableBlend();
        for (int m = 0; m + this.field_2066 < this.field_2064.size() && m < maxLineCount; ++m) {
            double o;
            int x;
            class_303.class_7590 chatHudLine = this.field_2064.get(m + this.field_2066);
            if (chatHudLine == null || (x = currentTick - chatHudLine.comp_895()) >= 200 && !this.isChatFocused()) continue;
            double d2 = o = this.isChatFocused() ? 1.0 : ChatHudMixin.method_19348(x);
            if (!(o * d > 0.01)) continue;
            double s = (double)(-m) * g;
            StringCharacterVisitor visitor = new StringCharacterVisitor();
            chatHudLine.comp_896().accept((class_5224)visitor);
            this.drawIcon(matrices, visitor.result.toString(), (int)(s + h), (float)(o * d));
        }
        RenderSystem.disableBlend();
        matrices.method_22909();
    }

    private boolean isChatFocused() {
        return ChatHudMixin.mc.field_1755 instanceof class_408;
    }

    @Shadow
    private static double method_19348(int age) {
        throw new AssertionError();
    }

    @Shadow
    protected abstract void method_1815(class_2561 var1, @Nullable class_7469 var2, int var3, @Nullable class_7591 var4, boolean var5);

    @Shadow
    public abstract void method_1812(class_2561 var1);

    @Shadow
    public abstract double method_1814();

    private void drawIcon(class_4587 matrices, String line, int y, float opacity) {
        if (METEOR_PREFIX_REGEX.matcher(line).find()) {
            RenderSystem.setShaderTexture((int)0, (class_2960)METEOR_CHAT_ICON);
            matrices.method_22903();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
            matrices.method_46416(0.0f, (float)y, 0.0f);
            matrices.method_22905(0.125f, 0.125f, 1.0f);
            class_332.method_25290((class_4587)matrices, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)64, (int)64, (int)64, (int)64);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrices.method_22909();
            return;
        }
        if (BARITONE_PREFIX_REGEX.matcher(line).find()) {
            RenderSystem.setShaderTexture((int)0, (class_2960)BARITONE_CHAT_ICON);
            matrices.method_22903();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
            matrices.method_46416(0.0f, (float)y, 10.0f);
            matrices.method_22905(0.125f, 0.125f, 1.0f);
            class_332.method_25290((class_4587)matrices, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)64, (int)64, (int)64, (int)64);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrices.method_22909();
            return;
        }
        class_2960 skin = ChatHudMixin.getMessageTexture(line);
        if (skin != null) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
            RenderSystem.setShaderTexture((int)0, (class_2960)skin);
            class_332.method_25293((class_4587)matrices, (int)0, (int)y, (int)8, (int)8, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            class_332.method_25293((class_4587)matrices, (int)0, (int)y, (int)8, (int)8, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static class_2960 getMessageTexture(String message) {
        if (mc.method_1562() == null) {
            return null;
        }
        for (String part : message.split("(\u00a7.)|[^\\w]")) {
            class_640 p;
            if (part.isBlank() || (p = mc.method_1562().method_2874(part)) == null) continue;
            return p.method_2968();
        }
        return null;
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/hud/ChatHudLine$Visible;indicator()Lnet/minecraft/client/gui/hud/MessageIndicator;"))
    private class_7591 onMessageIndicator(class_303.class_7590 message) {
        return Modules.get().get(NoRender.class).noMessageSignatureIndicator() ? null : message.comp_897();
    }
}

