/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.mixin;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.timeout.TimeoutException;
import java.net.InetSocketAddress;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.ConnectToServerEvent;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.misc.AntiPacketKick;
import meteordevelopment.meteorclient.systems.modules.world.HighwayBuilder;
import meteordevelopment.meteorclient.systems.proxies.Proxies;
import meteordevelopment.meteorclient.systems.proxies.Proxy;
import net.minecraft.class_124;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2548;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_5250;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2535.class})
public class ClientConnectionMixin {
    @Inject(method={"handlePacket"}, at={@At(value="HEAD")}, cancellable=true)
    private static <T extends class_2547> void onHandlePacket(class_2596<T> packet, class_2547 listener, CallbackInfo info) {
        if (MeteorClient.EVENT_BUS.post(PacketEvent.Receive.get(packet)).isCancelled()) {
            info.cancel();
        }
    }

    @Inject(method={"disconnect"}, at={@At(value="HEAD")})
    private void disconnect(class_2561 disconnectReason, CallbackInfo ci) {
        if (Modules.get().get(HighwayBuilder.class).isActive()) {
            class_5250 text = class_2561.method_43470((String)String.format("\n\n%s[%sHighway Builder%s] Statistics:", class_124.field_1080, class_124.field_1078, class_124.field_1080)).method_27693("\n");
            text.method_10852((class_2561)Modules.get().get(HighwayBuilder.class).getStatsText());
            ((class_5250)disconnectReason).method_10852((class_2561)text);
        }
    }

    @Inject(method={"connect"}, at={@At(value="HEAD")})
    private static void onConnect(InetSocketAddress address, boolean useEpoll, CallbackInfoReturnable<class_2535> info) {
        MeteorClient.EVENT_BUS.post(ConnectToServerEvent.get(address));
    }

    @Inject(at={@At(value="HEAD")}, method={"send(Lnet/minecraft/network/packet/Packet;)V"}, cancellable=true)
    private void onSendPacketHead(class_2596<?> packet, CallbackInfo info) {
        if (MeteorClient.EVENT_BUS.post(PacketEvent.Send.get(packet)).isCancelled()) {
            info.cancel();
        }
    }

    @Inject(method={"send(Lnet/minecraft/network/packet/Packet;)V"}, at={@At(value="TAIL")})
    private void onSendPacketTail(class_2596<?> packet, CallbackInfo info) {
        MeteorClient.EVENT_BUS.post(PacketEvent.Sent.get(packet));
    }

    @Inject(method={"exceptionCaught"}, at={@At(value="HEAD")}, cancellable=true)
    private void exceptionCaught(ChannelHandlerContext context, Throwable throwable, CallbackInfo ci) {
        AntiPacketKick apk = Modules.get().get(AntiPacketKick.class);
        if (!(throwable instanceof TimeoutException) && !(throwable instanceof class_2548) && apk.catchExceptions()) {
            if (apk.logExceptions.get().booleanValue()) {
                apk.warning("Caught exception: %s", throwable);
            }
            ci.cancel();
        }
    }

    @Inject(method={"addHandlers"}, at={@At(value="RETURN")})
    private static void onAddHandlers(ChannelPipeline pipeline, class_2598 side, CallbackInfo ci) {
        if (side != class_2598.field_11942) {
            return;
        }
        Proxy proxy = Proxies.get().getEnabled();
        if (proxy == null) {
            return;
        }
        switch (proxy.type.get()) {
            case Socks4: {
                pipeline.addFirst(new ChannelHandler[]{new Socks4ProxyHandler(new InetSocketAddress(proxy.address.get(), (int)proxy.port.get()), proxy.username.get())});
                break;
            }
            case Socks5: {
                pipeline.addFirst(new ChannelHandler[]{new Socks5ProxyHandler(new InetSocketAddress(proxy.address.get(), (int)proxy.port.get()), proxy.username.get(), proxy.password.get())});
            }
        }
    }
}

