/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.mixin;

import java.util.List;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.systems.hud.Hud;
import meteordevelopment.meteorclient.systems.hud.HudElement;
import meteordevelopment.meteorclient.systems.hud.elements.TextHud;
import meteordevelopment.meteorclient.systems.modules.Category;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.Modules;
import net.minecraft.class_128;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_128.class})
public class CrashReportMixin {
    @Inject(method={"addStackTrace"}, at={@At(value="TAIL")})
    private void onAddStackTrace(StringBuilder sb, CallbackInfo info) {
        sb.append("\n\n-- Meteor Client --\n\n");
        sb.append("Version: ").append(MeteorClient.VERSION).append("\n");
        if (!MeteorClient.DEV_BUILD.isEmpty()) {
            sb.append("Dev Build: ").append(MeteorClient.DEV_BUILD).append("\n");
        }
        if (Modules.get() != null) {
            boolean modulesActive = false;
            for (Category category : Modules.loopCategories()) {
                List<Module> modules = Modules.get().getGroup(category);
                boolean categoryActive = false;
                for (Module module : modules) {
                    if (module == null || !module.isActive()) continue;
                    if (!modulesActive) {
                        modulesActive = true;
                        sb.append("\n[[ Active Modules ]]\n");
                    }
                    if (!categoryActive) {
                        categoryActive = true;
                        sb.append("\n[").append(category).append("]:\n");
                    }
                    sb.append(module.name).append("\n");
                }
            }
        }
        if (Hud.get() != null && Hud.get().active) {
            boolean hudActive = false;
            for (HudElement element : Hud.get()) {
                if (element == null || !element.isActive()) continue;
                if (!hudActive) {
                    hudActive = true;
                    sb.append("\n[[ Active Hud Elements ]]\n");
                }
                if (!(element instanceof TextHud)) {
                    sb.append(element.info.name).append("\n");
                    continue;
                }
                TextHud textHud = (TextHud)element;
                sb.append("Text\n{").append(textHud.text.get()).append("}\n");
                if (textHud.shown.get() == TextHud.Shown.Always) continue;
                sb.append("(").append((Object)textHud.shown.get()).append(textHud.condition.get()).append(")\n");
            }
        }
    }
}

