/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.mixin;

import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.render.BlockSelection;
import meteordevelopment.meteorclient.systems.modules.render.ESP;
import meteordevelopment.meteorclient.systems.modules.render.Freecam;
import meteordevelopment.meteorclient.systems.modules.render.Fullbright;
import meteordevelopment.meteorclient.systems.modules.render.NoRender;
import meteordevelopment.meteorclient.systems.modules.world.Ambience;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.meteorclient.utils.render.postprocess.EntityShader;
import meteordevelopment.meteorclient.utils.render.postprocess.PostProcessShaders;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_761.class})
public abstract class WorldRendererMixin {
    @Shadow
    private class_276 field_4101;

    @Shadow
    protected abstract void method_22977(class_1297 var1, double var2, double var4, double var6, float var8, class_4587 var9, class_4597 var10);

    @Inject(method={"checkEmpty"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCheckEmpty(class_4587 matrixStack, CallbackInfo info) {
        info.cancel();
    }

    @Inject(method={"drawBlockOutline"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDrawHighlightedBlockOutline(class_4587 matrixStack, class_4588 vertexConsumer, class_1297 entity, double d, double e, double f, class_2338 blockPos, class_2680 blockState, CallbackInfo info) {
        if (Modules.get().isActive(BlockSelection.class)) {
            info.cancel();
        }
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/WorldRenderer;setupTerrain(Lnet/minecraft/client/render/Camera;Lnet/minecraft/client/render/Frustum;ZZ)V"), index=3)
    private boolean renderSetupTerrainModifyArg(boolean spectator) {
        return Modules.get().isActive(Freecam.class) || spectator;
    }

    @Inject(method={"renderWeather"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderWeather(class_765 manager, float f, double d, double e, double g, CallbackInfo info) {
        if (Modules.get().get(NoRender.class).noWeather()) {
            info.cancel();
        }
    }

    @Inject(method={"hasBlindnessOrDarkness(Lnet/minecraft/client/render/Camera;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void hasBlindnessOrDarkness(class_4184 camera, CallbackInfoReturnable<Boolean> info) {
        if (Modules.get().get(NoRender.class).noBlindness() || Modules.get().get(NoRender.class).noDarkness()) {
            info.setReturnValue(null);
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void onRenderHead(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, Matrix4f matrix4f, CallbackInfo info) {
        PostProcessShaders.beginRender();
    }

    @Inject(method={"renderEntity"}, at={@At(value="HEAD")})
    private void renderEntity(class_1297 entity, double cameraX, double cameraY, double cameraZ, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, CallbackInfo info) {
        this.draw(entity, cameraX, cameraY, cameraZ, tickDelta, vertexConsumers, matrices, PostProcessShaders.CHAMS, Color.WHITE);
        this.draw(entity, cameraX, cameraY, cameraZ, tickDelta, vertexConsumers, matrices, PostProcessShaders.ENTITY_OUTLINE, Modules.get().get(ESP.class).getColor(entity));
    }

    @Unique
    private void draw(class_1297 entity, double cameraX, double cameraY, double cameraZ, float tickDelta, class_4597 vertexConsumers, class_4587 matrices, EntityShader shader, Color color) {
        if (shader.shouldDraw(entity) && !PostProcessShaders.isCustom(vertexConsumers) && color != null) {
            class_276 prevBuffer = this.field_4101;
            this.field_4101 = shader.framebuffer;
            PostProcessShaders.rendering = true;
            shader.vertexConsumerProvider.method_23286(color.r, color.g, color.b, color.a);
            this.method_22977(entity, cameraX, cameraY, cameraZ, tickDelta, matrices, (class_4597)shader.vertexConsumerProvider);
            PostProcessShaders.rendering = false;
            this.field_4101 = prevBuffer;
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/OutlineVertexConsumerProvider;draw()V")})
    private void onRender(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, Matrix4f matrix4f, CallbackInfo info) {
        PostProcessShaders.endRender();
    }

    @Inject(method={"onResized"}, at={@At(value="HEAD")})
    private void onResized(int width, int height, CallbackInfo info) {
        PostProcessShaders.onResized(width, height);
    }

    @Inject(method={"renderEndSky"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/Tessellator;draw()V")})
    private void onRenderEndSkyDraw(class_4587 matrices, CallbackInfo info) {
        Ambience ambience = Modules.get().get(Ambience.class);
        if (ambience.isActive() && ambience.endSky.get().booleanValue() && ambience.customSkyColor.get().booleanValue()) {
            SettingColor customEndSkyColor = ambience.skyColor();
            class_289 tessellator = class_289.method_1348();
            class_287 bufferBuilder = tessellator.method_1349();
            Matrix4f matrix4f = matrices.method_23760().method_23761();
            bufferBuilder.method_1343();
            bufferBuilder.method_22918(matrix4f, -100.0f, -100.0f, -100.0f).method_22913(0.0f, 0.0f).method_1336(customEndSkyColor.r, customEndSkyColor.g, customEndSkyColor.b, 255).method_1344();
            bufferBuilder.method_22918(matrix4f, -100.0f, -100.0f, 100.0f).method_22913(0.0f, 16.0f).method_1336(customEndSkyColor.r, customEndSkyColor.g, customEndSkyColor.b, 255).method_1344();
            bufferBuilder.method_22918(matrix4f, 100.0f, -100.0f, 100.0f).method_22913(16.0f, 16.0f).method_1336(customEndSkyColor.r, customEndSkyColor.g, customEndSkyColor.b, 255).method_1344();
            bufferBuilder.method_22918(matrix4f, 100.0f, -100.0f, -100.0f).method_22913(16.0f, 0.0f).method_1336(customEndSkyColor.r, customEndSkyColor.g, customEndSkyColor.b, 255).method_1344();
        }
    }

    @ModifyVariable(method={"getLightmapCoordinates(Lnet/minecraft/world/BlockRenderView;Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;)I"}, at=@At(value="STORE"), ordinal=0)
    private static int getLightmapCoordinatesModifySkyLight(int sky) {
        return Math.max(Modules.get().get(Fullbright.class).getLuminance(), sky);
    }
}

