/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.mixin.indigo;

import java.util.function.Function;
import meteordevelopment.meteorclient.systems.modules.render.Xray;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractQuadRenderer;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.minecraft.class_1921;
import net.minecraft.class_4588;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractQuadRenderer.class}, remap=false)
public abstract class AbstractQuadRendererMixin {
    @Final
    @Shadow
    protected BlockRenderInfo blockInfo;
    @Final
    @Shadow
    protected Function<class_1921, class_4588> bufferFunc;
    @Final
    @Shadow
    protected Vector3f normalVec;

    @Shadow
    protected abstract Matrix3f normalMatrix();

    @Shadow
    protected abstract Matrix4f matrix();

    @Shadow
    protected abstract int overlay();

    @Inject(method={"bufferQuad(Lnet/fabricmc/fabric/impl/client/indigo/renderer/mesh/MutableQuadViewImpl;Lnet/minecraft/client/render/RenderLayer;)V"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    private void onBufferQuad(MutableQuadViewImpl quad, class_1921 renderLayer, CallbackInfo info) {
        int alpha = Xray.getAlpha(this.blockInfo.blockState, this.blockInfo.blockPos);
        if (alpha == 0) {
            info.cancel();
        } else if (alpha != -1) {
            this.whBufferQuad(this.bufferFunc.apply(renderLayer), quad, this.matrix(), this.overlay(), this.normalMatrix(), this.normalVec, alpha);
            info.cancel();
        }
    }

    @Unique
    private void whBufferQuad(class_4588 buff, MutableQuadViewImpl quad, Matrix4f matrix, int overlay, Matrix3f normalMatrix, Vector3f normalVec, int alpha) {
        boolean useNormals = quad.hasVertexNormals();
        if (useNormals) {
            quad.populateMissingNormals();
        } else {
            Vector3f faceNormal = quad.faceNormal();
            normalVec.set(faceNormal.x, faceNormal.y, faceNormal.z);
            normalVec.mul((Matrix3fc)normalMatrix);
        }
        for (int i = 0; i < 4; ++i) {
            buff.method_22918(matrix, quad.x(i), quad.y(i), quad.z(i));
            int color = quad.spriteColor(i, 0);
            buff.method_1336(color & 0xFF, color >> 8 & 0xFF, color >> 16 & 0xFF, alpha);
            buff.method_22913(quad.spriteU(i, 0), quad.spriteV(i, 0));
            buff.method_22922(overlay);
            buff.method_22916(quad.lightmap(i));
            if (useNormals) {
                normalVec.set(quad.normalX(i), quad.normalY(i), quad.normalZ(i));
                normalVec.mul((Matrix3fc)normalMatrix);
            }
            buff.method_22914(normalVec.x, normalVec.y, normalVec.z);
            buff.method_1344();
        }
    }
}

