/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.mixin.sodium;

import me.jellysquid.mods.sodium.client.model.IndexBufferBuilder;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadOrientation;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderer;
import me.jellysquid.mods.sodium.client.render.vertex.type.ChunkVertexBufferBuilder;
import me.jellysquid.mods.sodium.client.render.vertex.type.ChunkVertexEncoder;
import meteordevelopment.meteorclient.systems.modules.render.Xray;
import net.minecraft.class_243;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={BlockRenderer.class}, remap=false)
public class SodiumBlockRendererMixin {
    @Unique
    private final ThreadLocal<Integer> alphas = new ThreadLocal();

    @Inject(method={"renderModel"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderModel(BlockRenderContext ctx, ChunkModelBuilder buffers, CallbackInfoReturnable<Boolean> info) {
        int alpha = Xray.getAlpha(ctx.state(), ctx.pos());
        if (alpha == 0) {
            info.setReturnValue((Object)false);
        } else {
            this.alphas.set(alpha);
        }
    }

    @Inject(method={"writeGeometry"}, at={@At(value="FIELD", target="Lme/jellysquid/mods/sodium/client/render/vertex/type/ChunkVertexEncoder$Vertex;color:I", opcode=181, shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void setColor(BlockRenderContext ctx, ChunkVertexBufferBuilder vertexBuffer, IndexBufferBuilder indexBuffer, class_243 offset, ModelQuadView quad, int[] colors, float[] brightness, int[] lightmap, CallbackInfo info, ModelQuadOrientation orientation, ChunkVertexEncoder.Vertex[] vertices, int dstIndex, int srcIndex, ChunkVertexEncoder.Vertex out) {
        int alpha = this.alphas.get();
        if (alpha == 0) {
            info.cancel();
        } else if (alpha != -1) {
            out.color &= 0xFFFFFF;
            out.color |= alpha << 24;
        }
    }
}

