/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.mixin.sodium;

import java.util.Arrays;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.blender.ColorSampler;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.FluidRenderer;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.color.ColorARGB;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.render.Xray;
import meteordevelopment.meteorclient.systems.modules.world.Ambience;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FluidRenderer.class}, remap=false)
public class SodiumFluidRendererMixin {
    @Final
    @Shadow
    private int[] quadColors;
    @Unique
    private final ThreadLocal<Integer> alphas = new ThreadLocal();

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRender(class_1920 world, class_3610 fluidState, class_2338 pos, class_2338 offset, ChunkModelBuilder buffers, CallbackInfoReturnable<Boolean> info) {
        int alpha = Xray.getAlpha(fluidState.method_15759(), pos);
        if (alpha == 0) {
            info.setReturnValue((Object)false);
        } else {
            this.alphas.set(alpha);
        }
    }

    @Inject(method={"updateQuad"}, at={@At(value="TAIL")})
    private void onUpdateQuad(ModelQuadView quad, class_1920 world, class_2338 pos, LightPipeline lighter, class_2350 dir, float brightness, ColorSampler<class_3610> colorSampler, class_3610 fluidState, CallbackInfo info) {
        Ambience ambience = Modules.get().get(Ambience.class);
        if (ambience.isActive() && ambience.customLavaColor.get().booleanValue() && fluidState.method_15767(class_3486.field_15518)) {
            Arrays.fill(this.quadColors, ColorARGB.toABGR((int)ambience.lavaColor.get().getPacked()));
        } else {
            int alpha = this.alphas.get();
            for (int i = 0; i < this.quadColors.length; ++i) {
                this.quadColors[i] = ColorABGR.withAlpha((int)this.quadColors[i], (float)((float)alpha / 255.0f));
            }
        }
    }
}

