/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.settings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import meteordevelopment.meteorclient.settings.IVisible;
import meteordevelopment.meteorclient.settings.Setting;
import net.minecraft.class_1792;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ItemListSetting
extends Setting<List<class_1792>> {
    public final Predicate<class_1792> filter;
    private final boolean bypassFilterWhenSavingAndLoading;

    public ItemListSetting(String name, String description, List<class_1792> defaultValue, Consumer<List<class_1792>> onChanged, Consumer<Setting<List<class_1792>>> onModuleActivated, IVisible visible, Predicate<class_1792> filter, boolean bypassFilterWhenSavingAndLoading) {
        super(name, description, defaultValue, onChanged, onModuleActivated, visible);
        this.filter = filter;
        this.bypassFilterWhenSavingAndLoading = bypassFilterWhenSavingAndLoading;
    }

    @Override
    protected List<class_1792> parseImpl(String str) {
        String[] values = str.split(",");
        ArrayList<class_1792> items = new ArrayList<class_1792>(values.length);
        try {
            for (String value : values) {
                class_1792 item = (class_1792)ItemListSetting.parseId(class_7923.field_41178, value);
                if (item == null || this.filter != null && !this.filter.test(item)) continue;
                items.add(item);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return items;
    }

    @Override
    public void resetImpl() {
        this.value = new ArrayList((Collection)this.defaultValue);
    }

    @Override
    protected boolean isValueValid(List<class_1792> value) {
        return true;
    }

    @Override
    public Iterable<class_2960> getIdentifierSuggestions() {
        return class_7923.field_41178.method_10235();
    }

    @Override
    public class_2487 save(class_2487 tag) {
        class_2499 valueTag = new class_2499();
        for (class_1792 item : (List)this.get()) {
            if (!this.bypassFilterWhenSavingAndLoading && this.filter != null && !this.filter.test(item)) continue;
            valueTag.add((Object)class_2519.method_23256((String)class_7923.field_41178.method_10221((Object)item).toString()));
        }
        tag.method_10566("value", (class_2520)valueTag);
        return tag;
    }

    @Override
    public List<class_1792> load(class_2487 tag) {
        ((List)this.get()).clear();
        class_2499 valueTag = tag.method_10554("value", 8);
        for (class_2520 tagI : valueTag) {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(tagI.method_10714()));
            if (!this.bypassFilterWhenSavingAndLoading && this.filter != null && !this.filter.test(item)) continue;
            ((List)this.get()).add(item);
        }
        return (List)this.get();
    }

    public static class Builder
    extends Setting.SettingBuilder<Builder, List<class_1792>, ItemListSetting> {
        private Predicate<class_1792> filter;
        private boolean bypassFilterWhenSavingAndLoading;

        public Builder() {
            super(new ArrayList(0));
        }

        @Override
        public Builder defaultValue(class_1792 ... defaults) {
            return (Builder)this.defaultValue(defaults != null ? Arrays.asList(defaults) : new ArrayList());
        }

        public Builder filter(Predicate<class_1792> filter) {
            this.filter = filter;
            return this;
        }

        public Builder bypassFilterWhenSavingAndLoading() {
            this.bypassFilterWhenSavingAndLoading = true;
            return this;
        }

        @Override
        public ItemListSetting build() {
            return new ItemListSetting(this.name, this.description, (List)this.defaultValue, this.onChanged, this.onModuleActivated, this.visible, this.filter, this.bypassFilterWhenSavingAndLoading);
        }
    }
}

