/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.accounts;

import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.ServicesKeyInfo;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.nio.file.Path;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.mixin.MinecraftClientAccessor;
import meteordevelopment.meteorclient.mixin.PlayerSkinProviderAccessor;
import meteordevelopment.meteorclient.systems.accounts.AccountCache;
import meteordevelopment.meteorclient.systems.accounts.AccountType;
import meteordevelopment.meteorclient.utils.misc.ISerializable;
import meteordevelopment.meteorclient.utils.misc.NbtException;
import net.minecraft.class_1071;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_320;
import net.minecraft.class_5520;
import net.minecraft.class_7500;
import net.minecraft.class_7569;
import net.minecraft.class_7574;
import net.minecraft.class_7853;

public abstract class Account<T extends Account<?>>
implements ISerializable<T> {
    protected AccountType type;
    protected String name;
    protected final AccountCache cache;

    public Account(AccountType type, String name) {
        this.type = type;
        this.name = name;
        this.cache = new AccountCache();
    }

    public abstract boolean fetchInfo();

    public boolean login() {
        YggdrasilAuthenticationService authenticationService = new YggdrasilAuthenticationService(((MinecraftClientAccessor)MeteorClient.mc).getProxy());
        Account.applyLoginEnvironment(authenticationService, authenticationService.createMinecraftSessionService());
        return true;
    }

    public String getUsername() {
        if (this.cache.username.isEmpty()) {
            return this.name;
        }
        return this.cache.username;
    }

    public AccountType getType() {
        return this.type;
    }

    public AccountCache getCache() {
        return this.cache;
    }

    public static void setSession(class_320 session) {
        UserApiService apiService;
        MinecraftClientAccessor mca = (MinecraftClientAccessor)MeteorClient.mc;
        mca.setSession(session);
        MeteorClient.mc.method_1539().clear();
        try {
            apiService = mca.getAuthenticationService().createUserApiService(session.method_1674());
        }
        catch (AuthenticationException e) {
            apiService = UserApiService.OFFLINE;
        }
        mca.setUserApiService(apiService);
        mca.setSocialInteractionsManager(new class_5520(MeteorClient.mc, apiService));
        mca.setProfileKeys(class_7853.method_46532((UserApiService)apiService, (class_320)session, (Path)MeteorClient.mc.field_1697.toPath()));
        mca.setAbuseReportContext(class_7574.method_44599((class_7569)class_7569.method_44586(), (UserApiService)apiService));
    }

    public static void applyLoginEnvironment(YggdrasilAuthenticationService authService, MinecraftSessionService sessService) {
        MinecraftClientAccessor mca = (MinecraftClientAccessor)MeteorClient.mc;
        mca.setAuthenticationService(authService);
        mca.setServicesSignatureVerifier(class_7500.method_44172((ServicesKeyInfo)authService.getServicesKey()));
        mca.setSessionService(sessService);
        mca.setSkinProvider(new class_1071(MeteorClient.mc.method_1531(), ((PlayerSkinProviderAccessor)MeteorClient.mc.method_1582()).getSkinCacheDir(), sessService));
    }

    @Override
    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10582("type", this.type.name());
        tag.method_10582("name", this.name);
        tag.method_10566("cache", (class_2520)this.cache.toTag());
        return tag;
    }

    @Override
    public T fromTag(class_2487 tag) {
        if (!tag.method_10545("name") || !tag.method_10545("cache")) {
            throw new NbtException();
        }
        this.name = tag.method_10558("name");
        this.cache.fromTag(tag.method_10562("cache"));
        return (T)this;
    }
}

