/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.accounts.types;

import com.mojang.authlib.Environment;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.lang.reflect.Type;
import java.util.Optional;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.mixin.MinecraftClientAccessor;
import meteordevelopment.meteorclient.mixin.YggdrasilMinecraftSessionServiceAccessor;
import meteordevelopment.meteorclient.systems.accounts.Account;
import meteordevelopment.meteorclient.systems.accounts.AccountType;
import meteordevelopment.meteorclient.utils.network.Http;
import net.minecraft.class_320;

public class EasyMCAccount
extends Account<EasyMCAccount> {
    private static final Environment ENVIRONMENT = Environment.create((String)"https://authserver.mojang.com", (String)"https://api.mojang.com", (String)"https://sessionserver.easymc.io", (String)"https://api.minecraftservices.com", (String)"EasyMC");
    private static final YggdrasilAuthenticationService SERVICE = new YggdrasilAuthenticationService(((MinecraftClientAccessor)MeteorClient.mc).getProxy(), "", ENVIRONMENT);

    public EasyMCAccount(String token) {
        super(AccountType.EasyMC, token);
    }

    @Override
    public boolean fetchInfo() {
        if (this.name.length() == 43) {
            return true;
        }
        AuthResponse res = (AuthResponse)Http.post("https://api.easymc.io/v1/token/redeem").bodyJson("{\"token\":\"" + this.name + "\"}").sendJson((Type)((Object)AuthResponse.class));
        if (res != null) {
            this.cache.username = res.mcName;
            this.cache.uuid = res.uuid;
            this.name = res.session;
            return true;
        }
        return false;
    }

    @Override
    public boolean login() {
        EasyMCAccount.applyLoginEnvironment(SERVICE, (MinecraftSessionService)YggdrasilMinecraftSessionServiceAccessor.createYggdrasilMinecraftSessionService(SERVICE, ENVIRONMENT));
        EasyMCAccount.setSession(new class_320(this.cache.username, this.cache.uuid, this.name, Optional.empty(), Optional.empty(), class_320.class_321.field_1988));
        this.cache.loadHead();
        return true;
    }

    private static class AuthResponse {
        public String mcName;
        public String uuid;
        public String session;
        public String message;

        private AuthResponse() {
        }
    }
}

