/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.hud.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.ItemSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.hud.Hud;
import meteordevelopment.meteorclient.systems.hud.HudElement;
import meteordevelopment.meteorclient.systems.hud.HudElementInfo;
import meteordevelopment.meteorclient.systems.hud.HudRenderer;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_4587;

public class ItemHud
extends HudElement {
    public static HudElementInfo<ItemHud> INFO = new HudElementInfo<ItemHud>(Hud.GROUP, "item", "Displays the item count.", ItemHud::new);
    private static final class_4587 MATRICES = new class_4587();
    private final SettingGroup sgGeneral;
    private final SettingGroup sgBackground;
    private final Setting<class_1792> item;
    private final Setting<NoneMode> noneMode;
    private final Setting<Double> scale;
    private final Setting<Integer> border;
    private final Setting<Boolean> background;
    private final Setting<SettingColor> backgroundColor;

    private ItemHud() {
        super(INFO);
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgBackground = this.settings.createGroup("Background");
        this.item = this.sgGeneral.add(((ItemSetting.Builder)((ItemSetting.Builder)((ItemSetting.Builder)new ItemSetting.Builder().name("item")).description("Item to display")).defaultValue(class_1802.field_8288)).build());
        this.noneMode = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("none-mode")).description("How to render the item when you don't have the specified item in your inventory.")).defaultValue(NoneMode.HideCount)).build());
        this.scale = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("scale")).description("Scale of the item.")).defaultValue(2.0).onChanged(aDouble -> this.calculateSize())).min(1.0).sliderRange(1.0, 4.0).build());
        this.border = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("border")).description("How much space to add around the element.")).defaultValue(0)).onChanged(integer -> this.calculateSize())).build());
        this.background = this.sgBackground.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("background")).description("Displays background.")).defaultValue(false)).build());
        this.backgroundColor = this.sgBackground.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("background-color")).description("Color used for the background.")).visible(this.background::get)).defaultValue(new SettingColor(25, 25, 25, 50)).build());
        this.calculateSize();
    }

    @Override
    public void setSize(double width, double height) {
        super.setSize(width + (double)(this.border.get() * 2), height + (double)(this.border.get() * 2));
    }

    private void calculateSize() {
        this.setSize(17.0 * this.scale.get(), 17.0 * this.scale.get());
    }

    @Override
    public void render(HudRenderer renderer) {
        class_1799 itemStack = new class_1799((class_1935)this.item.get(), InvUtils.find(this.item.get()).count());
        if (this.noneMode.get() == NoneMode.HideItem && itemStack.method_7960()) {
            if (this.isInEditor()) {
                renderer.line(this.x, this.y, this.x + this.getWidth(), this.y + this.getHeight(), Color.GRAY);
                renderer.line(this.x, this.y + this.getHeight(), this.x + this.getWidth(), this.y, Color.GRAY);
            }
        } else {
            renderer.post(() -> {
                class_4587 matrices = RenderSystem.getModelViewStack();
                matrices.method_22903();
                matrices.method_22905(this.scale.get().floatValue(), this.scale.get().floatValue(), 1.0f);
                double x = this.x + this.border.get();
                double y = this.y + this.border.get();
                this.render(itemStack, (int)(x / this.scale.get()), (int)(y / this.scale.get()));
                matrices.method_22909();
            });
        }
        if (this.background.get().booleanValue()) {
            renderer.quad(this.x, this.y, this.getWidth(), this.getHeight(), this.backgroundColor.get());
        }
    }

    private void render(class_1799 itemStack, int x, int y) {
        switch (this.noneMode.get()) {
            case HideItem: {
                MeteorClient.mc.method_1480().method_4010(MATRICES, itemStack, x, y);
                MeteorClient.mc.method_1480().method_4022(MATRICES, MeteorClient.mc.field_1772, itemStack, x, y, Integer.toString(itemStack.method_7947()));
                break;
            }
            case HideCount: {
                if (itemStack.method_7947() == 0) {
                    itemStack.method_7939(Integer.MAX_VALUE);
                }
                MeteorClient.mc.method_1480().method_4010(MATRICES, itemStack, x, y);
                if (itemStack.method_7947() == Integer.MAX_VALUE) {
                    itemStack.method_7939(0);
                }
                if (itemStack.method_7960()) break;
                MeteorClient.mc.method_1480().method_4022(MATRICES, MeteorClient.mc.field_1772, itemStack, x, y, Integer.toString(itemStack.method_7947()));
                break;
            }
            case ShowCount: {
                if (itemStack.method_7947() == 0) {
                    itemStack.method_7939(Integer.MAX_VALUE);
                }
                MeteorClient.mc.method_1480().method_4010(MATRICES, itemStack, x, y);
                MeteorClient.mc.method_1480().method_4022(MATRICES, MeteorClient.mc.field_1772, itemStack, x, y, Integer.toString(itemStack.method_7947() == Integer.MAX_VALUE ? 0 : itemStack.method_7947()));
                if (itemStack.method_7947() != Integer.MAX_VALUE) break;
                itemStack.method_7939(0);
            }
        }
    }

    public static enum NoneMode {
        HideItem,
        HideCount,
        ShowCount;


        public String toString() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case HideItem -> "Hide Item";
                case HideCount -> "Hide Count";
                case ShowCount -> "Show Count";
            };
        }
    }
}

