/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.hud.elements;

import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.hud.Hud;
import meteordevelopment.meteorclient.systems.hud.HudElement;
import meteordevelopment.meteorclient.systems.hud.HudElementInfo;
import meteordevelopment.meteorclient.systems.hud.HudRenderer;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import net.minecraft.class_1309;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_490;
import net.minecraft.class_746;

public class PlayerModelHud
extends HudElement {
    public static final HudElementInfo<PlayerModelHud> INFO = new HudElementInfo<PlayerModelHud>(Hud.GROUP, "player-model", "Displays a model of your player.", PlayerModelHud::new);
    private static final class_4587 MATRICES = new class_4587();
    private final SettingGroup sgGeneral;
    private final SettingGroup sgBackground;
    private final Setting<Double> scale;
    private final Setting<Boolean> copyYaw;
    private final Setting<Boolean> copyPitch;
    private final Setting<Integer> customYaw;
    private final Setting<Integer> customPitch;
    private final Setting<Boolean> background;
    private final Setting<SettingColor> backgroundColor;

    public PlayerModelHud() {
        super(INFO);
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgBackground = this.settings.createGroup("Background");
        this.scale = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("scale")).description("The scale.")).defaultValue(2.0).min(1.0).sliderRange(1.0, 5.0).build());
        this.copyYaw = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("copy-yaw")).description("Makes the player model's yaw equal to yours.")).defaultValue(true)).build());
        this.copyPitch = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("copy-pitch")).description("Makes the player model's pitch equal to yours.")).defaultValue(true)).build());
        this.customYaw = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("custom-yaw")).description("Custom yaw for when copy yaw is off.")).defaultValue(0)).range(-180, 180).sliderRange(-180, 180).visible(() -> this.copyYaw.get() == false)).build());
        this.customPitch = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("custom-pitch")).description("Custom pitch for when copy pitch is off.")).defaultValue(0)).range(-90, 90).sliderRange(-90, 90).visible(() -> this.copyPitch.get() == false)).build());
        this.background = this.sgBackground.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("background")).description("Displays background.")).defaultValue(false)).build());
        this.backgroundColor = this.sgBackground.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("background-color")).description("Color used for the background.")).visible(this.background::get)).defaultValue(new SettingColor(25, 25, 25, 50)).build());
    }

    @Override
    public void render(HudRenderer renderer) {
        this.setSize(50.0 * this.scale.get(), 75.0 * this.scale.get());
        renderer.post(() -> {
            class_746 player = MeteorClient.mc.field_1724;
            if (player == null) {
                return;
            }
            float yaw = this.copyYaw.get() != false ? class_3532.method_15393((float)(player.field_5982 + (player.method_36454() - player.field_5982) * MeteorClient.mc.method_1488())) : (float)this.customYaw.get().intValue();
            float pitch = this.copyPitch.get() != false ? player.method_36455() : (float)this.customPitch.get().intValue();
            class_490.method_2486((class_4587)MATRICES, (int)((int)((double)this.x + 25.0 * this.scale.get())), (int)((int)((double)this.y + 66.0 * this.scale.get())), (int)((int)(30.0 * this.scale.get())), (float)(-yaw), (float)(-pitch), (class_1309)player);
        });
        if (this.background.get().booleanValue()) {
            renderer.quad(this.x, this.y, this.getWidth(), this.getHeight(), this.backgroundColor.get());
        }
    }
}

