/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.hud.elements;

import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.hud.Alignment;
import meteordevelopment.meteorclient.systems.hud.Hud;
import meteordevelopment.meteorclient.systems.hud.HudElement;
import meteordevelopment.meteorclient.systems.hud.HudElementInfo;
import meteordevelopment.meteorclient.systems.hud.HudRenderer;
import meteordevelopment.meteorclient.utils.misc.Names;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;

public class PotionTimersHud
extends HudElement {
    public static final HudElementInfo<PotionTimersHud> INFO = new HudElementInfo<PotionTimersHud>(Hud.GROUP, "potion-timers", "Displays active potion effects with timers.", PotionTimersHud::new);
    private final SettingGroup sgGeneral;
    private final SettingGroup sgScale;
    private final SettingGroup sgBackground;
    private final Setting<Boolean> shadow;
    private final Setting<Alignment> alignment;
    private final Setting<Integer> border;
    private final Setting<Boolean> customScale;
    private final Setting<Double> scale;
    private final Setting<Boolean> background;
    private final Setting<SettingColor> backgroundColor;
    private final Color color;

    public PotionTimersHud() {
        super(INFO);
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgScale = this.settings.createGroup("Scale");
        this.sgBackground = this.settings.createGroup("Background");
        this.shadow = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("shadow")).description("Renders shadow behind text.")).defaultValue(true)).build());
        this.alignment = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("alignment")).description("Horizontal alignment.")).defaultValue(Alignment.Auto)).build());
        this.border = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("border")).description("How much space to add around the element.")).defaultValue(0)).build());
        this.customScale = this.sgScale.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("custom-scale")).description("Applies custom text scale rather than the global one.")).defaultValue(false)).build());
        this.scale = this.sgScale.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("scale")).description("Custom scale.")).visible(this.customScale::get)).defaultValue(1.0).min(0.5).sliderRange(0.5, 3.0).build());
        this.background = this.sgBackground.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("background")).description("Displays background.")).defaultValue(false)).build());
        this.backgroundColor = this.sgBackground.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("background-color")).description("Color used for the background.")).visible(this.background::get)).defaultValue(new SettingColor(25, 25, 25, 50)).build());
        this.color = new Color();
    }

    @Override
    public void setSize(double width, double height) {
        super.setSize(width + (double)(this.border.get() * 2), height + (double)(this.border.get() * 2));
    }

    @Override
    protected double alignX(double width, Alignment alignment) {
        return this.box.alignX(this.getWidth() - this.border.get() * 2, width, alignment);
    }

    @Override
    public void tick(HudRenderer renderer) {
        if (MeteorClient.mc.field_1724 == null || this.isInEditor()) {
            this.setSize(renderer.textWidth("Potion Timers 0:00", this.shadow.get(), this.getScale()), renderer.textHeight(this.shadow.get(), this.getScale()));
            return;
        }
        double width = 0.0;
        double height = 0.0;
        for (class_1293 statusEffectInstance : MeteorClient.mc.field_1724.method_6026()) {
            width = Math.max(width, renderer.textWidth(this.getString(statusEffectInstance), this.shadow.get(), this.getScale()));
            height += renderer.textHeight(this.shadow.get(), this.getScale());
        }
        this.setSize(width, height);
    }

    @Override
    public void render(HudRenderer renderer) {
        double x = this.x + this.border.get();
        double y = this.y + this.border.get();
        if (this.background.get().booleanValue()) {
            renderer.quad(this.x, this.y, this.getWidth(), this.getHeight(), this.backgroundColor.get());
        }
        if (MeteorClient.mc.field_1724 == null || this.isInEditor()) {
            renderer.text("Potion Timers 0:00", x, y, this.color, this.shadow.get(), this.getScale());
            return;
        }
        for (class_1293 statusEffectInstance : MeteorClient.mc.field_1724.method_6026()) {
            class_1291 statusEffect = statusEffectInstance.method_5579();
            int c = statusEffect.method_5556();
            this.color.r = Color.toRGBAR(c);
            this.color.g = Color.toRGBAG(c);
            this.color.b = Color.toRGBAB(c);
            String text = this.getString(statusEffectInstance);
            renderer.text(text, x + this.alignX(renderer.textWidth(text, this.shadow.get(), this.getScale()), this.alignment.get()), y, this.color, this.shadow.get(), this.getScale());
            this.color.b = 255;
            this.color.g = 255;
            this.color.r = 255;
            y += renderer.textHeight(this.shadow.get(), this.getScale());
        }
    }

    private String getString(class_1293 statusEffectInstance) {
        return String.format("%s %d (%s)", Names.get(statusEffectInstance.method_5579()), statusEffectInstance.method_5578() + 1, class_1292.method_5577((class_1293)statusEffectInstance, (float)1.0f).getString());
    }

    private double getScale() {
        return this.customScale.get() != false ? this.scale.get() : -1.0;
    }
}

