/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.combat;

import java.util.ArrayList;
import java.util.List;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BlockListSetting;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.entity.EntityUtils;
import meteordevelopment.meteorclient.utils.entity.SortPriority;
import meteordevelopment.meteorclient.utils.entity.TargetUtils;
import meteordevelopment.meteorclient.utils.player.FindItemResult;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.meteorclient.utils.world.BlockUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;

public class AutoTrap
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgRender;
    private final Setting<List<class_2248>> blocks;
    private final Setting<Integer> range;
    private final Setting<SortPriority> priority;
    private final Setting<Integer> delay;
    private final Setting<TopMode> topPlacement;
    private final Setting<BottomMode> bottomPlacement;
    private final Setting<Boolean> selfToggle;
    private final Setting<Boolean> rotate;
    private final Setting<Boolean> render;
    private final Setting<ShapeMode> shapeMode;
    private final Setting<SettingColor> sideColor;
    private final Setting<SettingColor> lineColor;
    private final Setting<SettingColor> nextSideColor;
    private final Setting<SettingColor> nextLineColor;
    private final List<class_2338> placePositions;
    private class_1657 target;
    private boolean placed;
    private int timer;

    public AutoTrap() {
        super(Categories.Combat, "auto-trap", "Traps people in a box to prevent them from moving.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgRender = this.settings.createGroup("Render");
        this.blocks = this.sgGeneral.add(((BlockListSetting.Builder)((BlockListSetting.Builder)new BlockListSetting.Builder().name("whitelist")).description("Which blocks to use.")).defaultValue(class_2246.field_10540, class_2246.field_22108).build());
        this.range = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("target-range")).description("The range players can be targeted.")).defaultValue(4)).build());
        this.priority = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("target-priority")).description("How to select the player to target.")).defaultValue(SortPriority.LowestHealth)).build());
        this.delay = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("place-delay")).description("How many ticks between block placements.")).defaultValue(1)).build());
        this.topPlacement = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("top-blocks")).description("Which blocks to place on the top half of the target.")).defaultValue(TopMode.Full)).build());
        this.bottomPlacement = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("bottom-blocks")).description("Which blocks to place on the bottom half of the target.")).defaultValue(BottomMode.Platform)).build());
        this.selfToggle = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("self-toggle")).description("Turns off after placing all blocks.")).defaultValue(true)).build());
        this.rotate = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("rotate")).description("Rotates towards blocks when placing.")).defaultValue(true)).build());
        this.render = this.sgRender.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("render")).description("Renders an overlay where blocks will be placed.")).defaultValue(true)).build());
        this.shapeMode = this.sgRender.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("How the shapes are rendered.")).defaultValue(ShapeMode.Both)).build());
        this.sideColor = this.sgRender.add(((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("side-color")).description("The side color of the target block rendering.")).defaultValue(new SettingColor(197, 137, 232, 10)).build());
        this.lineColor = this.sgRender.add(((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("line-color")).description("The line color of the target block rendering.")).defaultValue(new SettingColor(197, 137, 232)).build());
        this.nextSideColor = this.sgRender.add(((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("next-side-color")).description("The side color of the next block to be placed.")).defaultValue(new SettingColor(227, 196, 245, 10)).build());
        this.nextLineColor = this.sgRender.add(((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("next-line-color")).description("The line color of the next block to be placed.")).defaultValue(new SettingColor(227, 196, 245)).build());
        this.placePositions = new ArrayList<class_2338>();
    }

    @Override
    public void onActivate() {
        this.target = null;
        this.placePositions.clear();
        this.timer = 0;
        this.placed = false;
    }

    @Override
    public void onDeactivate() {
        this.placePositions.clear();
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.selfToggle.get().booleanValue() && this.placed && this.placePositions.isEmpty()) {
            this.placed = false;
            this.toggle();
            return;
        }
        for (class_2248 currentBlock : this.blocks.get()) {
            FindItemResult itemResult = InvUtils.findInHotbar(currentBlock.method_8389());
            if (!itemResult.isHotbar() && !itemResult.isOffhand()) {
                this.placePositions.clear();
                this.placed = false;
                continue;
            }
            if (TargetUtils.isBadTarget(this.target, this.range.get().intValue())) {
                this.target = TargetUtils.getPlayerTarget(this.range.get().intValue(), this.priority.get());
                if (TargetUtils.isBadTarget(this.target, this.range.get().intValue())) {
                    return;
                }
            }
            this.fillPlaceArray(this.target);
            if (this.timer >= this.delay.get() && this.placePositions.size() > 0) {
                class_2338 blockPos = this.placePositions.get(this.placePositions.size() - 1);
                if (BlockUtils.place(blockPos, itemResult, this.rotate.get(), 50, true)) {
                    this.placePositions.remove(blockPos);
                    this.placed = true;
                }
                this.timer = 0;
            } else {
                ++this.timer;
            }
            return;
        }
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (!this.render.get().booleanValue() || this.placePositions.isEmpty()) {
            return;
        }
        for (class_2338 pos : this.placePositions) {
            boolean isFirst = pos.equals((Object)this.placePositions.get(this.placePositions.size() - 1));
            Color side = isFirst ? (Color)this.nextSideColor.get() : (Color)this.sideColor.get();
            Color line = isFirst ? (Color)this.nextLineColor.get() : (Color)this.lineColor.get();
            event.renderer.box(pos, side, line, this.shapeMode.get(), 0);
        }
    }

    private void fillPlaceArray(class_1657 target) {
        this.placePositions.clear();
        class_2338 targetPos = target.method_24515();
        switch (this.topPlacement.get()) {
            case Full: {
                this.add(targetPos.method_10069(0, 2, 0));
                this.add(targetPos.method_10069(1, 1, 0));
                this.add(targetPos.method_10069(-1, 1, 0));
                this.add(targetPos.method_10069(0, 1, 1));
                this.add(targetPos.method_10069(0, 1, -1));
                break;
            }
            case Face: {
                this.add(targetPos.method_10069(1, 1, 0));
                this.add(targetPos.method_10069(-1, 1, 0));
                this.add(targetPos.method_10069(0, 1, 1));
                this.add(targetPos.method_10069(0, 1, -1));
                break;
            }
            case Top: {
                this.add(targetPos.method_10069(0, 2, 0));
            }
        }
        switch (this.bottomPlacement.get()) {
            case Platform: {
                this.add(targetPos.method_10069(0, -1, 0));
                this.add(targetPos.method_10069(1, -1, 0));
                this.add(targetPos.method_10069(-1, -1, 0));
                this.add(targetPos.method_10069(0, -1, 1));
                this.add(targetPos.method_10069(0, -1, -1));
                break;
            }
            case Full: {
                this.add(targetPos.method_10069(1, 0, 0));
                this.add(targetPos.method_10069(-1, 0, 0));
                this.add(targetPos.method_10069(0, 0, -1));
                this.add(targetPos.method_10069(0, 0, 1));
                break;
            }
            case Single: {
                this.add(targetPos.method_10069(0, -1, 0));
            }
        }
    }

    private void add(class_2338 blockPos) {
        if (!this.placePositions.contains(blockPos) && BlockUtils.canPlace(blockPos)) {
            this.placePositions.add(blockPos);
        }
    }

    @Override
    public String getInfoString() {
        return EntityUtils.getName((class_1297)this.target);
    }

    public static enum TopMode {
        Full,
        Top,
        Face,
        None;

    }

    public static enum BottomMode {
        Single,
        Platform,
        Full,
        None;

    }
}

