/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.misc;

import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.friends.Friends;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.player.DamageUtils;
import meteordevelopment.meteorclient.utils.player.PlayerUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1511;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2661;

public class AutoLog
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Integer> health;
    private final Setting<Boolean> smart;
    private final Setting<Boolean> onlyTrusted;
    private final Setting<Boolean> instantDeath;
    private final Setting<Boolean> crystalLog;
    private final Setting<Integer> range;
    private final Setting<Boolean> smartToggle;
    private final Setting<Boolean> toggleOff;
    private final StaticListener staticListener;

    public AutoLog() {
        super(Categories.Combat, "auto-log", "Automatically disconnects you when certain requirements are met.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.health = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("health")).description("Automatically disconnects when health is lower or equal to this value.")).defaultValue(6)).range(0, 19).sliderMax(19).build());
        this.smart = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("smart")).description("Disconnects when you're about to take enough damage to kill you.")).defaultValue(true)).build());
        this.onlyTrusted = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("only-trusted")).description("Disconnects when a player not on your friends list appears in render distance.")).defaultValue(false)).build());
        this.instantDeath = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("32K")).description("Disconnects when a player near you can instantly kill you.")).defaultValue(false)).build());
        this.crystalLog = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("crystal-nearby")).description("Disconnects when a crystal appears near you.")).defaultValue(false)).build());
        this.range = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("range")).description("How close a crystal has to be to you before you disconnect.")).defaultValue(4)).range(1, 10).sliderMax(5).visible(this.crystalLog::get)).build());
        this.smartToggle = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("smart-toggle")).description("Disables Auto Log after a low-health logout. WILL re-enable once you heal.")).defaultValue(false)).build());
        this.toggleOff = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("toggle-off")).description("Disables Auto Log after usage.")).defaultValue(true)).build());
        this.staticListener = new StaticListener();
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        float playerHealth = this.mc.field_1724.method_6032();
        if (playerHealth <= 0.0f) {
            this.toggle();
            return;
        }
        if (playerHealth <= (float)this.health.get().intValue()) {
            this.mc.field_1724.field_3944.method_11083(new class_2661((class_2561)class_2561.method_43470((String)("[AutoLog] Health was lower than " + this.health.get() + "."))));
            if (this.smartToggle.get().booleanValue()) {
                this.toggle();
                this.enableHealthListener();
            }
        }
        if (this.smart.get().booleanValue() && (double)(playerHealth + this.mc.field_1724.method_6067()) - PlayerUtils.possibleHealthReductions() < (double)this.health.get().intValue()) {
            this.mc.field_1724.field_3944.method_11083(new class_2661((class_2561)class_2561.method_43470((String)("[AutoLog] Health was going to be lower than " + this.health.get() + "."))));
            if (this.toggleOff.get().booleanValue()) {
                this.toggle();
            }
        }
        for (class_1297 entity : this.mc.field_1687.method_18112()) {
            if (entity instanceof class_1657 && entity.method_5667() != this.mc.field_1724.method_5667()) {
                if (this.onlyTrusted.get().booleanValue() && entity != this.mc.field_1724 && !Friends.get().isFriend((class_1657)entity)) {
                    this.mc.field_1724.field_3944.method_11083(new class_2661((class_2561)class_2561.method_43470((String)"[AutoLog] A non-trusted player appeared in your render distance.")));
                    if (!this.toggleOff.get().booleanValue()) break;
                    this.toggle();
                    break;
                }
                if (PlayerUtils.isWithin(entity, 8.0) && this.instantDeath.get().booleanValue() && DamageUtils.getSwordDamage((class_1657)entity, true) > (double)(playerHealth + this.mc.field_1724.method_6067())) {
                    this.mc.field_1724.field_3944.method_11083(new class_2661((class_2561)class_2561.method_43470((String)"[AutoLog] Anti-32k measures.")));
                    if (!this.toggleOff.get().booleanValue()) break;
                    this.toggle();
                    break;
                }
            }
            if (!(entity instanceof class_1511) || !PlayerUtils.isWithin(entity, (double)this.range.get().intValue()) || !this.crystalLog.get().booleanValue()) continue;
            this.mc.field_1724.field_3944.method_11083(new class_2661((class_2561)class_2561.method_43470((String)"[AutoLog] End Crystal appeared within specified range.")));
            if (!this.toggleOff.get().booleanValue()) continue;
            this.toggle();
        }
    }

    private void enableHealthListener() {
        MeteorClient.EVENT_BUS.subscribe(this.staticListener);
    }

    private void disableHealthListener() {
        MeteorClient.EVENT_BUS.unsubscribe(this.staticListener);
    }

    private class StaticListener {
        private StaticListener() {
        }

        @EventHandler
        private void healthListener(TickEvent.Post event) {
            if (AutoLog.this.isActive()) {
                AutoLog.this.disableHealthListener();
            } else if (Utils.canUpdate() && !((AutoLog)AutoLog.this).mc.field_1724.method_29504() && ((AutoLog)AutoLog.this).mc.field_1724.method_6032() > (float)AutoLog.this.health.get().intValue()) {
                AutoLog.this.toggle();
                AutoLog.this.disableHealthListener();
            }
        }
    }
}

