/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.misc;

import it.unimi.dsi.fastutil.chars.Char2CharMap;
import it.unimi.dsi.fastutil.chars.Char2CharOpenHashMap;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import meteordevelopment.meteorclient.commands.Commands;
import meteordevelopment.meteorclient.events.game.ReceiveMessageEvent;
import meteordevelopment.meteorclient.events.game.SendMessageEvent;
import meteordevelopment.meteorclient.mixin.ChatHudAccessor;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringListSetting;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_303;
import net.minecraft.class_327;
import net.minecraft.class_341;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public class BetterChat
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgFilter;
    private final SettingGroup sgLongerChat;
    private final SettingGroup sgPrefix;
    private final SettingGroup sgSuffix;
    private final Setting<Boolean> annoy;
    private final Setting<Boolean> fancy;
    private final Setting<Boolean> timestamps;
    private final Setting<Boolean> playerHeads;
    private final Setting<Boolean> coordsProtection;
    private final Setting<Boolean> keepHistory;
    private final Setting<Boolean> antiSpam;
    private final Setting<Integer> antiSpamDepth;
    private final Setting<Boolean> filterRegex;
    private final Setting<List<String>> regexFilters;
    private final Setting<Boolean> infiniteChatBox;
    private final Setting<Boolean> longerChatHistory;
    private final Setting<Integer> longerChatLines;
    private final Setting<Boolean> prefix;
    private final Setting<Boolean> prefixRandom;
    private final Setting<String> prefixText;
    private final Setting<Boolean> prefixSmallCaps;
    private final Setting<Boolean> suffix;
    private final Setting<Boolean> suffixRandom;
    private final Setting<String> suffixText;
    private final Setting<Boolean> suffixSmallCaps;
    private static final Pattern antiSpamRegex = Pattern.compile(".*(\\([0-9]+\\)$)");
    private static final Pattern timestampRegex = Pattern.compile("^(<[0-9]{2}:[0-9]{2}>\\s)");
    private final Char2CharMap SMALL_CAPS;
    private final SimpleDateFormat dateFormat;
    private final List<Pattern> filterRegexList;
    private static final Pattern coordRegex = Pattern.compile("(?<x>-?\\d{3,}(?:\\.\\d*)?)(?:\\s+(?<y>-?\\d{1,3}(?:\\.\\d*)?))?\\s+(?<z>-?\\d{3,}(?:\\.\\d*)?)");

    public BetterChat() {
        super(Categories.Misc, "better-chat", "Improves your chat experience in various ways.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgFilter = this.settings.createGroup("Filter");
        this.sgLongerChat = this.settings.createGroup("Longer Chat");
        this.sgPrefix = this.settings.createGroup("Prefix");
        this.sgSuffix = this.settings.createGroup("Suffix");
        this.annoy = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("annoy")).description("Makes your messages aNnOyInG.")).defaultValue(false)).build());
        this.fancy = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("fancy-chat")).description("Makes your messages \u0493\u1d00\u0274\u1d04\u028f!")).defaultValue(false)).build());
        this.timestamps = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("timestamps")).description("Adds client-side time stamps to the beginning of chat messages.")).defaultValue(false)).build());
        this.playerHeads = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("player-heads")).description("Displays player heads next to their messages.")).defaultValue(true)).build());
        this.coordsProtection = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("coords-protection")).description("Prevents you from sending messages in chat that may contain coordinates.")).defaultValue(true)).build());
        this.keepHistory = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("keep-history")).description("Prevents the chat history from being cleared when disconnecting.")).defaultValue(true)).build());
        this.antiSpam = this.sgFilter.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("anti-spam")).description("Blocks duplicate messages from filling your chat.")).defaultValue(true)).build());
        this.antiSpamDepth = this.sgFilter.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("depth")).description("How many messages to filter.")).defaultValue(20)).min(1).sliderMin(1).visible(this.antiSpam::get)).build());
        this.filterRegex = this.sgFilter.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("filter-regex")).description("Filter out chat messages that match the regex filter.")).defaultValue(false)).build());
        this.regexFilters = this.sgFilter.add(((StringListSetting.Builder)((StringListSetting.Builder)((StringListSetting.Builder)((StringListSetting.Builder)new StringListSetting.Builder().name("regex-filter")).description("Regex filter used for filtering chat messages.")).visible(this.filterRegex::get)).onChanged(strings -> this.compileFilterRegexList())).build());
        this.infiniteChatBox = this.sgLongerChat.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("infinite-chat-box")).description("Lets you type infinitely long messages.")).defaultValue(true)).build());
        this.longerChatHistory = this.sgLongerChat.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("longer-chat-history")).description("Extends chat length.")).defaultValue(true)).build());
        this.longerChatLines = this.sgLongerChat.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("extra-lines")).description("The amount of extra chat lines.")).defaultValue(1000)).min(100).sliderRange(100, 1000).visible(this.longerChatHistory::get)).build());
        this.prefix = this.sgPrefix.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("prefix")).description("Adds a prefix to your chat messages.")).defaultValue(false)).build());
        this.prefixRandom = this.sgPrefix.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("random")).description("Uses a random number as your prefix.")).defaultValue(false)).build());
        this.prefixText = this.sgPrefix.add(((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("text")).description("The text to add as your prefix.")).defaultValue("> ")).visible(() -> this.prefixRandom.get() == false)).build());
        this.prefixSmallCaps = this.sgPrefix.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("small-caps")).description("Uses small caps in the prefix.")).defaultValue(false)).visible(() -> this.prefixRandom.get() == false)).build());
        this.suffix = this.sgSuffix.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("suffix")).description("Adds a suffix to your chat messages.")).defaultValue(false)).build());
        this.suffixRandom = this.sgSuffix.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("random")).description("Uses a random number as your suffix.")).defaultValue(false)).build());
        this.suffixText = this.sgSuffix.add(((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("text")).description("The text to add as your suffix.")).defaultValue(" | meteor on crack!")).visible(() -> this.suffixRandom.get() == false)).build());
        this.suffixSmallCaps = this.sgSuffix.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("small-caps")).description("Uses small caps in the suffix.")).defaultValue(true)).visible(() -> this.suffixRandom.get() == false)).build());
        this.SMALL_CAPS = new Char2CharOpenHashMap();
        this.dateFormat = new SimpleDateFormat("HH:mm");
        this.filterRegexList = new ArrayList<Pattern>();
        String[] a = "abcdefghijklmnopqrstuvwxyz".split("");
        String[] b = "\u1d00\u0299\u1d04\u1d05\u1d07\ua730\u0262\u029c\u026a\u1d0a\u1d0b\u029f\u1d0d\u0274\u1d0f\u1d29q\u0280\ua731\u1d1b\u1d1c\u1d20\u1d21xy\u1d22".split("");
        for (int i = 0; i < a.length; ++i) {
            this.SMALL_CAPS.put(a[i].charAt(0), b[i].charAt(0));
        }
        this.compileFilterRegexList();
    }

    @EventHandler
    private void onMessageReceive(ReceiveMessageEvent event) {
        class_2561 antiSpammed;
        class_2561 message = event.getMessage();
        if (this.filterRegex.get().booleanValue()) {
            for (Pattern pattern : this.filterRegexList) {
                if (!pattern.matcher(message.getString()).find()) continue;
                event.cancel();
                return;
            }
        }
        if (this.timestamps.get().booleanValue()) {
            Matcher matcher = timestampRegex.matcher(message.getString());
            if (matcher.matches()) {
                message.method_10855().subList(0, 8).clear();
            }
            class_5250 timestamp = class_2561.method_43470((String)("<" + this.dateFormat.format(new Date()) + "> ")).method_27692(class_124.field_1080);
            message = class_2561.method_43470((String)"").method_10852((class_2561)timestamp).method_10852(message);
        }
        if (this.playerHeads.get().booleanValue()) {
            message = class_2561.method_43470((String)"  ").method_10852(message);
        }
        if (this.antiSpam.get().booleanValue() && (antiSpammed = this.appendAntiSpam(message)) != null) {
            message = antiSpammed;
        }
        event.setMessage(message);
    }

    private class_2561 appendAntiSpam(class_2561 text) {
        class_5250 returnText = null;
        int messageIndex = -1;
        class_5250 originalMessage = null;
        for (int i = 0; i < this.antiSpamDepth.get(); ++i) {
            String newMessage;
            List<class_303> messages = ((ChatHudAccessor)this.mc.field_1705.method_1743()).getMessages();
            if (messages.isEmpty() || i > messages.size() - 1) {
                return null;
            }
            class_5250 message = messages.get(i).comp_893().method_27661();
            String oldMessage = message.getString();
            if (oldMessage.equals(newMessage = text.getString())) {
                originalMessage = message.method_27661();
                messageIndex = i;
                returnText = message.method_10852((class_2561)class_2561.method_43470((String)" (2)").method_27692(class_124.field_1080));
                break;
            }
            Matcher matcher = antiSpamRegex.matcher(oldMessage);
            if (!matcher.matches()) continue;
            String group = matcher.group(matcher.groupCount());
            int number = Integer.parseInt(group.substring(1, group.length() - 1));
            String counter = " (" + number + ")";
            if (!oldMessage.substring(0, oldMessage.length() - counter.length()).equals(newMessage)) continue;
            message.method_10855().remove(message.method_10855().size() - 1);
            originalMessage = message.method_27661();
            messageIndex = i;
            returnText = message.method_10852((class_2561)class_2561.method_43470((String)(" (" + (number + 1) + ")")).method_27692(class_124.field_1080));
            break;
        }
        if (returnText != null) {
            ((ChatHudAccessor)this.mc.field_1705.method_1743()).getMessages().remove(messageIndex);
            List list = class_341.method_1850(originalMessage, (int)class_3532.method_15357((double)((double)this.mc.field_1705.method_1743().method_1811() / this.mc.field_1705.method_1743().method_1814())), (class_327)this.mc.field_1772);
            List<class_303.class_7590> visibleMessages = ((ChatHudAccessor)this.mc.field_1705.method_1743()).getVisibleMessages();
            int lines = Math.min(list.size(), visibleMessages.size());
            for (int i = 0; i < lines; ++i) {
                visibleMessages.remove(messageIndex);
            }
        }
        return returnText;
    }

    @EventHandler
    private void onMessageSend(SendMessageEvent event) {
        Object message = event.message;
        if (this.annoy.get().booleanValue()) {
            message = this.applyAnnoy((String)message);
        }
        if (this.fancy.get().booleanValue()) {
            message = this.applyFancy((String)message);
        }
        message = this.getPrefix() + (String)message + this.getSuffix();
        if (this.coordsProtection.get().booleanValue() && this.containsCoordinates((String)message)) {
            class_5250 warningMessage = class_2561.method_43470((String)"It looks like there are coordinates in your message! ");
            class_5250 sendButton = this.getSendButton((String)message);
            warningMessage.method_10852((class_2561)sendButton);
            ChatUtils.sendMsg((class_2561)warningMessage);
            event.cancel();
            return;
        }
        event.message = message;
    }

    private String applyAnnoy(String message) {
        StringBuilder sb = new StringBuilder(message.length());
        boolean upperCase = true;
        for (int cp : message.codePoints().toArray()) {
            if (upperCase) {
                sb.appendCodePoint(Character.toUpperCase(cp));
            } else {
                sb.appendCodePoint(Character.toLowerCase(cp));
            }
            upperCase = !upperCase;
        }
        message = sb.toString();
        return message;
    }

    private String applyFancy(String message) {
        StringBuilder sb = new StringBuilder();
        for (char ch : message.toCharArray()) {
            sb.append(this.SMALL_CAPS.getOrDefault(ch, ch));
        }
        return sb.toString();
    }

    private void compileFilterRegexList() {
        this.filterRegexList.clear();
        for (int i = 0; i < this.regexFilters.get().size(); ++i) {
            try {
                this.filterRegexList.add(Pattern.compile(this.regexFilters.get().get(i)));
                continue;
            }
            catch (PatternSyntaxException e) {
                String removed = this.regexFilters.get().remove(i);
                this.error("Removing Invalid regex: %s", removed);
            }
        }
    }

    private String getPrefix() {
        return this.prefix.get() != false ? this.getAffix(this.prefixText.get(), this.prefixSmallCaps.get(), this.prefixRandom.get()) : "";
    }

    private String getSuffix() {
        return this.suffix.get() != false ? this.getAffix(this.suffixText.get(), this.suffixSmallCaps.get(), this.suffixRandom.get()) : "";
    }

    private String getAffix(String text, boolean smallcaps, boolean random) {
        if (random) {
            return String.format("(%03d) ", Utils.random(0, 1000));
        }
        if (smallcaps) {
            return this.applyFancy(text);
        }
        return text;
    }

    private boolean containsCoordinates(String message) {
        return coordRegex.matcher(message).find();
    }

    private class_5250 getSendButton(String message) {
        class_5250 sendButton = class_2561.method_43470((String)"[SEND ANYWAY]");
        class_5250 hintBaseText = class_2561.method_43470((String)"");
        class_5250 hintMsg = class_2561.method_43470((String)"Send your message to the global chat even if there are coordinates:");
        hintMsg.method_10862(hintBaseText.method_10866().method_27706(class_124.field_1080));
        hintBaseText.method_10852((class_2561)hintMsg);
        hintBaseText.method_10852((class_2561)class_2561.method_43470((String)("\n" + message)));
        sendButton.method_10862(sendButton.method_10866().method_27706(class_124.field_1079).method_10958(new class_2558(class_2558.class_2559.field_11750, Commands.get("say").toString(message))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)hintBaseText)));
        return sendButton;
    }

    public boolean isInfiniteChatBox() {
        return this.isActive() && this.infiniteChatBox.get() != false;
    }

    public boolean isLongerChat() {
        return this.isActive() && this.longerChatHistory.get() != false;
    }

    public boolean displayPlayerHeads() {
        return this.isActive() && this.playerHeads.get() != false;
    }

    public boolean keepHistory() {
        return this.isActive() && this.keepHistory.get() != false;
    }

    public int getChatLength() {
        return this.longerChatLines.get();
    }
}

