/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.misc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.Random;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.widgets.WLabel;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WHorizontalList;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.mixin.TextHandlerAccessor;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.FindItemResult;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2820;
import net.minecraft.class_5250;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class BookBot
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Mode> mode;
    private final Setting<String> name;
    private final Setting<Integer> pages;
    private final Setting<Boolean> onlyAscii;
    private final Setting<Boolean> count;
    private final Setting<Integer> delay;
    private File file;
    private final PointerBuffer filters;
    private int delayTimer;
    private int bookCount;
    private Random random;

    public BookBot() {
        super(Categories.Misc, "book-bot", "Automatically writes in books.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.mode = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("mode")).description("What kind of text to write.")).defaultValue(Mode.Random)).build());
        this.name = this.sgGeneral.add(((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("name")).description("The name you want to give your books.")).defaultValue("Meteor on Crack!")).build());
        this.pages = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("pages")).description("The number of pages to write per book.")).defaultValue(50)).range(1, 100).sliderRange(1, 100).visible(() -> this.mode.get() != Mode.File)).build());
        this.onlyAscii = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ascii-only")).description("Only uses the characters in the ASCII charset.")).defaultValue(false)).visible(() -> this.mode.get() == Mode.Random)).build());
        this.count = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("append-count")).description("Whether to append the number of the book to the title.")).defaultValue(true)).build());
        this.delay = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("delay")).description("The amount of delay between writing books.")).defaultValue(20)).min(1).sliderRange(1, 200).build());
        this.file = new File(MeteorClient.FOLDER, "bookbot.txt");
        if (!this.file.exists()) {
            this.file = null;
        }
        this.filters = BufferUtils.createPointerBuffer((int)1);
        ByteBuffer txtFilter = MemoryUtil.memASCII((CharSequence)"*.txt");
        this.filters.put(txtFilter);
        this.filters.rewind();
    }

    @Override
    public WWidget getWidget(GuiTheme theme) {
        WHorizontalList list = theme.horizontalList();
        WButton selectFile = list.add(theme.button("Select File")).widget();
        WLabel fileName = list.add(theme.label(this.file != null && this.file.exists() ? this.file.getName() : "No file selected.")).widget();
        selectFile.action = () -> {
            String path = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)"Select File", (CharSequence)new File(MeteorClient.FOLDER, "bookbot.txt").getAbsolutePath(), (PointerBuffer)this.filters, null, (boolean)false);
            if (path != null) {
                this.file = new File(path);
                fileName.set(this.file.getName());
            }
        };
        return list;
    }

    @Override
    public void onActivate() {
        if (!(this.file != null && this.file.exists() || this.mode.get() != Mode.File)) {
            this.info("No file selected, please select a file in the GUI.", new Object[0]);
            this.toggle();
            return;
        }
        this.random = new Random();
        this.delayTimer = this.delay.get();
        this.bookCount = 0;
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        FindItemResult writableBook = InvUtils.find(class_1802.field_8674);
        if (!writableBook.found()) {
            this.toggle();
            return;
        }
        if (!InvUtils.testInMainHand(class_1802.field_8674)) {
            InvUtils.move().from(writableBook.slot()).toHotbar(this.mc.field_1724.method_31548().field_7545);
            return;
        }
        if (this.delayTimer > 0) {
            --this.delayTimer;
            return;
        }
        this.delayTimer = this.delay.get();
        if (this.mode.get() == Mode.Random) {
            int origin = this.onlyAscii.get() != false ? 33 : 2048;
            int bound = this.onlyAscii.get() != false ? 126 : 0x10FFFF;
            this.writeBook(this.random.ints(origin, bound).filter(i -> !Character.isWhitespace(i) && i != 13 && i != 10).iterator());
        } else if (this.mode.get() == Mode.File) {
            if (!(this.file != null && this.file.exists() || this.mode.get() != Mode.File)) {
                this.info("No file selected, please select a file in the GUI.", new Object[0]);
                this.toggle();
                return;
            }
            if (this.file.length() == 0L) {
                class_5250 message = class_2561.method_43470((String)"");
                message.method_10852((class_2561)class_2561.method_43470((String)"The bookbot file is empty! ").method_27692(class_124.field_1061));
                message.method_10852((class_2561)class_2561.method_43470((String)"Click here to edit it.").method_10862(class_2583.field_24360.method_27705(new class_124[]{class_124.field_1073, class_124.field_1061}).method_10958(new class_2558(class_2558.class_2559.field_11746, this.file.getAbsolutePath()))));
                this.info((class_2561)message);
                this.toggle();
                return;
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(this.file));){
                String line;
                StringBuilder file = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    file.append(line).append('\n');
                }
                reader.close();
                this.writeBook(file.toString().chars().iterator());
            }
            catch (IOException ignored) {
                this.error("Failed to read the file.", new Object[0]);
            }
        }
    }

    private void writeBook(PrimitiveIterator.OfInt chars) {
        ArrayList<String> pages = new ArrayList<String>();
        for (int pageI = 0; pageI < (this.mode.get() == Mode.File ? 100 : this.pages.get()) && chars.hasNext(); ++pageI) {
            StringBuilder page = new StringBuilder();
            for (int lineI = 0; lineI < 13 && chars.hasNext(); ++lineI) {
                double charWidth;
                int nextChar;
                double lineWidth = 0.0;
                StringBuilder line = new StringBuilder();
                while (chars.hasNext() && (nextChar = chars.nextInt()) != 13 && nextChar != 10 && !(lineWidth + (charWidth = (double)((TextHandlerAccessor)this.mc.field_1772.method_27527()).getWidthRetriever().getWidth(nextChar, class_2583.field_24360)) > 114.0)) {
                    line.appendCodePoint(nextChar);
                    lineWidth += charWidth;
                }
                page.append((CharSequence)line).append('\n');
            }
            pages.add(page.toString());
        }
        Object title = this.name.get();
        if (this.count.get().booleanValue() && this.bookCount != 0) {
            title = (String)title + " #" + this.bookCount;
        }
        this.mc.field_1724.method_6047().method_7959("title", (class_2520)class_2519.method_23256((String)title));
        this.mc.field_1724.method_6047().method_7959("author", (class_2520)class_2519.method_23256((String)this.mc.field_1724.method_7334().getName()));
        class_2499 pageNbt = new class_2499();
        pages.stream().map(class_2519::method_23256).forEach(arg_0 -> pageNbt.add(arg_0));
        if (!pages.isEmpty()) {
            this.mc.field_1724.method_6047().method_7959("pages", (class_2520)pageNbt);
        }
        this.mc.field_1724.field_3944.method_2883((class_2596)new class_2820(this.mc.field_1724.method_31548().field_7545, pages, Optional.of(title)));
        ++this.bookCount;
    }

    @Override
    public class_2487 toTag() {
        class_2487 tag = super.toTag();
        if (this.file != null && this.file.exists()) {
            tag.method_10582("file", this.file.getAbsolutePath());
        }
        return tag;
    }

    @Override
    public Module fromTag(class_2487 tag) {
        if (tag.method_10545("file")) {
            this.file = new File(tag.method_10558("file"));
        }
        return super.fromTag(tag);
    }

    public static enum Mode {
        File,
        Random;

    }
}

