/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.misc.swarm;

import meteordevelopment.meteorclient.events.game.GameJoinedEvent;
import meteordevelopment.meteorclient.events.game.GameLeftEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WHorizontalList;
import meteordevelopment.meteorclient.gui.widgets.containers.WVerticalList;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.misc.swarm.SwarmHost;
import meteordevelopment.meteorclient.systems.modules.misc.swarm.SwarmWorker;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_156;

public class Swarm
extends Module {
    private final SettingGroup sgGeneral;
    public final Setting<Mode> mode;
    private final Setting<String> ipAddress;
    private final Setting<Integer> serverPort;
    public SwarmHost host;
    public SwarmWorker worker;

    public Swarm() {
        super(Categories.Misc, "Swarm", "Allows you to control multiple instances of Meteor from one central host.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.mode = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("mode")).description("What type of client to run.")).defaultValue(Mode.Host)).build());
        this.ipAddress = this.sgGeneral.add(((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("ip")).description("The IP address of the host server.")).defaultValue("localhost")).visible(() -> this.mode.get() == Mode.Worker)).build());
        this.serverPort = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("port")).description("The port used for connections.")).defaultValue(420)).range(1, 65535).noSlider().build());
    }

    @Override
    public WWidget getWidget(GuiTheme theme) {
        WVerticalList list = theme.verticalList();
        WHorizontalList b = list.add(theme.horizontalList()).expandX().widget();
        WButton start = b.add(theme.button("Start")).expandX().widget();
        start.action = () -> {
            if (!this.isActive()) {
                return;
            }
            this.close();
            if (this.mode.get() == Mode.Host) {
                this.host = new SwarmHost(this.serverPort.get());
            } else {
                this.worker = new SwarmWorker(this.ipAddress.get(), this.serverPort.get());
            }
        };
        WButton stop = b.add(theme.button("Stop")).expandX().widget();
        stop.action = this::close;
        WButton guide = list.add(theme.button("Guide")).expandX().widget();
        guide.action = () -> class_156.method_668().method_670("https://github.com/MeteorDevelopment/meteor-client/wiki/Swarm-Guide");
        return list;
    }

    @Override
    public String getInfoString() {
        return this.mode.get().name();
    }

    @Override
    public void onActivate() {
        this.close();
    }

    @Override
    public void onDeactivate() {
        this.close();
    }

    public void close() {
        try {
            if (this.host != null) {
                this.host.disconnect();
                this.host = null;
            }
            if (this.worker != null) {
                this.worker.disconnect();
                this.worker = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler
    private void onGameLeft(GameLeftEvent event) {
        this.toggle();
    }

    @EventHandler
    private void onGameJoin(GameJoinedEvent event) {
        this.toggle();
    }

    @Override
    public void toggle() {
        this.close();
        super.toggle();
    }

    public boolean isHost() {
        return this.mode.get() == Mode.Host && this.host != null && !this.host.isInterrupted();
    }

    public boolean isWorker() {
        return this.mode.get() == Mode.Worker && this.worker != null && !this.worker.isInterrupted();
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (this.isWorker()) {
            this.worker.tick();
        }
    }

    public static enum Mode {
        Host,
        Worker;

    }
}

