/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.misc.swarm;

import baritone.api.BaritoneAPI;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import meteordevelopment.meteorclient.commands.Commands;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import net.minecraft.class_2248;

public class SwarmWorker
extends Thread {
    private Socket socket;
    public class_2248 target;

    public SwarmWorker(String ip, int port) {
        try {
            this.socket = new Socket(ip, port);
        }
        catch (Exception e) {
            this.socket = null;
            ChatUtils.warningPrefix("Swarm", "Server not found at %s on port %s.", ip, port);
            e.printStackTrace();
        }
        if (this.socket != null) {
            this.start();
        }
    }

    @Override
    public void run() {
        ChatUtils.infoPrefix("Swarm", "Connected to Swarm host on at %s on port %s.", this.getIp(this.socket.getInetAddress().getHostAddress()), this.socket.getPort());
        try {
            DataInputStream in = new DataInputStream(this.socket.getInputStream());
            while (!this.isInterrupted()) {
                String read = in.readUTF();
                if (read.equals("")) continue;
                ChatUtils.infoPrefix("Swarm", "Received command: (highlight)%s", read);
                try {
                    Commands.dispatch(read);
                }
                catch (Exception e) {
                    ChatUtils.error("Error fetching command.", new Object[0]);
                    e.printStackTrace();
                }
            }
            in.close();
        }
        catch (IOException e) {
            ChatUtils.errorPrefix("Swarm", "Error in connection to host.", new Object[0]);
            e.printStackTrace();
            this.disconnect();
        }
    }

    public void disconnect() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BaritoneAPI.getProvider().getPrimaryBaritone().getPathingBehavior().cancelEverything();
        ChatUtils.infoPrefix("Swarm", "Disconnected from host.", new Object[0]);
        this.interrupt();
    }

    public void tick() {
        if (this.target == null) {
            return;
        }
        BaritoneAPI.getProvider().getPrimaryBaritone().getPathingBehavior().cancelEverything();
        BaritoneAPI.getProvider().getPrimaryBaritone().getMineProcess().mine(new class_2248[]{this.target});
        this.target = null;
    }

    public String getConnection() {
        return this.getIp(this.socket.getInetAddress().getHostAddress()) + ":" + this.socket.getPort();
    }

    private String getIp(String ip) {
        return ip.equals("127.0.0.1") ? "localhost" : ip;
    }
}

