/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.movement;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WTable;
import meteordevelopment.meteorclient.gui.widgets.input.WTextBox;
import meteordevelopment.meteorclient.gui.widgets.pressable.WMinus;
import meteordevelopment.meteorclient.gui.widgets.pressable.WPlus;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.meteorclient.utils.player.Rotations;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class AntiAFK
extends Module {
    private final SettingGroup sgActions;
    private final SettingGroup sgMessages;
    private final Setting<Boolean> spin;
    private final Setting<SpinMode> spinMode;
    private final Setting<Integer> spinSpeed;
    private final Setting<Double> pitch;
    private final Setting<Boolean> jump;
    private final Setting<Boolean> click;
    private final Setting<Boolean> disco;
    private final Setting<Boolean> strafe;
    private final Setting<Boolean> sendMessages;
    private final Setting<Integer> delay;
    private final Setting<Boolean> randomMessage;
    private final List<String> messages;
    private int timer;
    private int messageI;
    private int strafeTimer;
    private boolean direction;
    private final Random random;
    private float prevYaw;

    public AntiAFK() {
        super(Categories.Player, "anti-afk", "Performs different actions to prevent getting kicked for AFK reasons.");
        this.sgActions = this.settings.createGroup("Actions");
        this.sgMessages = this.settings.createGroup("Messages");
        this.spin = this.sgActions.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("spin")).description("Spins.")).defaultValue(true)).build());
        this.spinMode = this.sgActions.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("spin-mode")).description("The method of rotating.")).defaultValue(SpinMode.Server)).visible(this.spin::get)).build());
        this.spinSpeed = this.sgActions.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("spin-speed")).description("The speed to spin you.")).defaultValue(7)).visible(this.spin::get)).build());
        this.pitch = this.sgActions.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("pitch")).description("The pitch to set in server mode.")).defaultValue(-90.0).range(-90.0, 90.0).sliderRange(-90.0, 90.0).visible(() -> this.spin.get() != false && this.spinMode.get() == SpinMode.Server)).build());
        this.jump = this.sgActions.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("jump")).description("Jumps.")).defaultValue(true)).build());
        this.click = this.sgActions.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("click")).description("Clicks.")).defaultValue(false)).build());
        this.disco = this.sgActions.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("disco")).description("Sneaks and unsneaks quickly.")).defaultValue(false)).build());
        this.strafe = this.sgActions.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("strafe")).description("Strafe right and left")).defaultValue(false)).onChanged(aBoolean -> {
            this.strafeTimer = 0;
            this.direction = false;
            if (this.isActive()) {
                this.mc.field_1690.field_1913.method_23481(false);
                this.mc.field_1690.field_1849.method_23481(false);
            }
        })).build());
        this.sendMessages = this.sgMessages.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("send-messages")).description("Sends messages to prevent getting kicked for AFK.")).defaultValue(false)).build());
        this.delay = this.sgMessages.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("delay")).description("The delay between specified messages in seconds.")).defaultValue(2)).min(0).sliderMax(20).build());
        this.randomMessage = this.sgMessages.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("random")).description("Selects a random message from your message list.")).defaultValue(false)).build());
        this.messages = new ArrayList<String>();
        this.strafeTimer = 0;
        this.direction = false;
        this.random = new Random();
    }

    @Override
    public void onActivate() {
        this.prevYaw = this.mc.field_1724.method_36454();
        this.timer = this.delay.get() * 20;
    }

    @Override
    public void onDeactivate() {
        if (this.strafe.get().booleanValue()) {
            this.mc.field_1690.field_1913.method_23481(false);
            this.mc.field_1690.field_1849.method_23481(false);
        }
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (Utils.canUpdate()) {
            if (this.spin.get().booleanValue()) {
                this.prevYaw += (float)this.spinSpeed.get().intValue();
                switch (this.spinMode.get()) {
                    case Client: {
                        this.mc.field_1724.method_36456(this.prevYaw);
                        break;
                    }
                    case Server: {
                        Rotations.rotate(this.prevYaw, this.pitch.get(), -15, null);
                    }
                }
            }
            if (this.jump.get().booleanValue() && this.mc.field_1690.field_1903.method_1434()) {
                this.mc.field_1690.field_1903.method_23481(false);
            }
            if (this.jump.get().booleanValue() && this.mc.field_1690.field_1832.method_1434()) {
                this.mc.field_1690.field_1832.method_23481(false);
            } else if (this.jump.get().booleanValue() && this.random.nextInt(99) + 1 == 50) {
                this.mc.field_1690.field_1903.method_23481(true);
            }
            if (this.click.get().booleanValue() && this.random.nextInt(99) + 1 == 45) {
                this.mc.field_1690.field_1886.method_23481(true);
                Utils.leftClick();
                this.mc.field_1690.field_1886.method_23481(false);
            }
            if (this.disco.get().booleanValue() && this.random.nextInt(24) + 1 == 15) {
                this.mc.field_1690.field_1832.method_23481(true);
            }
            if (this.sendMessages.get().booleanValue() && !this.messages.isEmpty()) {
                if (this.timer <= 0) {
                    int i;
                    if (this.randomMessage.get().booleanValue()) {
                        i = Utils.random(0, this.messages.size());
                    } else {
                        if (this.messageI >= this.messages.size()) {
                            this.messageI = 0;
                        }
                        i = this.messageI++;
                    }
                    ChatUtils.sendPlayerMsg(this.messages.get(i));
                    this.timer = this.delay.get() * 20;
                } else {
                    --this.timer;
                }
            }
            if (this.strafe.get().booleanValue() && this.strafeTimer == 20) {
                this.mc.field_1690.field_1913.method_23481(!this.direction);
                this.mc.field_1690.field_1849.method_23481(this.direction);
                this.direction = !this.direction;
                this.strafeTimer = 0;
            } else {
                ++this.strafeTimer;
            }
        }
    }

    @Override
    public WWidget getWidget(GuiTheme theme) {
        this.messages.removeIf(String::isEmpty);
        WTable table = theme.table();
        this.fillTable(theme, table);
        return table;
    }

    private void fillTable(GuiTheme theme, WTable table) {
        table.add(theme.horizontalSeparator("Message List")).expandX();
        table.row();
        for (int i = 0; i < this.messages.size(); ++i) {
            int msgI = i;
            String message = this.messages.get(i);
            WTextBox textBox = table.add(theme.textBox(message)).minWidth(100.0).expandX().widget();
            textBox.action = () -> this.messages.set(msgI, textBox.get());
            WMinus delete = table.add(theme.minus()).widget();
            delete.action = () -> {
                this.messages.remove(msgI);
                table.clear();
                this.fillTable(theme, table);
            };
            table.row();
        }
        WPlus add = table.add(theme.plus()).expandCellX().right().widget();
        add.action = () -> {
            this.messages.add("");
            table.clear();
            this.fillTable(theme, table);
        };
    }

    @Override
    public class_2487 toTag() {
        class_2487 tag = super.toTag();
        this.messages.removeIf(String::isEmpty);
        class_2499 messagesTag = new class_2499();
        for (String message : this.messages) {
            messagesTag.add((Object)class_2519.method_23256((String)message));
        }
        tag.method_10566("messages", (class_2520)messagesTag);
        return tag;
    }

    @Override
    public Module fromTag(class_2487 tag) {
        this.messages.clear();
        if (tag.method_10545("messages")) {
            class_2499 messagesTag = tag.method_10554("messages", 8);
            for (class_2520 messageTag : messagesTag) {
                this.messages.add(messageTag.method_10714());
            }
        } else {
            this.messages.add("This is an AntiAFK message. Meteor on Crack!");
        }
        return super.fromTag(tag);
    }

    public static enum SpinMode {
        Server,
        Client;

    }
}

