/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.movement;

import baritone.api.BaritoneAPI;
import baritone.api.pathing.goals.Goal;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.misc.input.Input;
import meteordevelopment.meteorclient.utils.world.GoalDirection;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_304;

public class AutoWalk
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Mode> mode;
    private final Setting<Direction> direction;
    private int timer;
    private GoalDirection goal;

    public AutoWalk() {
        super(Categories.Movement, "auto-walk", "Automatically walks forward.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.mode = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("mode")).description("Walking mode.")).defaultValue(Mode.Smart)).onChanged(mode1 -> {
            if (this.isActive()) {
                if (mode1 == Mode.Simple) {
                    BaritoneAPI.getProvider().getPrimaryBaritone().getPathingBehavior().cancelEverything();
                    this.goal = null;
                } else {
                    this.timer = 0;
                    this.createGoal();
                }
                this.unpress();
            }
        })).build());
        this.direction = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("simple-direction")).description("The direction to walk in simple mode.")).defaultValue(Direction.Forwards)).onChanged(direction1 -> {
            if (this.isActive()) {
                this.unpress();
            }
        })).visible(() -> this.mode.get() == Mode.Simple)).build());
        this.timer = 0;
    }

    @Override
    public void onActivate() {
        if (this.mode.get() == Mode.Smart) {
            this.createGoal();
        }
    }

    @Override
    public void onDeactivate() {
        if (this.mode.get() == Mode.Simple) {
            this.unpress();
        } else {
            BaritoneAPI.getProvider().getPrimaryBaritone().getPathingBehavior().cancelEverything();
        }
        this.goal = null;
    }

    @EventHandler(priority=100)
    private void onTick(TickEvent.Pre event) {
        if (this.mode.get() == Mode.Simple) {
            switch (this.direction.get()) {
                case Forwards: {
                    this.setPressed(this.mc.field_1690.field_1894, true);
                    break;
                }
                case Backwards: {
                    this.setPressed(this.mc.field_1690.field_1881, true);
                    break;
                }
                case Left: {
                    this.setPressed(this.mc.field_1690.field_1913, true);
                    break;
                }
                case Right: {
                    this.setPressed(this.mc.field_1690.field_1849, true);
                }
            }
        } else {
            if (this.timer > 20) {
                this.timer = 0;
                this.goal.recalculate(this.mc.field_1724.method_19538());
            }
            ++this.timer;
        }
    }

    private void unpress() {
        this.setPressed(this.mc.field_1690.field_1894, false);
        this.setPressed(this.mc.field_1690.field_1881, false);
        this.setPressed(this.mc.field_1690.field_1913, false);
        this.setPressed(this.mc.field_1690.field_1849, false);
    }

    private void setPressed(class_304 key, boolean pressed) {
        key.method_23481(pressed);
        Input.setKeyState(key, pressed);
    }

    private void createGoal() {
        this.timer = 0;
        this.goal = new GoalDirection(this.mc.field_1724.method_19538(), this.mc.field_1724.method_36454());
        BaritoneAPI.getProvider().getPrimaryBaritone().getCustomGoalProcess().setGoalAndPath((Goal)this.goal);
    }

    public static enum Mode {
        Simple,
        Smart;

    }

    public static enum Direction {
        Forwards,
        Backwards,
        Left,
        Right;

    }
}

