/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.movement;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BlockListSetting;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.FindItemResult;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.player.PlayerUtils;
import meteordevelopment.meteorclient.utils.render.RenderUtils;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.meteorclient.utils.world.BlockUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;

public class Scaffold
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgRender;
    private final Setting<List<class_2248>> blocks;
    private final Setting<ListMode> blocksFilter;
    private final Setting<Boolean> fastTower;
    private final Setting<Boolean> cancelVelocity;
    private final Setting<Boolean> onlyOnClick;
    private final Setting<Boolean> renderSwing;
    private final Setting<Boolean> autoSwitch;
    private final Setting<Boolean> rotate;
    private final Setting<Boolean> airPlace;
    private final Setting<Double> placeRange;
    private final Setting<Double> radius;
    private final Setting<Integer> blocksPerTick;
    private final Setting<Boolean> render;
    private final Setting<ShapeMode> shapeMode;
    private final Setting<SettingColor> sideColor;
    private final Setting<SettingColor> lineColor;
    private final class_2338.class_2339 bp;
    private final class_2338.class_2339 prevBp;
    private boolean lastWasSneaking;
    private double lastSneakingY;

    public Scaffold() {
        super(Categories.Movement, "scaffold", "Automatically places blocks under you.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgRender = this.settings.createGroup("Render");
        this.blocks = this.sgGeneral.add(((BlockListSetting.Builder)((BlockListSetting.Builder)new BlockListSetting.Builder().name("blocks")).description("Selected blocks.")).build());
        this.blocksFilter = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("blocks-filter")).description("How to use the block list setting")).defaultValue(ListMode.Blacklist)).build());
        this.fastTower = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("fast-tower")).description("Whether or not to scaffold upwards faster.")).defaultValue(false)).build());
        this.cancelVelocity = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("cancel-velocity")).description("Whether or not to cancel velocity when towering.")).defaultValue(false)).visible(this.fastTower::get)).build());
        this.onlyOnClick = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("only-on-click")).description("Only places blocks when holding right click.")).defaultValue(false)).build());
        this.renderSwing = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("swing")).description("Renders your client-side swing.")).defaultValue(false)).build());
        this.autoSwitch = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("auto-switch")).description("Automatically swaps to a block before placing.")).defaultValue(true)).build());
        this.rotate = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("rotate")).description("Rotates towards the blocks being placed.")).defaultValue(true)).build());
        this.airPlace = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("air-place")).description("Allow air place. This also allows you to modify scaffold radius.")).defaultValue(false)).build());
        this.placeRange = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("closest-block-range")).description("How far can scaffold place blocks when you are in air.")).defaultValue(4.0).min(0.0).sliderMax(8.0).visible(() -> this.airPlace.get() == false)).build());
        this.radius = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("radius")).description("Scaffold radius.")).defaultValue(0.0).min(0.0).max(6.0).visible(() -> this.airPlace.get())).build());
        this.blocksPerTick = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("blocks-per-tick")).description("How many blocks to place in one tick.")).defaultValue(3)).min(1).visible(() -> this.airPlace.get())).build());
        this.render = this.sgRender.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("render")).description("Whether to render blocks that have been placed.")).defaultValue(true)).build());
        this.shapeMode = this.sgRender.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("How the shapes are rendered.")).defaultValue(ShapeMode.Both)).visible(this.render::get)).build());
        this.sideColor = this.sgRender.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("side-color")).description("The side color of the target block rendering.")).defaultValue(new SettingColor(197, 137, 232, 10)).visible(this.render::get)).build());
        this.lineColor = this.sgRender.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("line-color")).description("The line color of the target block rendering.")).defaultValue(new SettingColor(197, 137, 232)).visible(this.render::get)).build());
        this.bp = new class_2338.class_2339();
        this.prevBp = new class_2338.class_2339();
    }

    @Override
    public void onActivate() {
        this.lastWasSneaking = this.mc.field_1690.field_1832.method_1434();
        if (this.lastWasSneaking) {
            this.lastSneakingY = this.mc.field_1724.method_23318();
        }
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.onlyOnClick.get().booleanValue() && !this.mc.field_1690.field_1904.method_1434()) {
            return;
        }
        if (this.airPlace.get().booleanValue()) {
            class_243 vec = this.mc.field_1724.method_19538().method_1019(this.mc.field_1724.method_18798()).method_1031(0.0, -0.5, 0.0);
            this.bp.method_10102(vec.method_10216(), vec.method_10214(), vec.method_10215());
        } else if (BlockUtils.getPlaceSide(this.mc.field_1724.method_24515().method_10074()) != null) {
            this.bp.method_10101((class_2382)this.mc.field_1724.method_24515().method_10074());
        } else {
            class_243 vecPrevBP;
            class_243 sub;
            class_243 pos = this.mc.field_1724.method_19538();
            pos = pos.method_1031(0.0, (double)-0.98f, 0.0);
            pos.method_1019(this.mc.field_1724.method_18798());
            if (!PlayerUtils.isWithin((class_2338)this.prevBp, (double)this.placeRange.get())) {
                ArrayList<class_2338> blockPosArray = new ArrayList<class_2338>();
                int x = (int)(this.mc.field_1724.method_23317() - this.placeRange.get());
                while ((double)x < this.mc.field_1724.method_23317() + this.placeRange.get()) {
                    int z = (int)(this.mc.field_1724.method_23321() - this.placeRange.get());
                    while ((double)z < this.mc.field_1724.method_23321() + this.placeRange.get()) {
                        int y = (int)Math.max((double)this.mc.field_1687.method_31607(), this.mc.field_1724.method_23318() - this.placeRange.get());
                        while ((double)y < Math.min((double)this.mc.field_1687.method_31600(), this.mc.field_1724.method_23318() + this.placeRange.get())) {
                            this.bp.method_10103(x, y, z);
                            if (!this.mc.field_1687.method_8320((class_2338)this.bp).method_26215()) {
                                blockPosArray.add(new class_2338((class_2382)this.bp));
                            }
                            ++y;
                        }
                        ++z;
                    }
                    ++x;
                }
                if (blockPosArray.size() == 0) {
                    return;
                }
                blockPosArray.sort(Comparator.comparingDouble(PlayerUtils::squaredDistanceTo));
                this.prevBp.method_10101((class_2382)blockPosArray.get(0));
            }
            class_2350 facing = (sub = pos.method_1020(vecPrevBP = new class_243((double)this.prevBp.method_10263() + 0.5, (double)this.prevBp.method_10264() + 0.5, (double)this.prevBp.method_10260() + 0.5))).method_10214() < -0.5 ? class_2350.field_11033 : (sub.method_10214() > 0.5 ? class_2350.field_11036 : class_2350.method_10142((double)sub.method_10216(), (double)0.0, (double)sub.method_10215()));
            this.bp.method_10101((class_2382)this.prevBp.method_10093(facing));
        }
        if (this.mc.field_1690.field_1832.method_1434() && !this.mc.field_1690.field_1903.method_1434()) {
            if (this.lastSneakingY - this.mc.field_1724.method_23318() < 0.1) {
                this.lastWasSneaking = false;
                return;
            }
        } else {
            this.lastWasSneaking = false;
        }
        if (!this.lastWasSneaking) {
            this.lastSneakingY = this.mc.field_1724.method_23318();
        }
        this.fastTower(false, null);
        if (this.airPlace.get().booleanValue()) {
            ArrayList<class_2338> blocks = new ArrayList<class_2338>();
            int x = (int)(this.mc.field_1724.method_23317() - this.radius.get());
            while ((double)x < this.mc.field_1724.method_23317() + this.radius.get()) {
                int z = (int)(this.mc.field_1724.method_23321() - this.radius.get());
                while ((double)z < this.mc.field_1724.method_23321() + this.radius.get()) {
                    blocks.add(class_2338.method_49637((double)x, (double)(this.mc.field_1724.method_23318() - 0.5), (double)z));
                    ++z;
                }
                ++x;
            }
            if (!blocks.isEmpty()) {
                blocks.sort(Comparator.comparingDouble(PlayerUtils::squaredDistanceTo));
                int counter = 0;
                for (class_2338 block : blocks) {
                    if (this.place(block)) {
                        this.fastTower(true, block);
                        ++counter;
                    }
                    if (counter < this.blocksPerTick.get()) continue;
                    break;
                }
            }
        } else {
            if (this.place((class_2338)this.bp)) {
                this.fastTower(true, (class_2338)this.bp);
            }
            if (!this.mc.field_1687.method_8320((class_2338)this.bp).method_26215()) {
                this.prevBp.method_10101((class_2382)this.bp);
            }
        }
    }

    public boolean scaffolding() {
        return this.isActive() && (this.onlyOnClick.get() == false || this.onlyOnClick.get() != false && this.mc.field_1690.field_1904.method_1434());
    }

    private boolean validItem(class_1799 itemStack, class_2338 pos) {
        if (!(itemStack.method_7909() instanceof class_1747)) {
            return false;
        }
        class_2248 block = ((class_1747)itemStack.method_7909()).method_7711();
        if (this.blocksFilter.get() == ListMode.Blacklist && this.blocks.get().contains(block)) {
            return false;
        }
        if (this.blocksFilter.get() == ListMode.Whitelist && !this.blocks.get().contains(block)) {
            return false;
        }
        if (!class_2248.method_9614((class_265)block.method_9564().method_26220((class_1922)this.mc.field_1687, pos))) {
            return false;
        }
        return !(block instanceof class_2346) || !class_2346.method_10128((class_2680)this.mc.field_1687.method_8320(pos));
    }

    private boolean place(class_2338 bp) {
        FindItemResult item = InvUtils.findInHotbar(itemStack -> this.validItem((class_1799)itemStack, bp));
        if (!item.found()) {
            return false;
        }
        if (item.getHand() == null && !this.autoSwitch.get().booleanValue()) {
            return false;
        }
        if (BlockUtils.place(bp, item, this.rotate.get(), 50, this.renderSwing.get(), true)) {
            if (this.render.get().booleanValue()) {
                RenderUtils.renderTickingBlock(bp.method_10062(), this.sideColor.get(), this.lineColor.get(), this.shapeMode.get(), 0, 8, true, false);
            }
            return true;
        }
        return false;
    }

    private void fastTower(boolean down, class_2338 checkBlock) {
        if (down) {
            if (this.fastTower.get().booleanValue() && this.mc.field_1690.field_1903.method_1434() && !this.mc.field_1690.field_1832.method_1434() && !this.mc.field_1724.method_24828() && !this.mc.field_1687.method_8320(checkBlock.method_10074()).method_45474()) {
                this.mc.field_1724.method_18800(0.0, (double)-0.28f, 0.0);
            }
        } else if (this.mc.field_1690.field_1903.method_1434() && !this.mc.field_1690.field_1832.method_1434() && this.fastTower.get().booleanValue() && InvUtils.testInHotbar(stack -> this.validItem((class_1799)stack, this.mc.field_1724.method_24515()))) {
            class_243 vel = this.mc.field_1724.method_18798();
            this.mc.field_1724.method_18800(this.cancelVelocity.get() != false ? 0.0 : vel.field_1352, 0.42, this.cancelVelocity.get() != false ? 0.0 : vel.field_1350);
        }
    }

    public static enum ListMode {
        Whitelist,
        Blacklist;

    }
}

