/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.player;

import meteordevelopment.meteorclient.events.entity.player.FinishUsingItemEvent;
import meteordevelopment.meteorclient.events.entity.player.StoppedUsingItemEvent;
import meteordevelopment.meteorclient.events.meteor.MouseButtonEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.misc.input.KeyAction;
import meteordevelopment.meteorclient.utils.player.FindItemResult;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1802;

public class MiddleClickExtra
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Mode> mode;
    private final Setting<Boolean> notify;
    private boolean isUsing;

    public MiddleClickExtra() {
        super(Categories.Player, "middle-click-extra", "Lets you use items when you middle click.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.mode = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("mode")).description("Which item to use when you middle click.")).defaultValue(Mode.Pearl)).build());
        this.notify = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("notify")).description("Notifies you when you do not have the specified item in your hotbar.")).defaultValue(true)).build());
    }

    @Override
    public void onDeactivate() {
        this.stopIfUsing();
    }

    @EventHandler
    private void onMouseButton(MouseButtonEvent event) {
        if (event.action != KeyAction.Press || event.button != 2 || this.mc.field_1755 != null) {
            return;
        }
        FindItemResult result = InvUtils.findInHotbar(this.mode.get().item);
        if (!result.found()) {
            if (this.notify.get().booleanValue()) {
                this.warning("Unable to find specified item.", new Object[0]);
            }
            return;
        }
        InvUtils.swap(result.slot(), true);
        switch (this.mode.get().type) {
            case Immediate: {
                this.mc.field_1761.method_2919((class_1657)this.mc.field_1724, class_1268.field_5808);
                InvUtils.swapBack();
                break;
            }
            case LongerSingleClick: {
                this.mc.field_1761.method_2919((class_1657)this.mc.field_1724, class_1268.field_5808);
                break;
            }
            case Longer: {
                this.mc.field_1690.field_1904.method_23481(true);
                this.isUsing = true;
            }
        }
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.isUsing) {
            boolean pressed = true;
            if (this.mc.field_1724.method_6047().method_7909() instanceof class_1753) {
                pressed = class_1753.method_7722((int)this.mc.field_1724.method_6048()) < 1.0f;
            }
            this.mc.field_1690.field_1904.method_23481(pressed);
        }
    }

    @EventHandler
    private void onFinishUsingItem(FinishUsingItemEvent event) {
        this.stopIfUsing();
    }

    @EventHandler
    private void onStoppedUsingItem(StoppedUsingItemEvent event) {
        this.stopIfUsing();
    }

    private void stopIfUsing() {
        if (this.isUsing) {
            this.mc.field_1690.field_1904.method_23481(false);
            InvUtils.swapBack();
            this.isUsing = false;
        }
    }

    public static enum Mode {
        Pearl(class_1802.field_8634, Type.Immediate),
        Rocket(class_1802.field_8639, Type.Immediate),
        Rod(class_1802.field_8378, Type.LongerSingleClick),
        Bow(class_1802.field_8102, Type.Longer),
        Gap(class_1802.field_8463, Type.Longer),
        EGap(class_1802.field_8367, Type.Longer),
        Chorus(class_1802.field_8233, Type.Longer),
        XP(class_1802.field_8287, Type.Immediate);

        private final class_1792 item;
        private final Type type;

        private Mode(class_1792 item, Type type) {
            this.item = item;
            this.type = type;
        }
    }

    private static enum Type {
        Immediate,
        LongerSingleClick,
        Longer;

    }
}

