/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.render;

import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import meteordevelopment.meteorclient.events.game.ItemStackTooltipEvent;
import meteordevelopment.meteorclient.events.game.SectionVisibleEvent;
import meteordevelopment.meteorclient.events.render.TooltipDataEvent;
import meteordevelopment.meteorclient.mixin.EntityAccessor;
import meteordevelopment.meteorclient.mixin.EntityBucketItemAccessor;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.KeybindSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.misc.ByteCountDataOutput;
import meteordevelopment.meteorclient.utils.misc.Keybind;
import meteordevelopment.meteorclient.utils.player.EChestMemory;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.tooltip.BannerTooltipComponent;
import meteordevelopment.meteorclient.utils.tooltip.BookTooltipComponent;
import meteordevelopment.meteorclient.utils.tooltip.ContainerTooltipComponent;
import meteordevelopment.meteorclient.utils.tooltip.EntityTooltipComponent;
import meteordevelopment.meteorclient.utils.tooltip.MapTooltipComponent;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1745;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1819;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_4174;
import net.minecraft.class_5250;
import net.minecraft.class_5761;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7446;
import net.minecraft.class_7923;

public class BetterTooltips
extends Module {
    public static final Color ECHEST_COLOR = new Color(0, 50, 50);
    private final SettingGroup sgGeneral;
    private final SettingGroup sgPreviews;
    private final SettingGroup sgOther;
    private final SettingGroup sgHideFlags;
    private final Setting<DisplayWhen> displayWhen;
    private final Setting<Keybind> keybind;
    private final Setting<Boolean> middleClickOpen;
    private final Setting<Boolean> shulkers;
    private final Setting<Boolean> shulkerCompactTooltip;
    public final Setting<Boolean> echest;
    private final Setting<Boolean> maps;
    public final Setting<Double> mapsScale;
    private final Setting<Boolean> books;
    private final Setting<Boolean> banners;
    private final Setting<Boolean> entitiesInBuckets;
    public final Setting<Boolean> byteSize;
    private final Setting<Boolean> statusEffects;
    private final Setting<Boolean> beehive;
    private final Setting<Boolean> enchantments;
    private final Setting<Boolean> modifiers;
    private final Setting<Boolean> unbreakable;
    private final Setting<Boolean> canDestroy;
    private final Setting<Boolean> canPlaceOn;
    private final Setting<Boolean> additional;
    private final Setting<Boolean> dye;

    public BetterTooltips() {
        super(Categories.Render, "better-tooltips", "Displays more useful tooltips for certain items.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgPreviews = this.settings.createGroup("Previews");
        this.sgOther = this.settings.createGroup("Other");
        this.sgHideFlags = this.settings.createGroup("Hide Flags");
        this.displayWhen = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("display-when")).description("When to display previews.")).defaultValue(DisplayWhen.Keybind)).build());
        this.keybind = this.sgGeneral.add(((KeybindSetting.Builder)((KeybindSetting.Builder)((KeybindSetting.Builder)((KeybindSetting.Builder)new KeybindSetting.Builder().name("keybind")).description("The bind for keybind mode.")).defaultValue(Keybind.fromKey(342))).visible(() -> this.displayWhen.get() == DisplayWhen.Keybind)).build());
        this.middleClickOpen = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("middle-click-open")).description("Opens a GUI window with the inventory of the storage block when you middle click the item.")).defaultValue(true)).build());
        this.shulkers = this.sgPreviews.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("containers")).description("Shows a preview of a containers when hovering over it in an inventory.")).defaultValue(true)).build());
        this.shulkerCompactTooltip = this.sgPreviews.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("compact-shulker-tooltip")).description("Compacts the lines of the shulker tooltip.")).defaultValue(true)).visible(this.shulkers::get)).build());
        this.echest = this.sgPreviews.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("echests")).description("Shows a preview of your echest when hovering over it in an inventory.")).defaultValue(true)).build());
        this.maps = this.sgPreviews.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("maps")).description("Shows a preview of a map when hovering over it in an inventory.")).defaultValue(true)).build());
        this.mapsScale = this.sgPreviews.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("map-scale")).description("The scale of the map preview.")).defaultValue(1.0).min(0.001).sliderMax(1.0).visible(this.maps::get)).build());
        this.books = this.sgPreviews.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("books")).description("Shows contents of a book when hovering over it in an inventory.")).defaultValue(true)).build());
        this.banners = this.sgPreviews.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("banners")).description("Shows banners' patterns when hovering over it in an inventory. Also works with shields.")).defaultValue(true)).build());
        this.entitiesInBuckets = this.sgPreviews.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("entities-in-buckets")).description("Shows entities in buckets when hovering over it in an inventory.")).defaultValue(true)).build());
        this.byteSize = this.sgOther.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("byte-size")).description("Displays an item's size in bytes in the tooltip.")).defaultValue(true)).build());
        this.statusEffects = this.sgOther.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("status-effects")).description("Adds list of status effects to tooltips of food items.")).defaultValue(true)).build());
        this.beehive = this.sgOther.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("beehive")).description("Displays information about a beehive or bee nest.")).defaultValue(true)).build());
        this.enchantments = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("enchantments")).description("Show enchantments when it's hidden.")).defaultValue(false)).build());
        this.modifiers = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("modifiers")).description("Show item modifiers when it's hidden.")).defaultValue(false)).build());
        this.unbreakable = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("unbreakable")).description("Show \"Unbreakable\" tag when it's hidden.")).defaultValue(false)).build());
        this.canDestroy = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("can-destroy")).description("Show \"CanDestroy\" tag when it's hidden.")).defaultValue(false)).build());
        this.canPlaceOn = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("can-place-on")).description("Show \"CanPlaceOn\" tag when it's hidden.")).defaultValue(false)).build());
        this.additional = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("additional")).description("Show potion effects, firework status, book author, etc when it's hidden.")).defaultValue(false)).build());
        this.dye = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("dye")).description("Show dyed item tags when it's hidden.")).defaultValue(false)).build());
    }

    @EventHandler
    private void appendTooltip(ItemStackTooltipEvent event) {
        class_2487 tag;
        if (this.statusEffects.get().booleanValue()) {
            class_4174 food;
            if (event.itemStack.method_7909() == class_1802.field_8766) {
                class_2499 effects;
                tag = event.itemStack.method_7969();
                if (tag != null && (effects = tag.method_10554("Effects", 10)) != null) {
                    for (int i = 0; i < effects.size(); ++i) {
                        class_2487 effectTag = effects.method_10602(i);
                        byte effectId = effectTag.method_10571("EffectId");
                        int effectDuration = effectTag.method_10545("EffectDuration") ? effectTag.method_10550("EffectDuration") : 160;
                        class_1291 type = class_1291.method_5569((int)effectId);
                        if (type == null) continue;
                        class_1293 effect = new class_1293(type, effectDuration, 0);
                        event.list.add(1, (class_2561)this.getStatusText(effect));
                    }
                }
            } else if (event.itemStack.method_7909().method_19263() && (food = event.itemStack.method_7909().method_19264()) != null) {
                food.method_19235().forEach(e -> {
                    class_1293 effect = (class_1293)e.getFirst();
                    event.list.add(1, (class_2561)this.getStatusText(effect));
                });
            }
        }
        if (this.beehive.get().booleanValue() && (event.itemStack.method_7909() == class_1802.field_20416 || event.itemStack.method_7909() == class_1802.field_20415) && (tag = event.itemStack.method_7969()) != null) {
            class_2487 blockEntityTag;
            class_2487 blockStateTag = tag.method_10562("BlockStateTag");
            if (blockStateTag != null) {
                int level = blockStateTag.method_10550("honey_level");
                event.list.add(1, (class_2561)class_2561.method_43470((String)String.format("%sHoney level: %s%d%s.", class_124.field_1080, class_124.field_1054, level, class_124.field_1080)));
            }
            if ((blockEntityTag = tag.method_10562("BlockEntityTag")) != null) {
                class_2499 beesTag = blockEntityTag.method_10554("Bees", 10);
                event.list.add(1, (class_2561)class_2561.method_43470((String)String.format("%sBees: %s%d%s.", class_124.field_1080, class_124.field_1054, beesTag.size(), class_124.field_1080)));
            }
        }
        if (this.byteSize.get().booleanValue()) {
            try {
                event.itemStack.method_7953(new class_2487()).method_10713((DataOutput)ByteCountDataOutput.INSTANCE);
                int byteCount = ByteCountDataOutput.INSTANCE.getCount();
                ByteCountDataOutput.INSTANCE.reset();
                String count = byteCount >= 1024 ? String.format("%.2f kb", Float.valueOf((float)byteCount / 1024.0f)) : String.format("%d bytes", byteCount);
                event.list.add((class_2561)class_2561.method_43470((String)count).method_27692(class_124.field_1080));
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        if (this.shulkers.get() != false && !this.previewShulkers() && Utils.hasItems(event.itemStack) || event.itemStack.method_7909() == class_1802.field_8466 && this.echest.get() != false && !this.previewEChest() || event.itemStack.method_7909() == class_1802.field_8204 && this.maps.get() != false && !this.previewMaps() || event.itemStack.method_7909() == class_1802.field_8674 && this.books.get() != false && !this.previewBooks() || event.itemStack.method_7909() == class_1802.field_8360 && this.books.get() != false && !this.previewBooks() || event.itemStack.method_7909() instanceof class_1785 && this.entitiesInBuckets.get() != false && !this.previewEntities() || event.itemStack.method_7909() instanceof class_1746 && this.banners.get() != false && !this.previewBanners() || event.itemStack.method_7909() instanceof class_1745 && this.banners.get() != false && !this.previewBanners() || event.itemStack.method_7909() == class_1802.field_8255 && this.banners.get().booleanValue() && !this.previewBanners()) {
            event.list.add((class_2561)class_2561.method_43470((String)""));
            event.list.add((class_2561)class_2561.method_43470((String)("Hold " + class_124.field_1054 + this.keybind + class_124.field_1070 + " to preview")));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler
    private void getTooltipData(TooltipDataEvent event) {
        class_1792 banner;
        if (this.previewShulkers() && Utils.hasItems(event.itemStack)) {
            class_2487 compoundTag = event.itemStack.method_7941("BlockEntityTag");
            class_2371 itemStacks = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
            class_1262.method_5429((class_2487)compoundTag, (class_2371)itemStacks);
            event.tooltipData = new ContainerTooltipComponent((class_2371<class_1799>)itemStacks, Utils.getShulkerColor(event.itemStack));
            return;
        }
        if (event.itemStack.method_7909() == class_1802.field_8466 && this.previewEChest()) {
            event.tooltipData = new ContainerTooltipComponent(EChestMemory.ITEMS, ECHEST_COLOR);
            return;
        }
        if (event.itemStack.method_7909() == class_1802.field_8204 && this.previewMaps()) {
            Integer mapId = class_1806.method_8003((class_1799)event.itemStack);
            if (mapId == null) return;
            event.tooltipData = new MapTooltipComponent(mapId);
            return;
        }
        if ((event.itemStack.method_7909() == class_1802.field_8674 || event.itemStack.method_7909() == class_1802.field_8360) && this.previewBooks()) {
            class_2561 page = this.getFirstPage(event.itemStack);
            if (page == null) return;
            event.tooltipData = new BookTooltipComponent(page);
            return;
        }
        if (event.itemStack.method_7909() instanceof class_1746 && this.previewBanners()) {
            event.tooltipData = new BannerTooltipComponent(event.itemStack);
            return;
        }
        class_1792 page = event.itemStack.method_7909();
        if (page instanceof class_1745) {
            class_1745 patternItem = (class_1745)page;
            if (this.previewBanners()) {
                boolean present = class_7923.field_41165.method_40266(patternItem.method_7704()).isPresent() && ((class_6885.class_6888)class_7923.field_41165.method_40266(patternItem.method_7704()).get()).method_40247() != 0;
                class_6880 bannerPattern = present ? ((class_6885.class_6888)class_7923.field_41165.method_40266(patternItem.method_7704()).get()).method_40240(0) : null;
                if (bannerPattern == null) return;
                event.tooltipData = new BannerTooltipComponent(this.createBannerFromPattern((class_6880<class_2582>)bannerPattern));
                return;
            }
        }
        if (event.itemStack.method_7909() == class_1802.field_8255 && this.previewBanners()) {
            banner = this.createBannerFromShield(event.itemStack);
            if (banner == null) return;
            event.tooltipData = new BannerTooltipComponent((class_1799)banner);
            return;
        }
        banner = event.itemStack.method_7909();
        if (!(banner instanceof class_1785)) return;
        class_1785 bucketItem = (class_1785)banner;
        if (!this.previewEntities()) return;
        class_1299<?> type = ((EntityBucketItemAccessor)bucketItem).getEntityType();
        class_1297 entity = type.method_5883((class_1937)this.mc.field_1687);
        if (entity == null) return;
        ((class_5761)entity).method_35170(event.itemStack.method_7948());
        ((EntityAccessor)entity).setInWater(true);
        event.tooltipData = new EntityTooltipComponent(entity);
    }

    @EventHandler
    private void onSectionVisible(SectionVisibleEvent event) {
        if (this.enchantments.get() != false && event.section == class_1799.class_5422.field_25768 || this.modifiers.get() != false && event.section == class_1799.class_5422.field_25769 || this.unbreakable.get() != false && event.section == class_1799.class_5422.field_25770 || this.canDestroy.get() != false && event.section == class_1799.class_5422.field_25771 || this.canPlaceOn.get() != false && event.section == class_1799.class_5422.field_25772 || this.additional.get() != false && event.section == class_1799.class_5422.field_25773 || this.dye.get().booleanValue() && event.section == class_1799.class_5422.field_25774) {
            event.visible = true;
        }
    }

    public void applyCompactShulkerTooltip(class_1799 stack, List<class_2561> tooltip) {
        class_2487 tag = stack.method_7941("BlockEntityTag");
        if (tag != null) {
            if (tag.method_10573("LootTable", 8)) {
                tooltip.add((class_2561)class_2561.method_43470((String)"???????"));
            }
            if (tag.method_10573("Items", 9)) {
                class_2371 items = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
                class_1262.method_5429((class_2487)tag, (class_2371)items);
                Object2IntOpenHashMap counts = new Object2IntOpenHashMap();
                for (class_1799 item : items) {
                    if (item.method_7960()) continue;
                    int count = counts.getInt((Object)item.method_7909());
                    counts.put((Object)item.method_7909(), count + item.method_7947());
                }
                counts.keySet().stream().sorted(Comparator.comparingInt(arg_0 -> BetterTooltips.lambda$applyCompactShulkerTooltip$2((Object2IntMap)counts, arg_0))).limit(5L).forEach(arg_0 -> BetterTooltips.lambda$applyCompactShulkerTooltip$3((Object2IntMap)counts, tooltip, arg_0));
                if (counts.size() > 5) {
                    tooltip.add((class_2561)class_2561.method_43469((String)"container.shulkerBox.more", (Object[])new Object[]{counts.size() - 5}).method_27692(class_124.field_1056));
                }
            }
        }
    }

    private class_5250 getStatusText(class_1293 effect) {
        class_5250 text = class_2561.method_43471((String)effect.method_5586());
        if (effect.method_5578() != 0) {
            text.method_27693(String.format(" %d (%s)", effect.method_5578() + 1, class_1292.method_5577((class_1293)effect, (float)1.0f).getString()));
        } else {
            text.method_27693(String.format(" (%s)", class_1292.method_5577((class_1293)effect, (float)1.0f).getString()));
        }
        if (effect.method_5579().method_5573()) {
            return text.method_27692(class_124.field_1078);
        }
        return text.method_27692(class_124.field_1061);
    }

    private class_2561 getFirstPage(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return null;
        }
        class_2499 pages = tag.method_10554("pages", 8);
        if (pages.size() < 1) {
            return null;
        }
        if (stack.method_7909() == class_1802.field_8674) {
            return class_2561.method_43470((String)pages.method_10608(0));
        }
        try {
            return class_2561.class_2562.method_10873((String)pages.method_10608(0));
        }
        catch (JsonSyntaxException e) {
            return class_2561.method_43470((String)"Invalid book data");
        }
    }

    private class_1799 createBannerFromPattern(class_6880<class_2582> pattern) {
        class_1799 itemStack = new class_1799((class_1935)class_1802.field_8617);
        class_2487 nbt = itemStack.method_7911("BlockEntityTag");
        class_2499 listNbt = new class_2582.class_3750().method_43720(class_7446.field_39151, class_1767.field_7963).method_16376(pattern, class_1767.field_7952).method_16375();
        nbt.method_10566("Patterns", (class_2520)listNbt);
        return itemStack;
    }

    private class_1799 createBannerFromShield(class_1799 item) {
        if (!(item.method_7985() && item.method_7969().method_10545("BlockEntityTag") && item.method_7969().method_10562("BlockEntityTag").method_10545("Base"))) {
            return null;
        }
        class_2499 listNbt = new class_2582.class_3750().method_43720(class_7446.field_39151, class_1819.method_8013((class_1799)item)).method_16375();
        class_2487 nbt = item.method_7911("BlockEntityTag");
        class_1799 bannerItem = new class_1799((class_1935)class_1802.field_8617);
        class_2487 bannerTag = bannerItem.method_7911("BlockEntityTag");
        bannerTag.method_10566("Patterns", (class_2520)listNbt);
        if (!nbt.method_10545("Patterns")) {
            return bannerItem;
        }
        class_2499 shieldPatterns = nbt.method_10554("Patterns", 10);
        listNbt.addAll((Collection)shieldPatterns);
        return bannerItem;
    }

    public boolean middleClickOpen() {
        return this.isActive() && this.middleClickOpen.get() != false;
    }

    public boolean previewShulkers() {
        return this.isActive() && this.isPressed() && this.shulkers.get() != false;
    }

    public boolean shulkerCompactTooltip() {
        return this.isActive() && this.shulkerCompactTooltip.get() != false;
    }

    private boolean previewEChest() {
        return this.isPressed() && this.echest.get() != false;
    }

    private boolean previewMaps() {
        return this.isPressed() && this.maps.get() != false;
    }

    private boolean previewBooks() {
        return this.isPressed() && this.books.get() != false;
    }

    private boolean previewBanners() {
        return this.isPressed() && this.banners.get() != false;
    }

    private boolean previewEntities() {
        return this.isPressed() && this.entitiesInBuckets.get() != false;
    }

    private boolean isPressed() {
        return this.keybind.get().isPressed() && this.displayWhen.get() == DisplayWhen.Keybind || this.displayWhen.get() == DisplayWhen.Always;
    }

    private static /* synthetic */ void lambda$applyCompactShulkerTooltip$3(Object2IntMap counts, List tooltip, class_1792 item) {
        class_5250 mutableText = item.method_7848().method_27662();
        mutableText.method_10852((class_2561)class_2561.method_43470((String)" x").method_27693(String.valueOf(counts.getInt((Object)item))).method_27692(class_124.field_1080));
        tooltip.add(mutableText);
    }

    private static /* synthetic */ int lambda$applyCompactShulkerTooltip$2(Object2IntMap counts, class_1792 value) {
        return -counts.getInt((Object)value);
    }

    public static enum DisplayWhen {
        Keybind,
        Always;

    }
}

