/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.render;

import meteordevelopment.meteorclient.events.game.ChangePerspectiveEvent;
import meteordevelopment.meteorclient.events.meteor.MouseScrollEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.KeybindSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.misc.Keybind;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_5498;

public class CameraTweaks
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgScrolling;
    private final Setting<Boolean> clip;
    private final Setting<Double> cameraDistance;
    private final Setting<Boolean> scrollingEnabled;
    private final Setting<Double> scrollSensitivity;
    private final Setting<Keybind> scrollKeybind;
    public double distance;

    public CameraTweaks() {
        super(Categories.Render, "camera-tweaks", "Allows modification of the third person camera.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgScrolling = this.settings.createGroup("Scrolling");
        this.clip = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("clip")).description("Allows the camera to clip through blocks.")).defaultValue(true)).build());
        this.cameraDistance = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("camera-distance")).description("The distance the third person camera is from the player.")).defaultValue(4.0).min(0.0).onChanged(value -> {
            this.distance = value;
        })).build());
        this.scrollingEnabled = this.sgScrolling.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("scrolling-enabled")).description("Allows you to scroll to change camera distance.")).defaultValue(true)).build());
        this.scrollSensitivity = this.sgScrolling.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("scroll-sensitivity")).description("Scroll sensitivity when changing the cameras distance. 0 to disable.")).visible(this.scrollingEnabled::get)).defaultValue(1.0).min(0.0).build());
        this.scrollKeybind = this.sgScrolling.add(((KeybindSetting.Builder)((KeybindSetting.Builder)((KeybindSetting.Builder)((KeybindSetting.Builder)new KeybindSetting.Builder().name("scroll-keybind")).description("Makes it so a keybind needs to be pressed for scrolling to work.")).visible(this.scrollingEnabled::get)).defaultValue(Keybind.none())).build());
    }

    @Override
    public void onActivate() {
        this.distance = this.cameraDistance.get();
    }

    @EventHandler
    private void onPerspectiveChanged(ChangePerspectiveEvent event) {
        this.distance = this.cameraDistance.get();
    }

    @EventHandler
    private void onMouseScroll(MouseScrollEvent event) {
        if (this.mc.field_1690.method_31044() == class_5498.field_26664 || this.mc.field_1755 != null || !this.scrollingEnabled.get().booleanValue() || this.scrollKeybind.get().isValid() && !this.scrollKeybind.get().isPressed()) {
            return;
        }
        if (this.scrollSensitivity.get() > 0.0) {
            this.distance -= event.value * 0.25 * (this.scrollSensitivity.get() * this.distance);
            event.cancel();
        }
    }

    public boolean clip() {
        return this.isActive() && this.clip.get() != false;
    }

    public double getDistance() {
        return this.isActive() ? this.distance : 4.0;
    }
}

