/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.render;

import java.util.Set;
import meteordevelopment.meteorclient.events.render.Render2DEvent;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.renderer.Renderer2D;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EntityTypeListSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.config.Config;
import meteordevelopment.meteorclient.systems.friends.Friends;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.entity.EntityUtils;
import meteordevelopment.meteorclient.utils.player.PlayerUtils;
import meteordevelopment.meteorclient.utils.render.NametagUtils;
import meteordevelopment.meteorclient.utils.render.WireframeEntityRenderer;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_3532;
import org.joml.Vector3d;

public class ESP
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgColors;
    public final Setting<Mode> mode;
    public final Setting<Integer> outlineWidth;
    public final Setting<Double> glowMultiplier;
    public final Setting<Boolean> ignoreSelf;
    public final Setting<ShapeMode> shapeMode;
    public final Setting<Double> fillOpacity;
    private final Setting<Double> fadeDistance;
    private final Setting<Set<class_1299<?>>> entities;
    public final Setting<Boolean> distance;
    public final Setting<Boolean> friendOverride;
    private final Setting<SettingColor> playersColor;
    private final Setting<SettingColor> animalsColor;
    private final Setting<SettingColor> waterAnimalsColor;
    private final Setting<SettingColor> monstersColor;
    private final Setting<SettingColor> ambientColor;
    private final Setting<SettingColor> miscColor;
    private final Color lineColor;
    private final Color sideColor;
    private final Color baseColor;
    private final Vector3d pos1;
    private final Vector3d pos2;
    private final Vector3d pos;
    private int count;

    public ESP() {
        super(Categories.Render, "esp", "Renders entities through walls.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgColors = this.settings.createGroup("Colors");
        this.mode = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("mode")).description("Rendering mode.")).defaultValue(Mode.Shader)).build());
        this.outlineWidth = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("outline-width")).description("The width of the shader outline.")).visible(() -> this.mode.get() == Mode.Shader)).defaultValue(2)).range(1, 10).sliderRange(1, 5).build());
        this.glowMultiplier = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("glow-multiplier")).description("Multiplier for glow effect")).visible(() -> this.mode.get() == Mode.Shader)).decimalPlaces(3).defaultValue(3.5).min(0.0).sliderMax(10.0).build());
        this.ignoreSelf = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-self")).description("Ignores yourself drawing the shader.")).defaultValue(true)).build());
        this.shapeMode = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("How the shapes are rendered.")).defaultValue(ShapeMode.Both)).build());
        this.fillOpacity = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("fill-opacity")).description("The opacity of the shape fill.")).visible(() -> this.shapeMode.get() != ShapeMode.Lines)).defaultValue(0.3).range(0.0, 1.0).sliderMax(1.0).build());
        this.fadeDistance = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("fade-distance")).description("The distance from an entity where the color begins to fade.")).defaultValue(3.0).min(0.0).sliderMax(12.0).build());
        this.entities = this.sgGeneral.add(((EntityTypeListSetting.Builder)((EntityTypeListSetting.Builder)new EntityTypeListSetting.Builder().name("entities")).description("Select specific entities.")).defaultValue(class_1299.field_6097).build());
        this.distance = this.sgColors.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("distance-colors")).description("Changes the color of tracers depending on distance.")).defaultValue(false)).build());
        this.friendOverride = this.sgColors.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("show-friend-colors")).description("Whether or not to override the distance color of friends with the friend color.")).defaultValue(true)).visible(this.distance::get)).build());
        this.playersColor = this.sgColors.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("players-color")).description("The other player's color.")).defaultValue(new SettingColor(255, 255, 255)).visible(() -> this.distance.get() == false)).build());
        this.animalsColor = this.sgColors.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("animals-color")).description("The animal's color.")).defaultValue(new SettingColor(25, 255, 25, 255)).visible(() -> this.distance.get() == false)).build());
        this.waterAnimalsColor = this.sgColors.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("water-animals-color")).description("The water animal's color.")).defaultValue(new SettingColor(25, 25, 255, 255)).visible(() -> this.distance.get() == false)).build());
        this.monstersColor = this.sgColors.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("monsters-color")).description("The monster's color.")).defaultValue(new SettingColor(255, 25, 25, 255)).visible(() -> this.distance.get() == false)).build());
        this.ambientColor = this.sgColors.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("ambient-color")).description("The ambient's color.")).defaultValue(new SettingColor(25, 25, 25, 255)).visible(() -> this.distance.get() == false)).build());
        this.miscColor = this.sgColors.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("misc-color")).description("The misc color.")).defaultValue(new SettingColor(175, 175, 175, 255)).visible(() -> this.distance.get() == false)).build());
        this.lineColor = new Color();
        this.sideColor = new Color();
        this.baseColor = new Color();
        this.pos1 = new Vector3d();
        this.pos2 = new Vector3d();
        this.pos = new Vector3d();
    }

    @EventHandler
    private void onRender3D(Render3DEvent event) {
        if (this.mode.get() == Mode._2D) {
            return;
        }
        this.count = 0;
        for (class_1297 entity : this.mc.field_1687.method_18112()) {
            if (this.shouldSkip(entity)) continue;
            if (this.mode.get() == Mode.Box || this.mode.get() == Mode.Wireframe) {
                this.drawBoundingBox(event, entity);
            }
            ++this.count;
        }
    }

    private void drawBoundingBox(Render3DEvent event, class_1297 entity) {
        Color color = this.getColor(entity);
        if (color != null) {
            this.lineColor.set(color);
            this.sideColor.set(color).a((int)((double)this.sideColor.a * this.fillOpacity.get()));
        }
        if (this.mode.get() == Mode.Box) {
            double x = class_3532.method_16436((double)event.tickDelta, (double)entity.field_6038, (double)entity.method_23317()) - entity.method_23317();
            double y = class_3532.method_16436((double)event.tickDelta, (double)entity.field_5971, (double)entity.method_23318()) - entity.method_23318();
            double z = class_3532.method_16436((double)event.tickDelta, (double)entity.field_5989, (double)entity.method_23321()) - entity.method_23321();
            class_238 box = entity.method_5829();
            event.renderer.box(x + box.field_1323, y + box.field_1322, z + box.field_1321, x + box.field_1320, y + box.field_1325, z + box.field_1324, this.sideColor, this.lineColor, this.shapeMode.get(), 0);
        } else {
            WireframeEntityRenderer.render(event, entity, 1.0, this.sideColor, this.lineColor, this.shapeMode.get());
        }
    }

    @EventHandler
    private void onRender2D(Render2DEvent event) {
        if (this.mode.get() != Mode._2D) {
            return;
        }
        Renderer2D.COLOR.begin();
        this.count = 0;
        for (class_1297 entity : this.mc.field_1687.method_18112()) {
            if (this.shouldSkip(entity)) continue;
            class_238 box = entity.method_5829();
            double x = class_3532.method_16436((double)event.tickDelta, (double)entity.field_6038, (double)entity.method_23317()) - entity.method_23317();
            double y = class_3532.method_16436((double)event.tickDelta, (double)entity.field_5971, (double)entity.method_23318()) - entity.method_23318();
            double z = class_3532.method_16436((double)event.tickDelta, (double)entity.field_5989, (double)entity.method_23321()) - entity.method_23321();
            this.pos1.set(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
            this.pos2.set(0.0, 0.0, 0.0);
            if (this.checkCorner(box.field_1323 + x, box.field_1322 + y, box.field_1321 + z, this.pos1, this.pos2) || this.checkCorner(box.field_1320 + x, box.field_1322 + y, box.field_1321 + z, this.pos1, this.pos2) || this.checkCorner(box.field_1323 + x, box.field_1322 + y, box.field_1324 + z, this.pos1, this.pos2) || this.checkCorner(box.field_1320 + x, box.field_1322 + y, box.field_1324 + z, this.pos1, this.pos2) || this.checkCorner(box.field_1323 + x, box.field_1325 + y, box.field_1321 + z, this.pos1, this.pos2) || this.checkCorner(box.field_1320 + x, box.field_1325 + y, box.field_1321 + z, this.pos1, this.pos2) || this.checkCorner(box.field_1323 + x, box.field_1325 + y, box.field_1324 + z, this.pos1, this.pos2) || this.checkCorner(box.field_1320 + x, box.field_1325 + y, box.field_1324 + z, this.pos1, this.pos2)) continue;
            Color color = this.getColor(entity);
            if (color != null) {
                this.lineColor.set(color);
                this.sideColor.set(color).a((int)((double)this.sideColor.a * this.fillOpacity.get()));
            }
            if (this.shapeMode.get() != ShapeMode.Lines && this.sideColor.a > 0) {
                Renderer2D.COLOR.quad(this.pos1.x, this.pos1.y, this.pos2.x - this.pos1.x, this.pos2.y - this.pos1.y, this.sideColor);
            }
            if (this.shapeMode.get() != ShapeMode.Sides) {
                Renderer2D.COLOR.line(this.pos1.x, this.pos1.y, this.pos1.x, this.pos2.y, this.lineColor);
                Renderer2D.COLOR.line(this.pos2.x, this.pos1.y, this.pos2.x, this.pos2.y, this.lineColor);
                Renderer2D.COLOR.line(this.pos1.x, this.pos1.y, this.pos2.x, this.pos1.y, this.lineColor);
                Renderer2D.COLOR.line(this.pos1.x, this.pos2.y, this.pos2.x, this.pos2.y, this.lineColor);
            }
            ++this.count;
        }
        Renderer2D.COLOR.render(null);
    }

    private boolean checkCorner(double x, double y, double z, Vector3d min, Vector3d max) {
        this.pos.set(x, y, z);
        if (!NametagUtils.to2D(this.pos, 1.0)) {
            return true;
        }
        if (this.pos.x < min.x) {
            min.x = this.pos.x;
        }
        if (this.pos.y < min.y) {
            min.y = this.pos.y;
        }
        if (this.pos.z < min.z) {
            min.z = this.pos.z;
        }
        if (this.pos.x > max.x) {
            max.x = this.pos.x;
        }
        if (this.pos.y > max.y) {
            max.y = this.pos.y;
        }
        if (this.pos.z > max.z) {
            max.z = this.pos.z;
        }
        return false;
    }

    public boolean shouldSkip(class_1297 entity) {
        if (!this.entities.get().contains(entity.method_5864())) {
            return true;
        }
        if (entity == this.mc.field_1724 && this.ignoreSelf.get().booleanValue()) {
            return true;
        }
        if (entity == this.mc.field_1719 && this.mc.field_1690.method_31044().method_31034()) {
            return true;
        }
        return !EntityUtils.isInRenderDistance(entity);
    }

    public Color getColor(class_1297 entity) {
        if (!this.entities.get().contains(entity.method_5864())) {
            return null;
        }
        double alpha = this.getFadeAlpha(entity);
        if (alpha == 0.0) {
            return null;
        }
        Color color = this.getEntityTypeColor(entity);
        return this.baseColor.set(color.r, color.g, color.b, (int)((double)color.a * alpha));
    }

    private double getFadeAlpha(class_1297 entity) {
        double dist = PlayerUtils.distanceToCamera(entity.method_23317() + (double)(entity.method_17681() / 2.0f), entity.method_23318() + (double)entity.method_18381(entity.method_18376()), entity.method_23321() + (double)(entity.method_17681() / 2.0f));
        double fadeDist = Math.pow(this.fadeDistance.get(), 2.0);
        double alpha = 1.0;
        if (dist <= fadeDist) {
            alpha = (float)(dist / fadeDist);
        }
        if (alpha <= 0.075) {
            alpha = 0.0;
        }
        return alpha;
    }

    public Color getEntityTypeColor(class_1297 entity) {
        if (this.distance.get().booleanValue()) {
            if (this.friendOverride.get().booleanValue() && entity instanceof class_1657 && Friends.get().isFriend((class_1657)entity)) {
                return Config.get().friendColor.get();
            }
            return EntityUtils.getColorFromDistance(entity);
        }
        if (entity instanceof class_1657) {
            return PlayerUtils.getPlayerColor((class_1657)entity, this.playersColor.get());
        }
        return switch (entity.method_5864().method_5891()) {
            case class_1311.field_6294 -> this.animalsColor.get();
            case class_1311.field_24460, class_1311.field_6300, class_1311.field_30092, class_1311.field_34447 -> this.waterAnimalsColor.get();
            case class_1311.field_6302 -> this.monstersColor.get();
            case class_1311.field_6303 -> this.ambientColor.get();
            default -> this.miscColor.get();
        };
    }

    @Override
    public String getInfoString() {
        return Integer.toString(this.count);
    }

    public boolean isShader() {
        return this.isActive() && this.mode.get() == Mode.Shader;
    }

    public static enum Mode {
        Box,
        Wireframe,
        _2D,
        Shader;


        public String toString() {
            return this == _2D ? "2D" : super.toString();
        }
    }
}

