/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.render;

import baritone.api.BaritoneAPI;
import baritone.api.IBaritone;
import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalGetToBlock;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ListIterator;
import meteordevelopment.meteorclient.events.game.OpenScreenEvent;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.gui.screens.EditSystemScreen;
import meteordevelopment.meteorclient.gui.widgets.WLabel;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WTable;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.gui.widgets.pressable.WCheckbox;
import meteordevelopment.meteorclient.gui.widgets.pressable.WMinus;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.Settings;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.waypoints.Waypoint;
import meteordevelopment.meteorclient.systems.waypoints.Waypoints;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.meteorclient.utils.player.PlayerUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_418;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class WaypointsModule
extends Module {
    private static final Color GRAY = new Color(200, 200, 200);
    private final SettingGroup sgGeneral;
    private final SettingGroup sgDeathPosition;
    public final Setting<Integer> textRenderDistance;
    private final Setting<Integer> maxDeathPositions;
    private final Setting<Boolean> dpChat;
    private final SimpleDateFormat dateFormat;

    public WaypointsModule() {
        super(Categories.Render, "waypoints", "Allows you to create waypoints.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgDeathPosition = this.settings.createGroup("Death Position");
        this.textRenderDistance = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("text-render-distance")).description("Maximum distance from the center of the screen at which text will be rendered.")).defaultValue(100)).min(0).sliderMax(200).build());
        this.maxDeathPositions = this.sgDeathPosition.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("max-death-positions")).description("The amount of death positions to save, 0 to disable")).defaultValue(0)).min(0).sliderMax(20).onChanged(this::cleanDeathWPs)).build());
        this.dpChat = this.sgDeathPosition.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("chat")).description("Send a chat message with your position once you die")).defaultValue(false)).build());
        this.dateFormat = new SimpleDateFormat("HH:mm:ss");
    }

    @EventHandler
    private void onOpenScreen(OpenScreenEvent event) {
        if (!(event.screen instanceof class_418)) {
            return;
        }
        if (!event.isCancelled()) {
            this.addDeath(this.mc.field_1724.method_19538());
        }
    }

    public void addDeath(class_243 deathPos) {
        String time = this.dateFormat.format(new Date());
        if (this.dpChat.get().booleanValue()) {
            class_5250 text = class_2561.method_43470((String)"Died at ");
            text.method_10852((class_2561)ChatUtils.formatCoords(deathPos));
            text.method_27693(String.format(" on %s.", time));
            this.info((class_2561)text);
        }
        if (this.maxDeathPositions.get() > 0) {
            Waypoint waypoint = new Waypoint.Builder().name("Death " + time).icon("skull").pos(class_2338.method_49638((class_2374)deathPos).method_10086(2)).dimension(PlayerUtils.getDimension()).build();
            Waypoints.get().add(waypoint);
        }
        this.cleanDeathWPs(this.maxDeathPositions.get());
    }

    private void cleanDeathWPs(int max) {
        int oldWpC = 0;
        ListIterator<Waypoint> wps = Waypoints.get().iteratorReverse();
        while (wps.hasPrevious()) {
            Waypoint wp = wps.previous();
            if (!wp.name.get().startsWith("Death ") || !"skull".equals(wp.icon.get()) || ++oldWpC <= max) continue;
            Waypoints.get().remove(wp);
        }
    }

    @Override
    public WWidget getWidget(GuiTheme theme) {
        if (!Utils.canUpdate()) {
            return theme.label("You need to be in a world.");
        }
        WTable table = theme.table();
        this.initTable(theme, table);
        return table;
    }

    private void initTable(GuiTheme theme, WTable table) {
        table.clear();
        for (Waypoint waypoint : Waypoints.get()) {
            boolean validDim = Waypoints.checkDimension(waypoint);
            table.add(new WIcon(waypoint));
            WLabel name = table.add(theme.label(waypoint.name.get())).expandCellX().widget();
            if (!validDim) {
                name.color = GRAY;
            }
            WCheckbox visible = table.add(theme.checkbox(waypoint.visible.get())).widget();
            visible.action = () -> {
                waypoint.visible.set(visible.checked);
                Waypoints.get().save();
            };
            WButton edit = table.add(theme.button(GuiRenderer.EDIT)).widget();
            edit.action = () -> this.mc.method_1507((class_437)new EditWaypointScreen(theme, waypoint, null));
            if (validDim) {
                WButton gotoB = table.add(theme.button("Goto")).widget();
                gotoB.action = () -> {
                    IBaritone baritone = BaritoneAPI.getProvider().getPrimaryBaritone();
                    if (baritone.getPathingBehavior().isPathing()) {
                        baritone.getPathingBehavior().cancelEverything();
                    }
                    baritone.getCustomGoalProcess().setGoalAndPath((Goal)new GoalGetToBlock(waypoint.getPos()));
                };
            }
            WMinus remove = table.add(theme.minus()).widget();
            remove.action = () -> {
                Waypoints.get().remove(waypoint);
                this.initTable(theme, table);
            };
            table.row();
        }
        table.add(theme.horizontalSeparator()).expandX();
        table.row();
        WButton create = table.add(theme.button("Create")).expandX().widget();
        create.action = () -> this.mc.method_1507((class_437)new EditWaypointScreen(theme, null, () -> this.initTable(theme, table)));
    }

    private static class WIcon
    extends WWidget {
        private final Waypoint waypoint;

        public WIcon(Waypoint waypoint) {
            this.waypoint = waypoint;
        }

        @Override
        protected void onCalculateSize() {
            double s;
            this.width = s = this.theme.scale(32.0);
            this.height = s;
        }

        @Override
        protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
            renderer.post(() -> this.waypoint.renderIcon(this.x, this.y, 1.0, this.width));
        }
    }

    private class EditWaypointScreen
    extends EditSystemScreen<Waypoint> {
        public EditWaypointScreen(GuiTheme theme, Waypoint value, Runnable reload) {
            super(theme, value, reload);
        }

        @Override
        public Waypoint create() {
            return new Waypoint.Builder().pos(((WaypointsModule)WaypointsModule.this).mc.field_1724.method_24515().method_10086(2)).dimension(PlayerUtils.getDimension()).build();
        }

        @Override
        public boolean save() {
            return !this.isNew || Waypoints.get().add((Waypoint)this.value);
        }

        @Override
        public Settings getSettings() {
            return ((Waypoint)this.value).settings;
        }
    }
}

