/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.world;

import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BlockListSetting;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.ItemListSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.player.AutoEat;
import meteordevelopment.meteorclient.systems.modules.player.AutoGap;
import meteordevelopment.meteorclient.systems.modules.player.AutoTool;
import meteordevelopment.meteorclient.utils.misc.HorizontalDirection;
import meteordevelopment.meteorclient.utils.misc.MBlockPos;
import meteordevelopment.meteorclient.utils.player.CustomPlayerInput;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.player.PlayerUtils;
import meteordevelopment.meteorclient.utils.player.Rotations;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.meteorclient.utils.world.BlockUtils;
import meteordevelopment.meteorclient.utils.world.Dir;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_5250;
import net.minecraft.class_744;
import org.jetbrains.annotations.NotNull;

public class HighwayBuilder
extends Module {
    private static final class_2338 ZERO = new class_2338(0, 0, 0);
    private final SettingGroup sgGeneral;
    private final SettingGroup sgRenderMine;
    private final SettingGroup sgRenderPlace;
    private final Setting<Integer> width;
    private final Setting<Integer> height;
    private final Setting<Floor> floor;
    private final Setting<Boolean> railings;
    private final Setting<Boolean> mineAboveRailings;
    private final Setting<Rotation> rotation;
    private final Setting<List<class_2248>> blocksToPlace;
    private final Setting<List<class_1792>> trashItems;
    private final Setting<Boolean> dontBreakTools;
    private final Setting<Boolean> mineEnderChests;
    private final Setting<Boolean> disconnectOnToggle;
    private final Setting<Boolean> renderMine;
    private final Setting<ShapeMode> renderMineShape;
    private final Setting<SettingColor> renderMineSideColor;
    private final Setting<SettingColor> renderMineLineColor;
    private final Setting<Boolean> renderPlace;
    private final Setting<ShapeMode> renderPlaceShape;
    private final Setting<SettingColor> renderPlaceSideColor;
    private final Setting<SettingColor> renderPlaceLineColor;
    private HorizontalDirection dir;
    private HorizontalDirection leftDir;
    private HorizontalDirection rightDir;
    private class_744 prevInput;
    private CustomPlayerInput input;
    private State state;
    private State lastState;
    private IBlockPosProvider blockPosProvider;
    public class_243 start;
    public int blocksBroken;
    public int blocksPlaced;
    private final MBlockPos lastBreakingPos;
    private boolean displayInfo;
    private final MBlockPos posRender2;
    private final MBlockPos posRender3;

    public HighwayBuilder() {
        super(Categories.World, "highway-builder", "Automatically builds highways.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgRenderMine = this.settings.createGroup("Render Mine");
        this.sgRenderPlace = this.settings.createGroup("Render Place");
        this.width = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("width")).description("Width of the highway.")).defaultValue(4)).range(1, 5).sliderRange(1, 5).build());
        this.height = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("height")).description("Height of the highway.")).defaultValue(3)).range(2, 5).sliderRange(2, 5).build());
        this.floor = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("floor")).description("What floor placement mode to use.")).defaultValue(Floor.Replace)).build());
        this.railings = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("railings")).description("Builds railings next to the highway.")).defaultValue(true)).build());
        this.mineAboveRailings = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("mine-above-railings")).description("Mines blocks above railings.")).visible(this.railings::get)).defaultValue(true)).build());
        this.rotation = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("rotation")).description("Mode of rotation.")).defaultValue(Rotation.Both)).build());
        this.blocksToPlace = this.sgGeneral.add(((BlockListSetting.Builder)((BlockListSetting.Builder)new BlockListSetting.Builder().name("blocks-to-place")).description("Blocks it is allowed to place.")).defaultValue(class_2246.field_10540).filter(block -> class_2248.method_9614((class_265)block.method_9564().method_26220((class_1922)this.mc.field_1687, ZERO))).build());
        this.trashItems = this.sgGeneral.add(((ItemListSetting.Builder)((ItemListSetting.Builder)new ItemListSetting.Builder().name("trash-items")).description("Items that are considered trash and can be thrown out.")).defaultValue(class_1802.field_8328, class_1802.field_8155, class_1802.field_8397, class_1802.field_8601, class_1802.field_23843, class_1802.field_22000).build());
        this.dontBreakTools = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("dont-break-tools")).description("Don't break tools.")).defaultValue(false)).build());
        this.mineEnderChests = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("mine-ender-chests")).description("Mines ender chests for obsidian.")).defaultValue(true)).build());
        this.disconnectOnToggle = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("disconnect-on-toggle")).description("Automatically disconnects when the module is turned off, for example for not having enough blocks.")).defaultValue(false)).build());
        this.renderMine = this.sgRenderMine.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("render-blocks-to-mine")).description("Render blocks to be mined.")).defaultValue(true)).build());
        this.renderMineShape = this.sgRenderMine.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("blocks-to-mine-shape-mode")).description("How the blocks to be mined are rendered.")).defaultValue(ShapeMode.Both)).build());
        this.renderMineSideColor = this.sgRenderMine.add(((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("blocks-to-mine-side-color")).description("Color of blocks to be mined.")).defaultValue(new SettingColor(225, 25, 25, 25)).build());
        this.renderMineLineColor = this.sgRenderMine.add(((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("blocks-to-mine-line-color")).description("Color of blocks to be mined.")).defaultValue(new SettingColor(225, 25, 25)).build());
        this.renderPlace = this.sgRenderPlace.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("render-blocks-to-place")).description("Render blocks to be placed.")).defaultValue(true)).build());
        this.renderPlaceShape = this.sgRenderPlace.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("blocks-to-place-shape-mode")).description("How the blocks to be placed are rendered.")).defaultValue(ShapeMode.Both)).build());
        this.renderPlaceSideColor = this.sgRenderPlace.add(((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("blocks-to-place-side-color")).description("Color of blocks to be placed.")).defaultValue(new SettingColor(25, 25, 225, 25)).build());
        this.renderPlaceLineColor = this.sgRenderPlace.add(((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("blocks-to-place-line-color")).description("Color of blocks to be placed.")).defaultValue(new SettingColor(25, 25, 225)).build());
        this.lastBreakingPos = new MBlockPos();
        this.posRender2 = new MBlockPos();
        this.posRender3 = new MBlockPos();
    }

    @Override
    public void onActivate() {
        this.dir = HorizontalDirection.get(this.mc.field_1724.method_36454());
        this.leftDir = this.dir.rotateLeftSkipOne();
        this.rightDir = this.leftDir.opposite();
        this.prevInput = this.mc.field_1724.field_3913;
        this.input = new CustomPlayerInput();
        this.mc.field_1724.field_3913 = this.input;
        this.state = State.Forward;
        this.setState(State.Center);
        this.blockPosProvider = this.dir.diagonal ? new DiagonalBlockPosProvider() : new StraightBlockPosProvider();
        this.start = this.mc.field_1724.method_19538();
        this.blocksPlaced = 0;
        this.blocksBroken = 0;
        this.lastBreakingPos.set(0, 0, 0);
        this.displayInfo = true;
    }

    @Override
    public void onDeactivate() {
        this.mc.field_1724.field_3913 = this.prevInput;
        this.mc.field_1724.method_36456(this.dir.yaw);
        if (this.displayInfo) {
            this.info("Distance: (highlight)%.0f", PlayerUtils.distanceTo(this.start));
            this.info("Blocks broken: (highlight)%d", this.blocksBroken);
            this.info("Blocks placed: (highlight)%d", this.blocksPlaced);
        }
    }

    @Override
    public void error(String message, Object ... args) {
        super.error(message, args);
        this.toggle();
        if (this.disconnectOnToggle.get().booleanValue()) {
            this.disconnect(message, args);
        }
    }

    private void errorEarly(String message, Object ... args) {
        super.error(message, args);
        this.displayInfo = false;
        this.toggle();
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.width.get() < 3 && this.dir.diagonal) {
            this.errorEarly("Diagonal highways with width less than 3 are not supported.", new Object[0]);
            return;
        }
        if (Modules.get().get(AutoEat.class).eating) {
            return;
        }
        if (Modules.get().get(AutoGap.class).isEating()) {
            return;
        }
        this.state.tick(this);
    }

    @EventHandler
    private void onRender3D(Render3DEvent event) {
        if (this.renderMine.get().booleanValue()) {
            this.render(event, this.blockPosProvider.getFront(), mBlockPos -> this.canMine((MBlockPos)mBlockPos, true), true);
            if (this.floor.get() == Floor.Replace) {
                this.render(event, this.blockPosProvider.getFloor(), mBlockPos -> this.canMine((MBlockPos)mBlockPos, false), true);
            }
            if (this.railings.get().booleanValue()) {
                this.render(event, this.blockPosProvider.getRailings(true), mBlockPos -> this.canMine((MBlockPos)mBlockPos, false), true);
            }
            if (this.state == State.MineEChestBlockade) {
                this.render(event, this.blockPosProvider.getEChestBlockade(true), mBlockPos -> this.canMine((MBlockPos)mBlockPos, true), true);
            }
        }
        if (this.renderPlace.get().booleanValue()) {
            this.render(event, this.blockPosProvider.getLiquids(), mBlockPos -> this.canPlace((MBlockPos)mBlockPos, true), false);
            if (this.railings.get().booleanValue()) {
                this.render(event, this.blockPosProvider.getRailings(false), mBlockPos -> this.canPlace((MBlockPos)mBlockPos, false), false);
            }
            this.render(event, this.blockPosProvider.getFloor(), mBlockPos -> this.canPlace((MBlockPos)mBlockPos, false), false);
            if (this.state == State.PlaceEChestBlockade) {
                this.render(event, this.blockPosProvider.getEChestBlockade(false), mBlockPos -> this.canPlace((MBlockPos)mBlockPos, false), false);
            }
        }
    }

    private void render(Render3DEvent event, MBPIterator it, Predicate<MBlockPos> predicate, boolean mine) {
        Color sideColor = mine ? (Color)this.renderMineSideColor.get() : (Color)this.renderPlaceSideColor.get();
        Color lineColor = mine ? (Color)this.renderMineLineColor.get() : (Color)this.renderPlaceLineColor.get();
        ShapeMode shapeMode = mine ? this.renderMineShape.get() : this.renderPlaceShape.get();
        for (MBlockPos pos : it) {
            this.posRender2.set(pos);
            if (!predicate.test(this.posRender2)) continue;
            int excludeDir = 0;
            for (class_2350 side : class_2350.values()) {
                this.posRender3.set(this.posRender2).add(side.method_10148(), side.method_10164(), side.method_10165());
                it.save();
                for (MBlockPos p : it) {
                    if (!p.equals(this.posRender3) || !predicate.test(p)) continue;
                    excludeDir |= Dir.get(side);
                }
                it.restore();
            }
            event.renderer.box(this.posRender2.getMcPos(), sideColor, lineColor, shapeMode, excludeDir);
        }
    }

    private void setState(State state) {
        this.lastState = this.state;
        this.state = state;
        this.input.stop();
        state.start(this);
    }

    private int getWidthLeft() {
        return switch (this.width.get()) {
            default -> 0;
            case 2, 3 -> 1;
            case 4, 5 -> 2;
        };
    }

    private int getWidthRight() {
        return switch (this.width.get()) {
            default -> 0;
            case 3, 4 -> 1;
            case 5 -> 2;
        };
    }

    private boolean canMine(MBlockPos pos, boolean ignoreBlocksToPlace) {
        class_2680 state = pos.getState();
        return BlockUtils.canBreak(pos.getMcPos(), state) && (ignoreBlocksToPlace || !this.blocksToPlace.get().contains(state.method_26204()));
    }

    private boolean canPlace(MBlockPos pos, boolean liquids) {
        return liquids ? !pos.getState().method_26227().method_15769() : pos.getState().method_26215();
    }

    private void disconnect(String message, Object ... args) {
        class_5250 text = class_2561.method_43470((String)(String.format("%s[%s%s%s] %s", class_124.field_1080, class_124.field_1078, this.title, class_124.field_1080, class_124.field_1061) + String.format(message, args))).method_27693("\n");
        text.method_10852((class_2561)this.getStatsText());
        this.mc.method_1562().method_48296().method_10747((class_2561)text);
    }

    public class_5250 getStatsText() {
        class_5250 text = class_2561.method_43470((String)String.format("%sDistance: %s%.0f\n", class_124.field_1080, class_124.field_1068, this.mc.field_1724 == null ? 0.0 : PlayerUtils.distanceTo(this.start)));
        text.method_27693(String.format("%sBlocks broken: %s%d\n", class_124.field_1080, class_124.field_1068, this.blocksBroken));
        text.method_27693(String.format("%sBlocks placed: %s%d", class_124.field_1080, class_124.field_1068, this.blocksPlaced));
        return text;
    }

    public static enum Floor {
        Replace,
        PlaceMissing;

    }

    public static enum Rotation {
        None(false, false),
        Mine(true, false),
        Place(false, true),
        Both(true, true);

        public boolean mine;
        public boolean place;

        private Rotation(boolean mine, boolean place) {
            this.mine = mine;
            this.place = place;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum State {
        Center{

            @Override
            protected void tick(HighwayBuilder b) {
                boolean isZ;
                double x = Math.abs(((HighwayBuilder)b).mc.field_1724.method_23317() - (double)((int)((HighwayBuilder)b).mc.field_1724.method_23317())) - 0.5;
                double z = Math.abs(((HighwayBuilder)b).mc.field_1724.method_23321() - (double)((int)((HighwayBuilder)b).mc.field_1724.method_23321())) - 0.5;
                boolean isX = Math.abs(x) <= 0.1;
                boolean bl = isZ = Math.abs(z) <= 0.1;
                if (isX && isZ) {
                    ((HighwayBuilder)b).mc.field_1724.method_5814((double)((int)((HighwayBuilder)b).mc.field_1724.method_23317()) + (((HighwayBuilder)b).mc.field_1724.method_23317() < 0.0 ? -0.5 : 0.5), ((HighwayBuilder)b).mc.field_1724.method_23318(), (double)((int)((HighwayBuilder)b).mc.field_1724.method_23321()) + (((HighwayBuilder)b).mc.field_1724.method_23321() < 0.0 ? -0.5 : 0.5));
                    b.setState(b.lastState);
                } else {
                    ((HighwayBuilder)b).mc.field_1724.method_36456(0.0f);
                    if (!isZ) {
                        b.input.field_3910 = z < 0.0;
                        boolean bl2 = b.input.field_3909 = z > 0.0;
                        if (((HighwayBuilder)b).mc.field_1724.method_23321() < 0.0) {
                            boolean forward = b.input.field_3910;
                            b.input.field_3910 = b.input.field_3909;
                            b.input.field_3909 = forward;
                        }
                    }
                    if (!isX) {
                        b.input.field_3906 = x > 0.0;
                        boolean bl3 = b.input.field_3908 = x < 0.0;
                        if (((HighwayBuilder)b).mc.field_1724.method_23317() < 0.0) {
                            boolean right = b.input.field_3906;
                            b.input.field_3906 = b.input.field_3908;
                            b.input.field_3908 = right;
                        }
                    }
                    b.input.field_3903 = true;
                }
            }
        }
        ,
        Forward{

            @Override
            protected void tick(HighwayBuilder b) {
                ((HighwayBuilder)b).mc.field_1724.method_36456(b.dir.yaw);
                if (this.needsToPlace(b, b.blockPosProvider.getLiquids(), true)) {
                    b.setState(FillLiquids);
                } else if (this.needsToMine(b, b.blockPosProvider.getFront(), true)) {
                    b.setState(MineFront);
                } else if (b.floor.get() == Floor.Replace && this.needsToMine(b, b.blockPosProvider.getFloor(), false)) {
                    b.setState(MineFloor);
                } else if (b.railings.get().booleanValue() && this.needsToMine(b, b.blockPosProvider.getRailings(true), false)) {
                    b.setState(MineRailings);
                } else if (b.railings.get().booleanValue() && this.needsToPlace(b, b.blockPosProvider.getRailings(false), false)) {
                    b.setState(PlaceRailings);
                } else if (this.needsToPlace(b, b.blockPosProvider.getFloor(), false)) {
                    b.setState(PlaceFloor);
                } else {
                    b.input.field_3910 = true;
                }
            }

            private boolean needsToMine(HighwayBuilder b, MBPIterator it, boolean ignoreBlocksToPlace) {
                for (MBlockPos pos : it) {
                    if (!b.canMine(pos, ignoreBlocksToPlace)) continue;
                    return true;
                }
                return false;
            }

            private boolean needsToPlace(HighwayBuilder b, MBPIterator it, boolean liquids) {
                for (MBlockPos pos : it) {
                    if (!b.canPlace(pos, liquids)) continue;
                    return true;
                }
                return false;
            }
        }
        ,
        FillLiquids{

            @Override
            protected void tick(HighwayBuilder b) {
                int slot = this.findBlocksToPlacePrioritizeTrash(b);
                if (slot == -1) {
                    return;
                }
                this.place(b, new MBPIteratorFilter(b.blockPosProvider.getLiquids(), pos -> !pos.getState().method_26227().method_15769()), slot, Forward);
            }
        }
        ,
        MineFront{

            @Override
            protected void tick(HighwayBuilder b) {
                this.mine(b, b.blockPosProvider.getFront(), true);
            }
        }
        ,
        MineFloor{

            @Override
            protected void tick(HighwayBuilder b) {
                this.mine(b, b.blockPosProvider.getFloor(), false);
            }
        }
        ,
        PlaceFloor{

            @Override
            protected void tick(HighwayBuilder b) {
                int slot = this.findBlocksToPlace(b);
                if (slot == -1) {
                    return;
                }
                this.place(b, b.blockPosProvider.getFloor(), slot, Forward);
            }
        }
        ,
        MineRailings{

            @Override
            protected void tick(HighwayBuilder b) {
                this.mine(b, b.blockPosProvider.getRailings(true), false);
            }
        }
        ,
        PlaceRailings{

            @Override
            protected void tick(HighwayBuilder b) {
                int slot = this.findBlocksToPlace(b);
                if (slot == -1) {
                    return;
                }
                this.place(b, b.blockPosProvider.getRailings(false), slot, Forward);
            }
        }
        ,
        ThrowOutTrash{
            private int skipSlot;
            private boolean timerEnabled;
            private boolean firstTick;
            private int timer;

            @Override
            protected void start(HighwayBuilder b) {
                int biggestCount = 0;
                for (int i = 0; i < ((HighwayBuilder)b).mc.field_1724.method_31548().field_7547.size(); ++i) {
                    class_1799 itemStack = ((HighwayBuilder)b).mc.field_1724.method_31548().method_5438(i);
                    if (!(itemStack.method_7909() instanceof class_1747) || !b.trashItems.get().contains(itemStack.method_7909()) || itemStack.method_7947() <= biggestCount) continue;
                    biggestCount = itemStack.method_7947();
                    this.skipSlot = i;
                    if (biggestCount >= 64) break;
                }
                if (biggestCount == 0) {
                    this.skipSlot = -1;
                }
                this.timerEnabled = false;
                this.firstTick = true;
            }

            @Override
            protected void tick(HighwayBuilder b) {
                if (this.timerEnabled) {
                    if (this.timer > 0) {
                        --this.timer;
                    } else {
                        b.setState(b.lastState);
                    }
                    return;
                }
                ((HighwayBuilder)b).mc.field_1724.method_36456(b.dir.opposite().yaw);
                ((HighwayBuilder)b).mc.field_1724.method_36457(-25.0f);
                if (this.firstTick) {
                    this.firstTick = false;
                    return;
                }
                for (int i = 0; i < ((HighwayBuilder)b).mc.field_1724.method_31548().field_7547.size(); ++i) {
                    if (i == this.skipSlot) continue;
                    class_1799 itemStack = ((HighwayBuilder)b).mc.field_1724.method_31548().method_5438(i);
                    if (!b.trashItems.get().contains(itemStack.method_7909())) continue;
                    InvUtils.drop().slot(i);
                    return;
                }
                this.timerEnabled = true;
                this.timer = 10;
            }
        }
        ,
        PlaceEChestBlockade{

            @Override
            protected void tick(HighwayBuilder b) {
                int slot = this.findBlocksToPlacePrioritizeTrash(b);
                if (slot == -1) {
                    return;
                }
                this.place(b, b.blockPosProvider.getEChestBlockade(false), slot, MineEnderChests);
            }
        }
        ,
        MineEChestBlockade{

            @Override
            protected void tick(HighwayBuilder b) {
                this.mine(b, b.blockPosProvider.getEChestBlockade(true), true, Center, Forward);
            }
        }
        ,
        MineEnderChests{
            private static final MBlockPos pos = new MBlockPos();
            private int minimumObsidian;
            private boolean first;
            private int moveTimer;
            private boolean stopTimerEnabled;
            private int stopTimer;

            @Override
            protected void start(HighwayBuilder b) {
                if (b.lastState != Center && b.lastState != ThrowOutTrash && b.lastState != PlaceEChestBlockade) {
                    b.setState(Center);
                    return;
                }
                if (b.lastState == Center) {
                    b.setState(ThrowOutTrash);
                    return;
                }
                if (b.lastState == ThrowOutTrash) {
                    b.setState(PlaceEChestBlockade);
                    return;
                }
                int emptySlots = 0;
                for (int i = 0; i < ((HighwayBuilder)b).mc.field_1724.method_31548().field_7547.size(); ++i) {
                    if (!((HighwayBuilder)b).mc.field_1724.method_31548().method_5438(i).method_7960()) continue;
                    ++emptySlots;
                }
                if (emptySlots == 0) {
                    b.error("No empty slots.", new Object[0]);
                    return;
                }
                int minimumSlots = Math.max(emptySlots - 4, 1);
                this.minimumObsidian = minimumSlots * 64;
                this.first = true;
                this.moveTimer = 0;
                this.stopTimerEnabled = false;
            }

            @Override
            protected void tick(HighwayBuilder b) {
                if (this.stopTimerEnabled) {
                    if (this.stopTimer > 0) {
                        --this.stopTimer;
                    } else {
                        b.setState(MineEChestBlockade);
                    }
                    return;
                }
                HorizontalDirection dir = b.dir.diagonal ? b.dir.rotateLeft().rotateLeftSkipOne() : b.dir.opposite();
                pos.set((class_1297)((HighwayBuilder)b).mc.field_1724).offset(dir);
                if (this.moveTimer > 0) {
                    ((HighwayBuilder)b).mc.field_1724.method_36456(dir.yaw);
                    b.input.field_3910 = this.moveTimer > 2;
                    --this.moveTimer;
                    return;
                }
                int obsidianCount = 0;
                for (class_1297 entity : ((HighwayBuilder)b).mc.field_1687.method_8335((class_1297)((HighwayBuilder)b).mc.field_1724, new class_238((double)12.pos.x, (double)12.pos.y, (double)12.pos.z, (double)(12.pos.x + 1), (double)(12.pos.y + 2), (double)(12.pos.z + 1)))) {
                    class_1542 itemEntity;
                    if (!(entity instanceof class_1542) || (itemEntity = (class_1542)entity).method_6983().method_7909() != class_1802.field_8281) continue;
                    obsidianCount += itemEntity.method_6983().method_7947();
                }
                for (int i = 0; i < ((HighwayBuilder)b).mc.field_1724.method_31548().field_7547.size(); ++i) {
                    class_1799 itemStack2 = ((HighwayBuilder)b).mc.field_1724.method_31548().method_5438(i);
                    if (itemStack2.method_7909() != class_1802.field_8281) continue;
                    obsidianCount += itemStack2.method_7947();
                }
                if (obsidianCount >= this.minimumObsidian) {
                    this.stopTimerEnabled = true;
                    this.stopTimer = 8;
                    return;
                }
                class_2680 blockState = ((HighwayBuilder)b).mc.field_1687.method_8320(pos.getMcPos());
                if (blockState.method_26204() == class_2246.field_10443) {
                    int slot = this.findAndMoveBestToolToHotbar(b, blockState, true, false);
                    if (slot == -1) {
                        b.error("Cannot find pickaxe with silk touch to mine ender chests.", new Object[0]);
                        return;
                    }
                    InvUtils.swap(slot, false);
                    BlockUtils.breakBlock(pos.getMcPos(), true);
                } else {
                    int slot = this.findAndMoveToHotbar(b, itemStack -> itemStack.method_7909() == class_1802.field_8466, false);
                    if (slot == -1) {
                        this.stopTimerEnabled = true;
                        this.stopTimer = 4;
                        return;
                    }
                    if (this.first) {
                        this.moveTimer = 8;
                        this.first = false;
                    }
                    BlockUtils.place(pos.getMcPos(), class_1268.field_5808, slot, true, 0, true, true, false);
                }
            }
        };


        protected void start(HighwayBuilder b) {
        }

        protected abstract void tick(HighwayBuilder var1);

        protected void mine(HighwayBuilder b, MBPIterator it, boolean ignoreBlocksToPlace, State nextState, State lastState) {
            boolean breaking = false;
            for (MBlockPos pos : it) {
                class_2680 state = pos.getState();
                if (state.method_26215() || !ignoreBlocksToPlace && b.blocksToPlace.get().contains(state.method_26204())) continue;
                int slot = this.findAndMoveBestToolToHotbar(b, state, false, true);
                if (slot == -1) {
                    return;
                }
                InvUtils.swap(slot, false);
                class_2338 mcPos = pos.getMcPos();
                if (!BlockUtils.canBreak(mcPos)) continue;
                if (b.rotation.get().mine) {
                    Rotations.rotate(Rotations.getYaw(mcPos), Rotations.getPitch(mcPos), () -> BlockUtils.breakBlock(pos.getMcPos(), true));
                } else {
                    BlockUtils.breakBlock(mcPos, true);
                }
                breaking = true;
                if (b.lastBreakingPos.equals(pos)) break;
                b.lastBreakingPos.set(pos);
                ++b.blocksBroken;
                break;
            }
            if (!breaking) {
                b.setState(nextState);
                b.lastState = lastState;
            }
        }

        protected void mine(HighwayBuilder b, MBPIterator it, boolean ignoreBlocksToPlace) {
            this.mine(b, it, ignoreBlocksToPlace, Forward, b.state);
        }

        protected void place(HighwayBuilder b, MBPIterator it, int slot, State nextState) {
            boolean placed = false;
            for (MBlockPos pos : it) {
                if (!BlockUtils.place(pos.getMcPos(), class_1268.field_5808, slot, b.rotation.get().place, 0, true, true, true)) continue;
                placed = true;
                ++b.blocksPlaced;
                break;
            }
            if (!placed) {
                b.setState(nextState);
            }
        }

        private int findSlot(HighwayBuilder b, Predicate<class_1799> predicate, boolean hotbar) {
            for (int i = hotbar ? 0 : 9; i < (hotbar ? 9 : ((HighwayBuilder)b).mc.field_1724.method_31548().field_7547.size()); ++i) {
                if (!predicate.test(((HighwayBuilder)b).mc.field_1724.method_31548().method_5438(i))) continue;
                return i;
            }
            return -1;
        }

        private int findHotbarSlot(HighwayBuilder b, boolean replaceTools) {
            int thrashSlot = -1;
            int slotsWithBlocks = 0;
            int slotWithLeastBlocks = 65;
            int slowWithLeastBlocksCount = 0;
            for (int i = 0; i < 9; ++i) {
                class_1792 class_17922;
                class_1799 itemStack = ((HighwayBuilder)b).mc.field_1724.method_31548().method_5438(i);
                if (itemStack.method_7960()) {
                    return i;
                }
                if (replaceTools && AutoTool.isTool(itemStack)) {
                    return i;
                }
                if (b.trashItems.get().contains(itemStack.method_7909())) {
                    thrashSlot = i;
                }
                if (!((class_17922 = itemStack.method_7909()) instanceof class_1747)) continue;
                class_1747 blockItem = (class_1747)class_17922;
                if (!b.blocksToPlace.get().contains(blockItem.method_7711())) continue;
                ++slotsWithBlocks;
                if (itemStack.method_7947() >= slowWithLeastBlocksCount) continue;
                slowWithLeastBlocksCount = itemStack.method_7947();
                slotWithLeastBlocks = i;
            }
            if (thrashSlot != -1) {
                return thrashSlot;
            }
            if (slotsWithBlocks > 1) {
                return slotWithLeastBlocks;
            }
            b.error("No empty space in hotbar.", new Object[0]);
            return -1;
        }

        private boolean hasItem(HighwayBuilder b, class_1792 item) {
            for (int i = 0; i < ((HighwayBuilder)b).mc.field_1724.method_31548().field_7547.size(); ++i) {
                if (((HighwayBuilder)b).mc.field_1724.method_31548().method_5438(i).method_7909() != item) continue;
                return true;
            }
            return false;
        }

        protected int findAndMoveToHotbar(HighwayBuilder b, Predicate<class_1799> predicate, boolean required) {
            int slot = this.findSlot(b, predicate, true);
            if (slot != -1) {
                return slot;
            }
            int hotbarSlot = this.findHotbarSlot(b, false);
            if (hotbarSlot == -1) {
                return -1;
            }
            slot = this.findSlot(b, predicate, false);
            if (slot == -1) {
                if (required) {
                    b.error("Out of items.", new Object[0]);
                }
                return -1;
            }
            InvUtils.move().from(slot).toHotbar(hotbarSlot);
            InvUtils.dropHand();
            return hotbarSlot;
        }

        protected int findAndMoveBestToolToHotbar(HighwayBuilder b, class_2680 blockState, boolean noSilkTouch, boolean error) {
            if (((HighwayBuilder)b).mc.field_1724.method_7337()) {
                return ((HighwayBuilder)b).mc.field_1724.method_31548().field_7545;
            }
            double bestScore = -1.0;
            int bestSlot = -1;
            for (int i = 0; i < ((HighwayBuilder)b).mc.field_1724.method_31548().field_7547.size(); ++i) {
                double score = AutoTool.getScore(((HighwayBuilder)b).mc.field_1724.method_31548().method_5438(i), blockState, false, AutoTool.EnchantPreference.None, itemStack -> {
                    if (noSilkTouch && class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)itemStack) != 0) {
                        return false;
                    }
                    return b.dontBreakTools.get() == false || itemStack.method_7936() - itemStack.method_7919() > 1;
                });
                if (!(score > bestScore)) continue;
                bestScore = score;
                bestSlot = i;
            }
            if (bestSlot == -1) {
                if (error) {
                    b.error("Failed to find suitable tool for mining.", new Object[0]);
                }
                return -1;
            }
            if (bestSlot < 9) {
                return bestSlot;
            }
            int hotbarSlot = this.findHotbarSlot(b, true);
            if (hotbarSlot == -1) {
                return -1;
            }
            InvUtils.move().from(bestSlot).toHotbar(hotbarSlot);
            InvUtils.dropHand();
            return hotbarSlot;
        }

        protected int findBlocksToPlace(HighwayBuilder b) {
            int slot = this.findAndMoveToHotbar(b, itemStack -> {
                class_1792 patt33373$temp = itemStack.method_7909();
                if (!(patt33373$temp instanceof class_1747)) return false;
                class_1747 blockItem = (class_1747)patt33373$temp;
                if (!b.blocksToPlace.get().contains(blockItem.method_7711())) return false;
                return true;
            }, false);
            if (slot == -1) {
                if (!b.mineEnderChests.get().booleanValue()) {
                    b.error("Out of blocks to place.", new Object[0]);
                } else if (this.hasItem(b, class_1802.field_8466)) {
                    b.setState(MineEnderChests);
                } else {
                    b.error("Out of blocks to place.", new Object[0]);
                }
                return -1;
            }
            return slot;
        }

        protected int findBlocksToPlacePrioritizeTrash(HighwayBuilder b) {
            int slot = this.findAndMoveToHotbar(b, itemStack -> {
                if (!(itemStack.method_7909() instanceof class_1747)) {
                    return false;
                }
                return b.trashItems.get().contains(itemStack.method_7909());
            }, false);
            return slot != -1 ? slot : this.findBlocksToPlace(b);
        }
    }

    private class DiagonalBlockPosProvider
    implements IBlockPosProvider {
        private final MBlockPos pos = new MBlockPos();
        private final MBlockPos pos2 = new MBlockPos();

        private DiagonalBlockPosProvider() {
        }

        @Override
        public MBPIterator getFront() {
            this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).offset(HighwayBuilder.this.dir.rotateLeft()).offset(HighwayBuilder.this.leftDir, HighwayBuilder.this.getWidthLeft() - 1);
            return new MBPIterator(){
                private int i;
                private int w;
                private int y;
                private int pi;
                private int pw;
                private int py;

                @Override
                public boolean hasNext() {
                    return this.i < 2 && this.w < HighwayBuilder.this.width.get() && this.y < HighwayBuilder.this.height.get();
                }

                @Override
                public MBlockPos next() {
                    DiagonalBlockPosProvider.this.pos2.set(DiagonalBlockPosProvider.this.pos).offset(HighwayBuilder.this.rightDir, this.w).add(0, this.y++, 0);
                    if (this.y >= HighwayBuilder.this.height.get()) {
                        this.y = 0;
                        ++this.w;
                        if (this.w >= (this.i == 0 ? HighwayBuilder.this.width.get() - 1 : HighwayBuilder.this.width.get())) {
                            this.w = 0;
                            ++this.i;
                            DiagonalBlockPosProvider.this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).offset(HighwayBuilder.this.dir).offset(HighwayBuilder.this.leftDir, HighwayBuilder.this.getWidthLeft());
                        }
                    }
                    return DiagonalBlockPosProvider.this.pos2;
                }

                private void initPos() {
                    if (this.i == 0) {
                        DiagonalBlockPosProvider.this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).offset(HighwayBuilder.this.dir.rotateLeft()).offset(HighwayBuilder.this.leftDir, HighwayBuilder.this.getWidthLeft() - 1);
                    } else {
                        DiagonalBlockPosProvider.this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).offset(HighwayBuilder.this.dir).offset(HighwayBuilder.this.leftDir, HighwayBuilder.this.getWidthLeft());
                    }
                }

                @Override
                public void save() {
                    this.pi = this.i;
                    this.pw = this.w;
                    this.py = this.y;
                    this.y = 0;
                    this.w = 0;
                    this.i = 0;
                    this.initPos();
                }

                @Override
                public void restore() {
                    this.i = this.pi;
                    this.w = this.pw;
                    this.y = this.py;
                    this.initPos();
                }
            };
        }

        @Override
        public MBPIterator getFloor() {
            this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).add(0, -1, 0).offset(HighwayBuilder.this.dir.rotateLeft()).offset(HighwayBuilder.this.leftDir, HighwayBuilder.this.getWidthLeft() - 1);
            return new MBPIterator(){
                private int i;
                private int w;
                private int pi;
                private int pw;

                @Override
                public boolean hasNext() {
                    return this.i < 2 && this.w < HighwayBuilder.this.width.get();
                }

                @Override
                public MBlockPos next() {
                    DiagonalBlockPosProvider.this.pos2.set(DiagonalBlockPosProvider.this.pos).offset(HighwayBuilder.this.rightDir, this.w++);
                    if (this.w >= (this.i == 0 ? HighwayBuilder.this.width.get() - 1 : HighwayBuilder.this.width.get())) {
                        this.w = 0;
                        ++this.i;
                        DiagonalBlockPosProvider.this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).add(0, -1, 0).offset(HighwayBuilder.this.dir).offset(HighwayBuilder.this.leftDir, HighwayBuilder.this.getWidthLeft());
                    }
                    return DiagonalBlockPosProvider.this.pos2;
                }

                private void initPos() {
                    if (this.i == 0) {
                        DiagonalBlockPosProvider.this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).add(0, -1, 0).offset(HighwayBuilder.this.dir.rotateLeft()).offset(HighwayBuilder.this.leftDir, HighwayBuilder.this.getWidthLeft() - 1);
                    } else {
                        DiagonalBlockPosProvider.this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).add(0, -1, 0).offset(HighwayBuilder.this.dir).offset(HighwayBuilder.this.leftDir, HighwayBuilder.this.getWidthLeft());
                    }
                }

                @Override
                public void save() {
                    this.pi = this.i;
                    this.pw = this.w;
                    this.w = 0;
                    this.i = 0;
                    this.initPos();
                }

                @Override
                public void restore() {
                    this.i = this.pi;
                    this.w = this.pw;
                    this.initPos();
                }
            };
        }

        @Override
        public MBPIterator getRailings(boolean mine) {
            final boolean mineAll = mine && HighwayBuilder.this.mineAboveRailings.get() != false;
            this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).offset(HighwayBuilder.this.dir.rotateLeft()).offset(HighwayBuilder.this.leftDir, HighwayBuilder.this.getWidthLeft());
            return new MBPIterator(){
                private int i;
                private int y;
                private int pi;
                private int py;

                @Override
                public boolean hasNext() {
                    return this.i < 2 && this.y < (mineAll ? HighwayBuilder.this.height.get() : 1);
                }

                @Override
                public MBlockPos next() {
                    DiagonalBlockPosProvider.this.pos2.set(DiagonalBlockPosProvider.this.pos).add(0, this.y++, 0);
                    if (this.y >= (mineAll ? HighwayBuilder.this.height.get() : 1)) {
                        this.y = 0;
                        ++this.i;
                        DiagonalBlockPosProvider.this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).offset(HighwayBuilder.this.dir.rotateRight()).offset(HighwayBuilder.this.rightDir, HighwayBuilder.this.getWidthRight());
                    }
                    return DiagonalBlockPosProvider.this.pos2;
                }

                private void initPos() {
                    if (this.i == 0) {
                        DiagonalBlockPosProvider.this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).offset(HighwayBuilder.this.dir.rotateLeft()).offset(HighwayBuilder.this.leftDir, HighwayBuilder.this.getWidthLeft());
                    } else {
                        DiagonalBlockPosProvider.this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).offset(HighwayBuilder.this.dir.rotateRight()).offset(HighwayBuilder.this.rightDir, HighwayBuilder.this.getWidthRight());
                    }
                }

                @Override
                public void save() {
                    this.pi = this.i;
                    this.py = this.y;
                    this.y = 0;
                    this.i = 0;
                    this.initPos();
                }

                @Override
                public void restore() {
                    this.i = this.pi;
                    this.y = this.py;
                    this.initPos();
                }
            };
        }

        @Override
        public MBPIterator getLiquids() {
            final boolean m = HighwayBuilder.this.railings.get() != false && HighwayBuilder.this.mineAboveRailings.get() != false;
            this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).offset(HighwayBuilder.this.dir).offset(HighwayBuilder.this.dir.rotateLeft()).offset(HighwayBuilder.this.leftDir, HighwayBuilder.this.getWidthLeft());
            return new MBPIterator(){
                private int i;
                private int w;
                private int y;
                private int pi;
                private int pw;
                private int py;

                private int getWidth() {
                    return HighwayBuilder.this.width.get() + (this.i == 0 ? 1 : 0) + (m && this.i == 1 ? 2 : 0);
                }

                @Override
                public boolean hasNext() {
                    if (m && this.i == 1 && this.y == HighwayBuilder.this.height.get() && this.w == this.getWidth() - 1) {
                        return false;
                    }
                    return this.i < 2 && this.w < this.getWidth() && this.y < HighwayBuilder.this.height.get() + 1;
                }

                private void updateW() {
                    ++this.w;
                    if (this.w >= this.getWidth()) {
                        this.w = 0;
                        ++this.i;
                        DiagonalBlockPosProvider.this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).offset(HighwayBuilder.this.dir, 2).offset(HighwayBuilder.this.leftDir, HighwayBuilder.this.getWidthLeft() + (m ? 1 : 0));
                    }
                }

                @Override
                public MBlockPos next() {
                    if (this.i == (m ? 1 : 0) && this.y == HighwayBuilder.this.height.get() && (this.w == 0 || this.w == this.getWidth() - 1)) {
                        this.y = 0;
                        this.updateW();
                    }
                    DiagonalBlockPosProvider.this.pos2.set(DiagonalBlockPosProvider.this.pos).offset(HighwayBuilder.this.rightDir, this.w).add(0, this.y++, 0);
                    if (this.y >= HighwayBuilder.this.height.get() + 1) {
                        this.y = 0;
                        this.updateW();
                    }
                    return DiagonalBlockPosProvider.this.pos2;
                }

                private void initPos() {
                    if (this.i == 0) {
                        DiagonalBlockPosProvider.this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).offset(HighwayBuilder.this.dir).offset(HighwayBuilder.this.dir.rotateLeft()).offset(HighwayBuilder.this.leftDir, HighwayBuilder.this.getWidthLeft());
                    } else {
                        DiagonalBlockPosProvider.this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).offset(HighwayBuilder.this.dir, 2).offset(HighwayBuilder.this.leftDir, HighwayBuilder.this.getWidthLeft() + (m ? 1 : 0));
                    }
                }

                @Override
                public void save() {
                    this.pi = this.i;
                    this.pw = this.w;
                    this.py = this.y;
                    this.y = 0;
                    this.w = 0;
                    this.i = 0;
                    this.initPos();
                }

                @Override
                public void restore() {
                    this.i = this.pi;
                    this.w = this.pw;
                    this.y = this.py;
                    this.initPos();
                }
            };
        }

        @Override
        public MBPIterator getEChestBlockade(final boolean mine) {
            return new MBPIterator(){
                private int i;
                private int y;
                private int pi;
                private int py;
                {
                    this.i = mine ? -1 : 0;
                }

                private MBlockPos get(int i) {
                    HorizontalDirection dir2 = HighwayBuilder.this.dir.rotateLeft().rotateLeftSkipOne();
                    DiagonalBlockPosProvider.this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).offset(dir2);
                    return switch (i) {
                        case -1 -> DiagonalBlockPosProvider.this.pos;
                        default -> DiagonalBlockPosProvider.this.pos.offset(dir2);
                        case 1 -> DiagonalBlockPosProvider.this.pos.offset(dir2.rotateLeftSkipOne());
                        case 2 -> DiagonalBlockPosProvider.this.pos.offset(dir2.rotateLeftSkipOne().opposite());
                    };
                }

                @Override
                public boolean hasNext() {
                    return this.i < 3 && this.y < 2;
                }

                @Override
                public MBlockPos next() {
                    MBlockPos pos = this.get(this.i).add(0, this.y, 0);
                    ++this.y;
                    if (this.y > 1) {
                        this.y = 0;
                        ++this.i;
                    }
                    return pos;
                }

                @Override
                public void save() {
                    this.pi = this.i;
                    this.py = this.y;
                    this.y = 0;
                    this.i = 0;
                }

                @Override
                public void restore() {
                    this.i = this.pi;
                    this.y = this.py;
                }
            };
        }
    }

    private class StraightBlockPosProvider
    implements IBlockPosProvider {
        private final MBlockPos pos = new MBlockPos();
        private final MBlockPos pos2 = new MBlockPos();

        private StraightBlockPosProvider() {
        }

        @Override
        public MBPIterator getFront() {
            this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).offset(HighwayBuilder.this.dir).offset(HighwayBuilder.this.leftDir, HighwayBuilder.this.getWidthLeft());
            return new MBPIterator(){
                private int w;
                private int y;
                private int pw;
                private int py;

                @Override
                public boolean hasNext() {
                    return this.w < HighwayBuilder.this.width.get() && this.y < HighwayBuilder.this.height.get();
                }

                @Override
                public MBlockPos next() {
                    StraightBlockPosProvider.this.pos2.set(StraightBlockPosProvider.this.pos).offset(HighwayBuilder.this.rightDir, this.w).add(0, this.y, 0);
                    ++this.w;
                    if (this.w >= HighwayBuilder.this.width.get()) {
                        this.w = 0;
                        ++this.y;
                    }
                    return StraightBlockPosProvider.this.pos2;
                }

                @Override
                public void save() {
                    this.pw = this.w;
                    this.py = this.y;
                    this.y = 0;
                    this.w = 0;
                }

                @Override
                public void restore() {
                    this.w = this.pw;
                    this.y = this.py;
                }
            };
        }

        @Override
        public MBPIterator getFloor() {
            this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).offset(HighwayBuilder.this.dir).offset(HighwayBuilder.this.leftDir, HighwayBuilder.this.getWidthLeft()).add(0, -1, 0);
            return new MBPIterator(){
                private int w;
                private int pw;

                @Override
                public boolean hasNext() {
                    return this.w < HighwayBuilder.this.width.get();
                }

                @Override
                public MBlockPos next() {
                    return StraightBlockPosProvider.this.pos2.set(StraightBlockPosProvider.this.pos).offset(HighwayBuilder.this.rightDir, this.w++);
                }

                @Override
                public void save() {
                    this.pw = this.w;
                    this.w = 0;
                }

                @Override
                public void restore() {
                    this.w = this.pw;
                }
            };
        }

        @Override
        public MBPIterator getRailings(boolean mine) {
            final boolean mineAll = mine && HighwayBuilder.this.mineAboveRailings.get() != false;
            this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).offset(HighwayBuilder.this.dir);
            return new MBPIterator(){
                private int i;
                private int y;
                private int pi;
                private int py;

                @Override
                public boolean hasNext() {
                    return this.i < 2 && this.y < (mineAll ? HighwayBuilder.this.height.get() : 1);
                }

                @Override
                public MBlockPos next() {
                    if (this.i == 0) {
                        StraightBlockPosProvider.this.pos2.set(StraightBlockPosProvider.this.pos).offset(HighwayBuilder.this.leftDir, HighwayBuilder.this.getWidthLeft() + 1).add(0, this.y, 0);
                    } else {
                        StraightBlockPosProvider.this.pos2.set(StraightBlockPosProvider.this.pos).offset(HighwayBuilder.this.rightDir, HighwayBuilder.this.getWidthRight() + 1).add(0, this.y, 0);
                    }
                    ++this.y;
                    if (this.y >= (mineAll ? HighwayBuilder.this.height.get() : 1)) {
                        this.y = 0;
                        ++this.i;
                    }
                    return StraightBlockPosProvider.this.pos2;
                }

                @Override
                public void save() {
                    this.pi = this.i;
                    this.py = this.y;
                    this.y = 0;
                    this.i = 0;
                }

                @Override
                public void restore() {
                    this.i = this.pi;
                    this.y = this.py;
                }
            };
        }

        @Override
        public MBPIterator getLiquids() {
            this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).offset(HighwayBuilder.this.dir, 2).offset(HighwayBuilder.this.leftDir, HighwayBuilder.this.getWidthLeft() + (HighwayBuilder.this.railings.get() != false && HighwayBuilder.this.mineAboveRailings.get() != false ? 2 : 1));
            return new MBPIterator(){
                private int w;
                private int y;
                private int pw;
                private int py;

                private int getWidth() {
                    return HighwayBuilder.this.width.get() + (HighwayBuilder.this.railings.get() != false && HighwayBuilder.this.mineAboveRailings.get() != false ? 2 : 0);
                }

                @Override
                public boolean hasNext() {
                    return this.w < this.getWidth() + 2 && this.y < HighwayBuilder.this.height.get() + 1;
                }

                @Override
                public MBlockPos next() {
                    StraightBlockPosProvider.this.pos2.set(StraightBlockPosProvider.this.pos).offset(HighwayBuilder.this.rightDir, this.w).add(0, this.y, 0);
                    ++this.w;
                    if (this.w >= this.getWidth() + 2) {
                        this.w = 0;
                        ++this.y;
                    }
                    return StraightBlockPosProvider.this.pos2;
                }

                @Override
                public void save() {
                    this.pw = this.w;
                    this.py = this.y;
                    this.y = 0;
                    this.w = 0;
                }

                @Override
                public void restore() {
                    this.w = this.pw;
                    this.y = this.py;
                }
            };
        }

        @Override
        public MBPIterator getEChestBlockade(final boolean mine) {
            return new MBPIterator(){
                private int i;
                private int y;
                private int pi;
                private int py;
                {
                    this.i = mine ? -1 : 0;
                }

                private MBlockPos get(int i) {
                    StraightBlockPosProvider.this.pos.set((class_1297)((HighwayBuilder)HighwayBuilder.this).mc.field_1724).offset(HighwayBuilder.this.dir.opposite());
                    return switch (i) {
                        case -1 -> StraightBlockPosProvider.this.pos;
                        default -> StraightBlockPosProvider.this.pos.offset(HighwayBuilder.this.dir.opposite());
                        case 1 -> StraightBlockPosProvider.this.pos.offset(HighwayBuilder.this.leftDir);
                        case 2 -> StraightBlockPosProvider.this.pos.offset(HighwayBuilder.this.rightDir);
                    };
                }

                @Override
                public boolean hasNext() {
                    return this.i < 3 && this.y < 2;
                }

                @Override
                public MBlockPos next() {
                    if (HighwayBuilder.this.width.get() == 1 && HighwayBuilder.this.railings.get().booleanValue() && this.i > 0 && this.y == 0) {
                        ++this.y;
                    }
                    MBlockPos pos = this.get(this.i).add(0, this.y, 0);
                    ++this.y;
                    if (this.y > 1) {
                        this.y = 0;
                        ++this.i;
                    }
                    return pos;
                }

                @Override
                public void save() {
                    this.pi = this.i;
                    this.py = this.y;
                    this.y = 0;
                    this.i = 0;
                }

                @Override
                public void restore() {
                    this.i = this.pi;
                    this.y = this.py;
                }
            };
        }
    }

    private static interface IBlockPosProvider {
        public MBPIterator getFront();

        public MBPIterator getFloor();

        public MBPIterator getRailings(boolean var1);

        public MBPIterator getLiquids();

        public MBPIterator getEChestBlockade(boolean var1);
    }

    private static interface MBPIterator
    extends Iterator<MBlockPos>,
    Iterable<MBlockPos> {
        public void save();

        public void restore();

        @Override
        @NotNull
        default public Iterator<MBlockPos> iterator() {
            return this;
        }
    }

    private static class MBPIteratorFilter
    implements MBPIterator {
        private final MBPIterator it;
        private final Predicate<MBlockPos> predicate;
        private MBlockPos pos;
        private boolean isOld = true;
        private boolean pisOld = true;

        public MBPIteratorFilter(MBPIterator it, Predicate<MBlockPos> predicate) {
            this.it = it;
            this.predicate = predicate;
        }

        @Override
        public void save() {
            this.it.save();
            this.pisOld = this.isOld;
            this.isOld = true;
        }

        @Override
        public void restore() {
            this.it.restore();
            this.isOld = this.pisOld;
        }

        @Override
        public boolean hasNext() {
            if (this.isOld) {
                this.isOld = false;
                this.pos = null;
                while (this.it.hasNext()) {
                    this.pos = (MBlockPos)this.it.next();
                    if (this.predicate.test(this.pos)) {
                        return true;
                    }
                    this.pos = null;
                }
            }
            return this.pos != null && this.predicate.test(this.pos);
        }

        @Override
        public MBlockPos next() {
            this.isOld = true;
            return this.pos;
        }
    }
}

