/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.world;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import meteordevelopment.meteorclient.events.entity.player.BlockBreakingCooldownEvent;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BlockListSetting;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.misc.Pool;
import meteordevelopment.meteorclient.utils.render.RenderUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.meteorclient.utils.world.BlockIterator;
import meteordevelopment.meteorclient.utils.world.BlockUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2846;

public class Nuker
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgWhitelist;
    private final SettingGroup sgRender;
    private final Setting<Shape> shape;
    private final Setting<Mode> mode;
    private final Setting<Double> range;
    private final Setting<Integer> range_up;
    private final Setting<Integer> range_down;
    private final Setting<Integer> range_left;
    private final Setting<Integer> range_right;
    private final Setting<Integer> range_forward;
    private final Setting<Integer> range_back;
    private final Setting<Integer> delay;
    private final Setting<Integer> maxBlocksPerTick;
    private final Setting<SortMode> sortMode;
    private final Setting<Boolean> swingHand;
    private final Setting<Boolean> packetMine;
    private final Setting<ListMode> listMode;
    private final Setting<List<class_2248>> blacklist;
    private final Setting<List<class_2248>> whitelist;
    private final Setting<Boolean> enableRenderBounding;
    private final Setting<ShapeMode> shapeModeBox;
    private final Setting<SettingColor> sideColorBox;
    private final Setting<SettingColor> lineColorBox;
    private final Setting<Boolean> enableRenderBreaking;
    private final Setting<ShapeMode> shapeModeBreak;
    private final Setting<SettingColor> sideColor;
    private final Setting<SettingColor> lineColor;
    private final Pool<class_2338.class_2339> blockPosPool;
    private final List<class_2338.class_2339> blocks;
    private boolean firstBlock;
    private final class_2338.class_2339 lastBlockPos;
    private int timer;
    private int noBlockTimer;
    private class_2338.class_2339 pos1;
    private class_2338.class_2339 pos2;
    private class_238 box;
    int maxh;
    int maxv;

    public Nuker() {
        super(Categories.World, "nuker", "Breaks blocks around you.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgWhitelist = this.settings.createGroup("Whitelist");
        this.sgRender = this.settings.createGroup("Render");
        this.shape = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape")).description("The shape of nuking algorithm.")).defaultValue(Shape.Sphere)).build());
        this.mode = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("mode")).description("The way the blocks are broken.")).defaultValue(Mode.Flatten)).build());
        this.range = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("range")).description("The break range.")).defaultValue(4.0).min(0.0).visible(() -> this.shape.get() != Shape.Cube)).build());
        this.range_up = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("up")).description("The break range.")).defaultValue(1)).min(0).visible(() -> this.shape.get() == Shape.Cube)).build());
        this.range_down = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("down")).description("The break range.")).defaultValue(1)).min(0).visible(() -> this.shape.get() == Shape.Cube)).build());
        this.range_left = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("left")).description("The break range.")).defaultValue(1)).min(0).visible(() -> this.shape.get() == Shape.Cube)).build());
        this.range_right = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("right")).description("The break range.")).defaultValue(1)).min(0).visible(() -> this.shape.get() == Shape.Cube)).build());
        this.range_forward = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("forward")).description("The break range.")).defaultValue(1)).min(0).visible(() -> this.shape.get() == Shape.Cube)).build());
        this.range_back = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("back")).description("The break range.")).defaultValue(1)).min(0).visible(() -> this.shape.get() == Shape.Cube)).build());
        this.delay = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("delay")).description("Delay in ticks between breaking blocks.")).defaultValue(0)).build());
        this.maxBlocksPerTick = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("max-blocks-per-tick")).description("Maximum blocks to try to break per tick. Useful when insta mining.")).defaultValue(1)).min(1).sliderRange(1, 6).build());
        this.sortMode = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("sort-mode")).description("The blocks you want to mine first.")).defaultValue(SortMode.Closest)).build());
        this.swingHand = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("swing-hand")).description("Swing hand client side.")).defaultValue(true)).build());
        this.packetMine = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("packet-mine")).description("Attempt to instamine everything at once.")).defaultValue(false)).build());
        this.listMode = this.sgWhitelist.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("list-mode")).description("Selection mode.")).defaultValue(ListMode.Whitelist)).build());
        this.blacklist = this.sgWhitelist.add(((BlockListSetting.Builder)((BlockListSetting.Builder)((BlockListSetting.Builder)new BlockListSetting.Builder().name("blacklist")).description("The blocks you don't want to mine.")).visible(() -> this.listMode.get() == ListMode.Blacklist)).build());
        this.whitelist = this.sgWhitelist.add(((BlockListSetting.Builder)((BlockListSetting.Builder)((BlockListSetting.Builder)new BlockListSetting.Builder().name("whitelist")).description("The blocks you want to mine.")).visible(() -> this.listMode.get() == ListMode.Whitelist)).build());
        this.enableRenderBounding = this.sgRender.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("bounding-box")).description("Enable rendering bounding box for Cube and Uniform Cube.")).defaultValue(true)).build());
        this.shapeModeBox = this.sgRender.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("nuke-box-mode")).description("How the shape for the bounding box is rendered.")).defaultValue(ShapeMode.Both)).build());
        this.sideColorBox = this.sgRender.add(((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("side-color")).description("The side color of the bounding box.")).defaultValue(new SettingColor(16, 106, 144, 100)).build());
        this.lineColorBox = this.sgRender.add(((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("line-color")).description("The line color of the bounding box.")).defaultValue(new SettingColor(16, 106, 144, 255)).build());
        this.enableRenderBreaking = this.sgRender.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("broken-blocks")).description("Enable rendering bounding box for Cube and Uniform Cube.")).defaultValue(true)).build());
        this.shapeModeBreak = this.sgRender.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("nuke-block-mode")).description("How the shapes for broken blocks are rendered.")).defaultValue(ShapeMode.Both)).visible(this.enableRenderBreaking::get)).build());
        this.sideColor = this.sgRender.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("side-color")).description("The side color of the target block rendering.")).defaultValue(new SettingColor(255, 0, 0, 80)).visible(this.enableRenderBreaking::get)).build());
        this.lineColor = this.sgRender.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("line-color")).description("The line color of the target block rendering.")).defaultValue(new SettingColor(255, 0, 0, 255)).visible(this.enableRenderBreaking::get)).build());
        this.blockPosPool = new Pool<class_2338.class_2339>(class_2338.class_2339::new);
        this.blocks = new ArrayList<class_2338.class_2339>();
        this.lastBlockPos = new class_2338.class_2339();
        this.pos1 = new class_2338.class_2339();
        this.pos2 = new class_2338.class_2339();
        this.maxh = 0;
        this.maxv = 0;
    }

    @Override
    public void onActivate() {
        this.firstBlock = true;
        this.timer = 0;
        this.noBlockTimer = 0;
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (this.enableRenderBounding.get().booleanValue() && this.shape.get() != Shape.Sphere && this.mode.get() != Mode.Smash) {
            this.box = new class_238((class_2338)this.pos1, (class_2338)this.pos2);
            event.renderer.box(this.box, (Color)this.sideColorBox.get(), (Color)this.lineColorBox.get(), this.shapeModeBox.get(), 0);
        }
    }

    @EventHandler
    private void onTickPre(TickEvent.Pre event) {
        if (this.timer > 0) {
            --this.timer;
            return;
        }
        double pX = this.mc.field_1724.method_23317();
        double pY = this.mc.field_1724.method_23318();
        double pZ = this.mc.field_1724.method_23321();
        double rangeSq = Math.pow(this.range.get(), 2.0);
        if (this.shape.get() == Shape.UniformCube) {
            this.range.set(Double.valueOf(Math.round(this.range.get())));
        }
        double pX_ = pX;
        double pZ_ = pZ;
        int r = (int)Math.round(this.range.get());
        if (this.shape.get() == Shape.UniformCube) {
            this.pos1.method_10102((pX_ += 1.0) - (double)r, pY - (double)r + 1.0, pZ - (double)r + 1.0);
            this.pos2.method_10102(pX_ + (double)r - 1.0, pY + (double)r, pZ + (double)r);
        } else {
            int direction = Math.round(this.mc.field_1724.method_5802().field_1342 % 360.0f / 90.0f);
            direction = Math.floorMod(direction, 4);
            this.pos1.method_10102(pX_ - (double)this.range_forward.get().intValue(), Math.ceil(pY) - (double)this.range_down.get().intValue(), pZ_ - (double)this.range_right.get().intValue());
            this.pos2.method_10102(pX_ + (double)this.range_back.get().intValue() + 1.0, Math.ceil(pY + (double)this.range_up.get().intValue() + 1.0), pZ_ + (double)this.range_left.get().intValue() + 1.0);
            if (direction == 2) {
                this.pos1.method_10102((pX_ += 1.0) - (double)(this.range_left.get() + 1), Math.ceil(pY) - (double)this.range_down.get().intValue(), (pZ_ += 1.0) - (double)(this.range_forward.get() + 1));
                this.pos2.method_10102(pX_ + (double)this.range_right.get().intValue(), Math.ceil(pY + (double)this.range_up.get().intValue() + 1.0), pZ_ + (double)this.range_back.get().intValue());
            } else if (direction == 3) {
                this.pos1.method_10102((pX_ += 1.0) - (double)(this.range_back.get() + 1), Math.ceil(pY) - (double)this.range_down.get().intValue(), pZ_ - (double)this.range_left.get().intValue());
                this.pos2.method_10102(pX_ + (double)this.range_forward.get().intValue(), Math.ceil(pY + (double)this.range_up.get().intValue() + 1.0), pZ_ + (double)this.range_right.get().intValue() + 1.0);
            } else if (direction == 0) {
                this.pos1.method_10102((pX_ += 1.0) - (double)(this.range_right.get() + 1), Math.ceil(pY) - (double)this.range_down.get().intValue(), (pZ_ += 1.0) - (double)(this.range_back.get() + 1));
                this.pos2.method_10102(pX_ + (double)this.range_left.get().intValue(), Math.ceil(pY + (double)this.range_up.get().intValue() + 1.0), pZ_ + (double)this.range_forward.get().intValue());
            }
            this.maxh = 1 + Math.max(Math.max(Math.max(this.range_back.get(), this.range_right.get()), this.range_forward.get()), this.range_left.get());
            this.maxv = 1 + Math.max(this.range_up.get(), this.range_down.get());
        }
        if (this.mode.get() == Mode.Flatten) {
            this.pos1.method_33098((int)Math.floor(pY));
        }
        this.box = new class_238((class_2338)this.pos1, (class_2338)this.pos2);
        BlockIterator.register(Math.max((int)Math.ceil(this.range.get() + 1.0), this.maxh), Math.max((int)Math.ceil(this.range.get()), this.maxv), (blockPos, blockState) -> {
            boolean toofarCube;
            boolean toofarSphere = Utils.squaredDistance(pX, pY, pZ, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5) > rangeSq;
            boolean toofarUniformCube = Nuker.maxDist(Math.floor(pX), Math.floor(pY), Math.floor(pZ), blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()) >= this.range.get();
            boolean bl = toofarCube = !this.box.method_1006(class_243.method_24953((class_2382)blockPos));
            if (!BlockUtils.canBreak(blockPos, blockState) || toofarSphere && this.shape.get() == Shape.Sphere || toofarUniformCube && this.shape.get() == Shape.UniformCube || toofarCube && this.shape.get() == Shape.Cube) {
                return;
            }
            if (this.mode.get() == Mode.Flatten && (double)blockPos.method_10264() < Math.floor(this.mc.field_1724.method_23318())) {
                return;
            }
            if (this.mode.get() == Mode.Smash && blockState.method_26214((class_1922)this.mc.field_1687, blockPos) != 0.0f) {
                return;
            }
            if (this.listMode.get() == ListMode.Whitelist && !this.whitelist.get().contains(blockState.method_26204())) {
                return;
            }
            if (this.listMode.get() == ListMode.Blacklist && this.blacklist.get().contains(blockState.method_26204())) {
                return;
            }
            this.blocks.add(this.blockPosPool.get().method_10101((class_2382)blockPos));
        });
        BlockIterator.after(() -> {
            if (this.sortMode.get() == SortMode.TopDown) {
                this.blocks.sort(Comparator.comparingDouble(value -> -1 * value.method_10264()));
            } else if (this.sortMode.get() != SortMode.None) {
                this.blocks.sort(Comparator.comparingDouble(value -> Utils.squaredDistance(pX, pY, pZ, (double)value.method_10263() + 0.5, (double)value.method_10264() + 0.5, (double)value.method_10260() + 0.5) * (double)(this.sortMode.get() == SortMode.Closest ? 1 : -1)));
            }
            if (this.blocks.isEmpty()) {
                if (this.noBlockTimer++ >= this.delay.get()) {
                    this.firstBlock = true;
                }
                return;
            }
            this.noBlockTimer = 0;
            if (!this.firstBlock && !this.lastBlockPos.equals((Object)this.blocks.get(0))) {
                this.timer = this.delay.get();
                this.firstBlock = false;
                this.lastBlockPos.method_10101((class_2382)this.blocks.get(0));
                if (this.timer > 0) {
                    return;
                }
            }
            int count = 0;
            for (class_2338 class_23382 : this.blocks) {
                if (count >= this.maxBlocksPerTick.get()) break;
                boolean canInstaMine = BlockUtils.canInstaBreak(class_23382);
                if (this.packetMine.get().booleanValue()) {
                    this.mc.method_1562().method_2883((class_2596)new class_2846(class_2846.class_2847.field_12968, class_23382, class_2350.field_11036));
                    this.mc.field_1724.method_6104(class_1268.field_5808);
                    this.mc.method_1562().method_2883((class_2596)new class_2846(class_2846.class_2847.field_12973, class_23382, class_2350.field_11036));
                } else {
                    BlockUtils.breakBlock(class_23382, this.swingHand.get());
                }
                if (this.enableRenderBreaking.get().booleanValue()) {
                    RenderUtils.renderTickingBlock(class_23382.method_10062(), this.sideColor.get(), this.lineColor.get(), this.shapeModeBreak.get(), 0, 8, true, false);
                }
                this.lastBlockPos.method_10101((class_2382)class_23382);
                ++count;
                if (canInstaMine || this.packetMine.get().booleanValue()) continue;
                break;
            }
            this.firstBlock = false;
            for (class_2338.class_2339 class_23392 : this.blocks) {
                this.blockPosPool.free(class_23392);
            }
            this.blocks.clear();
        });
    }

    @EventHandler(priority=200)
    private void onBlockBreakingCooldown(BlockBreakingCooldownEvent event) {
        event.cooldown = 0;
    }

    public static double maxDist(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dX = Math.ceil(Math.abs(x2 - x1));
        double dY = Math.ceil(Math.abs(y2 - y1));
        double dZ = Math.ceil(Math.abs(z2 - z1));
        return Math.max(Math.max(dX, dY), dZ);
    }

    public static enum Shape {
        Cube,
        UniformCube,
        Sphere;

    }

    public static enum Mode {
        All,
        Flatten,
        Smash;

    }

    public static enum SortMode {
        None,
        Closest,
        Furthest,
        TopDown;

    }

    public static enum ListMode {
        Whitelist,
        Blacklist;

    }
}

