/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.waypoints;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.game.GameJoinedEvent;
import meteordevelopment.meteorclient.events.game.GameLeftEvent;
import meteordevelopment.meteorclient.events.render.Render2DEvent;
import meteordevelopment.meteorclient.renderer.text.TextRenderer;
import meteordevelopment.meteorclient.systems.System;
import meteordevelopment.meteorclient.systems.Systems;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.render.WaypointsModule;
import meteordevelopment.meteorclient.systems.waypoints.Waypoint;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.files.StreamUtils;
import meteordevelopment.meteorclient.utils.misc.NbtUtils;
import meteordevelopment.meteorclient.utils.player.PlayerUtils;
import meteordevelopment.meteorclient.utils.render.NametagUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.world.Dimension;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class Waypoints
extends System<Waypoints>
implements Iterable<Waypoint> {
    public static final String[] BUILTIN_ICONS = new String[]{"square", "circle", "triangle", "star", "diamond", "skull"};
    private static final Color TEXT = new Color(255, 255, 255);
    public final Map<String, class_1044> icons = new ConcurrentHashMap<String, class_1044>();
    public Map<String, Waypoint> waypoints = new ConcurrentHashMap<String, Waypoint>();

    public Waypoints() {
        super(null);
    }

    public static Waypoints get() {
        return Systems.get(Waypoints.class);
    }

    @Override
    public void init() {
        File iconsFolder = new File(new File(MeteorClient.FOLDER, "waypoints"), "icons");
        iconsFolder.mkdirs();
        for (String builtinIcon : BUILTIN_ICONS) {
            File iconFile = new File(iconsFolder, builtinIcon + ".png");
            if (iconFile.exists()) continue;
            this.copyIcon(iconFile);
        }
        File[] files = iconsFolder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.getName().endsWith(".png")) continue;
            try {
                String name = file.getName().replace(".png", "");
                class_1043 texture = new class_1043(class_1011.method_4309((InputStream)new FileInputStream(file)));
                this.icons.put(name, (class_1044)texture);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean add(Waypoint waypoint) {
        Waypoint added = this.waypoints.put(waypoint.name.get().toLowerCase(Locale.ROOT), waypoint);
        if (added != null) {
            this.save();
        }
        return added != null;
    }

    public boolean remove(Waypoint waypoint) {
        Waypoint removed = this.waypoints.remove(waypoint.name.get().toLowerCase(Locale.ROOT));
        if (removed != null) {
            this.save();
        }
        return removed != null;
    }

    public Waypoint get(String name) {
        return this.waypoints.get(name.toLowerCase(Locale.ROOT));
    }

    @EventHandler
    private void onGameJoined(GameJoinedEvent event) {
        this.load();
    }

    @EventHandler(priority=-200)
    private void onGameDisconnected(GameLeftEvent event) {
        this.waypoints.clear();
    }

    public static boolean checkDimension(Waypoint waypoint) {
        Dimension waypointDim;
        Dimension playerDim = PlayerUtils.getDimension();
        if (playerDim == (waypointDim = waypoint.dimension.get())) {
            return true;
        }
        if (!waypoint.opposite.get().booleanValue()) {
            return false;
        }
        boolean playerOpp = playerDim == Dimension.Overworld || playerDim == Dimension.Nether;
        boolean waypointOpp = waypointDim == Dimension.Overworld || waypointDim == Dimension.Nether;
        return playerOpp && waypointOpp;
    }

    @EventHandler
    private void onRender2D(Render2DEvent event) {
        WaypointsModule module = Modules.get().get(WaypointsModule.class);
        if (!module.isActive()) {
            return;
        }
        TextRenderer text = TextRenderer.get();
        Vector3d center = new Vector3d((double)MeteorClient.mc.method_22683().method_4489() / 2.0, (double)MeteorClient.mc.method_22683().method_4506() / 2.0, 0.0);
        int textRenderDist = module.textRenderDistance.get();
        for (Waypoint waypoint : this) {
            if (!waypoint.visible.get().booleanValue() || !Waypoints.checkDimension(waypoint)) continue;
            class_2338 blockPos = waypoint.getPos();
            Vector3d pos = new Vector3d((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264(), (double)blockPos.method_10260() + 0.5);
            double dist = PlayerUtils.distanceToCamera(pos.x, pos.y, pos.z);
            if (dist > (double)waypoint.maxVisible.get().intValue() || !NametagUtils.to2D(pos, 1.0)) continue;
            double distToCenter = pos.distance((Vector3dc)center);
            double a = 1.0;
            if (dist < 20.0 && (a = (dist - 10.0) / 10.0) < 0.01) continue;
            NametagUtils.scale = waypoint.scale.get() - 0.2;
            NametagUtils.begin(pos);
            waypoint.renderIcon(-16.0, -16.0, a, 32.0);
            if (distToCenter <= (double)textRenderDist) {
                int preTextA = Waypoints.TEXT.a;
                Waypoints.TEXT.a = (int)((double)Waypoints.TEXT.a * a);
                text.begin();
                text.render(waypoint.name.get(), -text.getWidth(waypoint.name.get()) / 2.0, -16.0 - text.getHeight(), TEXT, true);
                String distText = String.format("%d blocks", (int)Math.round(dist));
                text.render(distText, -text.getWidth(distText) / 2.0, 16.0, TEXT, true);
                text.end();
                Waypoints.TEXT.a = preTextA;
            }
            NametagUtils.end();
        }
    }

    @Override
    public File getFile() {
        if (!Utils.canUpdate()) {
            return null;
        }
        return new File(new File(MeteorClient.FOLDER, "waypoints"), Utils.getFileWorldName() + ".nbt");
    }

    public boolean isEmpty() {
        return this.waypoints.isEmpty();
    }

    @Override
    public Iterator<Waypoint> iterator() {
        return this.waypoints.values().iterator();
    }

    public ListIterator<Waypoint> iteratorReverse() {
        return new ArrayList<Waypoint>(this.waypoints.values()).listIterator(this.waypoints.size());
    }

    private void copyIcon(File file) {
        StreamUtils.copy(Waypoints.class.getResourceAsStream("/assets/meteor-client/textures/icons/waypoints/" + file.getName()), file);
    }

    @Override
    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10566("waypoints", (class_2520)NbtUtils.listToTag(this.waypoints.values()));
        return tag;
    }

    @Override
    public Waypoints fromTag(class_2487 tag) {
        Map<String, Waypoint> fromNbt = NbtUtils.listFromTag(tag.method_10554("waypoints", 10), Waypoint::new).stream().collect(Collectors.toMap(o -> o.name.get().toLowerCase(Locale.ROOT), o -> o));
        this.waypoints = new ConcurrentHashMap<String, Waypoint>(fromNbt);
        return this;
    }
}

