/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.gui.tabs.TabScreen;
import meteordevelopment.meteorclient.mixin.ClientPlayNetworkHandlerAccessor;
import meteordevelopment.meteorclient.mixin.MinecraftClientAccessor;
import meteordevelopment.meteorclient.mixin.MinecraftServerAccessor;
import meteordevelopment.meteorclient.mixin.ReloadStateAccessor;
import meteordevelopment.meteorclient.mixin.ResourceReloadLoggerAccessor;
import meteordevelopment.meteorclient.mixininterface.IMinecraftClient;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.render.BetterTooltips;
import meteordevelopment.meteorclient.systems.modules.world.Timer;
import meteordevelopment.meteorclient.utils.PreInit;
import meteordevelopment.meteorclient.utils.player.EChestMemory;
import meteordevelopment.meteorclient.utils.render.PeekScreen;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.world.BlockEntityIterator;
import meteordevelopment.meteorclient.utils.world.ChunkIterator;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1747;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1767;
import net.minecraft.class_1771;
import net.minecraft.class_1772;
import net.minecraft.class_1776;
import net.minecraft.class_1779;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1803;
import net.minecraft.class_1823;
import net.minecraft.class_1828;
import net.minecraft.class_1835;
import net.minecraft.class_1887;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_500;
import net.minecraft.class_526;
import net.minecraft.class_6360;
import net.minecraft.class_7923;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Range;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.lwjgl.glfw.GLFW;

public class Utils {
    private static final Random random = new Random();
    public static boolean firstTimeTitleScreen = true;
    public static boolean isReleasingTrident;
    public static final Color WHITE;
    public static boolean rendering3D;
    public static double frameTime;
    public static class_437 screenToOpen;
    public static final Pattern FILE_NAME_INVALID_CHARS_PATTERN;

    @PreInit
    public static void init() {
        MeteorClient.EVENT_BUS.subscribe(Utils.class);
    }

    @EventHandler
    private static void onTick(TickEvent.Post event) {
        if (screenToOpen != null && MeteorClient.mc.field_1755 == null) {
            MeteorClient.mc.method_1507(screenToOpen);
            screenToOpen = null;
        }
    }

    public static class_243 getPlayerSpeed() {
        if (MeteorClient.mc.field_1724 == null) {
            return class_243.field_1353;
        }
        double tX = MeteorClient.mc.field_1724.method_23317() - MeteorClient.mc.field_1724.field_6014;
        double tY = MeteorClient.mc.field_1724.method_23318() - MeteorClient.mc.field_1724.field_6036;
        double tZ = MeteorClient.mc.field_1724.method_23321() - MeteorClient.mc.field_1724.field_5969;
        Timer timer = Modules.get().get(Timer.class);
        if (timer.isActive()) {
            tX *= timer.getMultiplier();
            tY *= timer.getMultiplier();
            tZ *= timer.getMultiplier();
        }
        return new class_243(tX *= 20.0, tY *= 20.0, tZ *= 20.0);
    }

    public static String getWorldTime() {
        if (MeteorClient.mc.field_1687 == null) {
            return "00:00";
        }
        int ticks = (int)(MeteorClient.mc.field_1687.method_8532() % 24000L);
        if ((ticks += 6000) > 24000) {
            ticks -= 24000;
        }
        return String.format("%02d:%02d", ticks / 1000, (int)((double)(ticks % 1000) / 1000.0 * 60.0));
    }

    public static Iterable<class_2791> chunks(boolean onlyWithLoadedNeighbours) {
        return () -> new ChunkIterator(onlyWithLoadedNeighbours);
    }

    public static Iterable<class_2791> chunks() {
        return Utils.chunks(false);
    }

    public static Iterable<class_2586> blockEntities() {
        return BlockEntityIterator::new;
    }

    public static void getEnchantments(class_1799 itemStack, Object2IntMap<class_1887> enchantments) {
        enchantments.clear();
        if (!itemStack.method_7960()) {
            class_2499 listTag = itemStack.method_7909() == class_1802.field_8598 ? class_1772.method_7806((class_1799)itemStack) : itemStack.method_7921();
            for (int i = 0; i < listTag.size(); ++i) {
                class_2487 tag = listTag.method_10602(i);
                class_7923.field_41176.method_17966(class_2960.method_12829((String)tag.method_10558("id"))).ifPresent(enchantment -> enchantments.put(enchantment, tag.method_10550("lvl")));
            }
        }
    }

    public static boolean hasEnchantments(class_1799 itemStack, class_1887 ... enchantments) {
        if (itemStack.method_7960()) {
            return false;
        }
        Object2IntArrayMap itemEnchantments = new Object2IntArrayMap();
        Utils.getEnchantments(itemStack, (Object2IntMap<class_1887>)itemEnchantments);
        for (class_1887 enchantment : enchantments) {
            if (itemEnchantments.containsKey((Object)enchantment)) continue;
            return false;
        }
        return true;
    }

    public static int getRenderDistance() {
        return Math.max((Integer)MeteorClient.mc.field_1690.method_42503().method_41753(), ((ClientPlayNetworkHandlerAccessor)MeteorClient.mc.method_1562()).getChunkLoadDistance());
    }

    public static int getWindowWidth() {
        return MeteorClient.mc.method_22683().method_4489();
    }

    public static int getWindowHeight() {
        return MeteorClient.mc.method_22683().method_4506();
    }

    public static void unscaledProjection() {
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)MeteorClient.mc.method_22683().method_4489(), (float)MeteorClient.mc.method_22683().method_4506(), 0.0f, 1000.0f, 3000.0f));
        rendering3D = false;
    }

    public static void scaledProjection() {
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)((double)MeteorClient.mc.method_22683().method_4489() / MeteorClient.mc.method_22683().method_4495()), (float)((double)MeteorClient.mc.method_22683().method_4506() / MeteorClient.mc.method_22683().method_4495()), 0.0f, 1000.0f, 3000.0f));
        rendering3D = true;
    }

    public static class_243 vec3d(class_2338 pos) {
        return new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    public static boolean openContainer(class_1799 itemStack, class_1799[] contents, boolean pause) {
        if (Utils.hasItems(itemStack) || itemStack.method_7909() == class_1802.field_8466) {
            Utils.getItemsInContainerItem(itemStack, contents);
            if (pause) {
                screenToOpen = new PeekScreen(itemStack, contents);
            } else {
                MeteorClient.mc.method_1507((class_437)new PeekScreen(itemStack, contents));
            }
            return true;
        }
        return false;
    }

    public static void getItemsInContainerItem(class_1799 itemStack, class_1799[] items) {
        class_2487 nbt2;
        if (itemStack.method_7909() == class_1802.field_8466) {
            for (int i = 0; i < EChestMemory.ITEMS.size(); ++i) {
                items[i] = (class_1799)EChestMemory.ITEMS.get(i);
            }
            return;
        }
        Arrays.fill(items, class_1799.field_8037);
        class_2487 nbt = itemStack.method_7969();
        if (nbt != null && nbt.method_10545("BlockEntityTag") && (nbt2 = nbt.method_10562("BlockEntityTag")).method_10545("Items")) {
            class_2499 nbt3 = (class_2499)nbt2.method_10580("Items");
            for (int i = 0; i < nbt3.size(); ++i) {
                byte slot = nbt3.method_10602(i).method_10571("Slot");
                if (slot < 0 || slot >= items.length) continue;
                items[slot] = class_1799.method_7915((class_2487)nbt3.method_10602(i));
            }
        }
    }

    public static Color getShulkerColor(class_1799 shulkerItem) {
        class_1792 class_17922 = shulkerItem.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            class_2248 block = blockItem.method_7711();
            if (block == class_2246.field_10443) {
                return BetterTooltips.ECHEST_COLOR;
            }
            if (block instanceof class_2480) {
                class_2480 shulkerBlock = (class_2480)block;
                class_1767 dye = shulkerBlock.method_10528();
                if (dye == null) {
                    return WHITE;
                }
                float[] colors = dye.method_7787();
                return new Color(colors[0], colors[1], colors[2], 1.0f);
            }
        }
        return WHITE;
    }

    public static boolean hasItems(class_1799 itemStack) {
        class_2487 compoundTag = itemStack.method_7941("BlockEntityTag");
        return compoundTag != null && compoundTag.method_10573("Items", 9);
    }

    public static Object2IntMap<class_1291> createStatusEffectMap() {
        Object2IntArrayMap map = new Object2IntArrayMap(class_7923.field_41174.method_10235().size());
        class_7923.field_41174.forEach(arg_0 -> Utils.lambda$createStatusEffectMap$2((Object2IntMap)map, arg_0));
        return map;
    }

    public static String getEnchantSimpleName(class_1887 enchantment, int length) {
        return enchantment.method_8179(0).getString().substring(0, length);
    }

    public static boolean searchTextDefault(String text, String filter, boolean caseSensitive) {
        return Utils.searchInWords(text, filter) > 0 || Utils.searchLevenshteinDefault(text, filter, caseSensitive) < text.length() / 2;
    }

    public static int searchLevenshteinDefault(String text, String filter, boolean caseSensitive) {
        return Utils.levenshteinDistance(caseSensitive ? filter : filter.toLowerCase(Locale.ROOT), caseSensitive ? text : text.toLowerCase(Locale.ROOT), 1, 8, 8);
    }

    public static int searchInWords(String text, String filter) {
        String[] words;
        if (filter.isEmpty()) {
            return 1;
        }
        int wordsFound = 0;
        text = text.toLowerCase(Locale.ROOT);
        for (String word : words = filter.toLowerCase(Locale.ROOT).split(" ")) {
            if (!text.contains(word)) {
                return 0;
            }
            wordsFound += StringUtils.countMatches((CharSequence)text, (CharSequence)word);
        }
        return wordsFound;
    }

    public static int levenshteinDistance(String from, String to, int insCost, int subCost, int delCost) {
        int i;
        int textLength = from.length();
        int filterLength = to.length();
        if (textLength == 0) {
            return filterLength * insCost;
        }
        if (filterLength == 0) {
            return textLength * delCost;
        }
        int[][] d = new int[textLength + 1][filterLength + 1];
        for (i = 0; i <= textLength; ++i) {
            d[i][0] = i * delCost;
        }
        for (int j = 0; j <= filterLength; ++j) {
            d[0][j] = j * insCost;
        }
        for (i = 1; i <= textLength; ++i) {
            for (int j = 1; j <= filterLength; ++j) {
                int sCost = d[i - 1][j - 1] + (from.charAt(i - 1) == to.charAt(j - 1) ? 0 : subCost);
                int dCost = d[i - 1][j] + delCost;
                int iCost = d[i][j - 1] + insCost;
                d[i][j] = Math.min(Math.min(dCost, iCost), sCost);
            }
        }
        return d[textLength][filterLength];
    }

    public static double squaredDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dX = x2 - x1;
        double dY = y2 - y1;
        double dZ = z2 - z1;
        return dX * dX + dY * dY + dZ * dZ;
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dX = x2 - x1;
        double dY = y2 - y1;
        double dZ = z2 - z1;
        return Math.sqrt(dX * dX + dY * dY + dZ * dZ);
    }

    public static String getFileWorldName() {
        return FILE_NAME_INVALID_CHARS_PATTERN.matcher(Utils.getWorldName()).replaceAll("_");
    }

    public static String getWorldName() {
        if (MeteorClient.mc.method_1542()) {
            if (MeteorClient.mc.field_1687 == null) {
                return "";
            }
            File folder = ((MinecraftServerAccessor)MeteorClient.mc.method_1576()).getSession().method_27424(MeteorClient.mc.field_1687.method_27983()).toFile();
            if (folder.toPath().relativize(MeteorClient.mc.field_1697.toPath()).getNameCount() != 2) {
                folder = folder.getParentFile();
            }
            return folder.getName();
        }
        if (MeteorClient.mc.method_1558() != null) {
            return MeteorClient.mc.method_1589() ? "realms" : MeteorClient.mc.method_1558().field_3761;
        }
        return "";
    }

    public static String nameToTitle(String name) {
        return Arrays.stream(name.split("-")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public static String titleToName(String title) {
        return title.replace(" ", "-").toLowerCase(Locale.ROOT);
    }

    public static String getKeyName(int key) {
        switch (key) {
            case -1: {
                return "Unknown";
            }
            case 256: {
                return "Esc";
            }
            case 96: {
                return "Grave Accent";
            }
            case 161: {
                return "World 1";
            }
            case 162: {
                return "World 2";
            }
            case 283: {
                return "Print Screen";
            }
            case 284: {
                return "Pause";
            }
            case 260: {
                return "Insert";
            }
            case 261: {
                return "Delete";
            }
            case 268: {
                return "Home";
            }
            case 266: {
                return "Page Up";
            }
            case 267: {
                return "Page Down";
            }
            case 269: {
                return "End";
            }
            case 258: {
                return "Tab";
            }
            case 341: {
                return "Left Control";
            }
            case 345: {
                return "Right Control";
            }
            case 342: {
                return "Left Alt";
            }
            case 346: {
                return "Right Alt";
            }
            case 340: {
                return "Left Shift";
            }
            case 344: {
                return "Right Shift";
            }
            case 265: {
                return "Arrow Up";
            }
            case 264: {
                return "Arrow Down";
            }
            case 263: {
                return "Arrow Left";
            }
            case 262: {
                return "Arrow Right";
            }
            case 39: {
                return "Apostrophe";
            }
            case 259: {
                return "Backspace";
            }
            case 280: {
                return "Caps Lock";
            }
            case 348: {
                return "Menu";
            }
            case 343: {
                return "Left Super";
            }
            case 347: {
                return "Right Super";
            }
            case 257: {
                return "Enter";
            }
            case 335: {
                return "Numpad Enter";
            }
            case 282: {
                return "Num Lock";
            }
            case 32: {
                return "Space";
            }
            case 290: {
                return "F1";
            }
            case 291: {
                return "F2";
            }
            case 292: {
                return "F3";
            }
            case 293: {
                return "F4";
            }
            case 294: {
                return "F5";
            }
            case 295: {
                return "F6";
            }
            case 296: {
                return "F7";
            }
            case 297: {
                return "F8";
            }
            case 298: {
                return "F9";
            }
            case 299: {
                return "F10";
            }
            case 300: {
                return "F11";
            }
            case 301: {
                return "F12";
            }
            case 302: {
                return "F13";
            }
            case 303: {
                return "F14";
            }
            case 304: {
                return "F15";
            }
            case 305: {
                return "F16";
            }
            case 306: {
                return "F17";
            }
            case 307: {
                return "F18";
            }
            case 308: {
                return "F19";
            }
            case 309: {
                return "F20";
            }
            case 310: {
                return "F21";
            }
            case 311: {
                return "F22";
            }
            case 312: {
                return "F23";
            }
            case 313: {
                return "F24";
            }
            case 314: {
                return "F25";
            }
        }
        String keyName = GLFW.glfwGetKeyName((int)key, (int)0);
        if (keyName == null) {
            return "Unknown";
        }
        return StringUtils.capitalize((String)keyName);
    }

    public static String getButtonName(int button) {
        return switch (button) {
            case -1 -> "Unknown";
            case 0 -> "Mouse Left";
            case 1 -> "Mouse Right";
            case 2 -> "Mouse Middle";
            default -> "Mouse " + button;
        };
    }

    public static byte[] readBytes(InputStream in) {
        try {
            int read;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[256];
            while ((read = in.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
            in.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static boolean canUpdate() {
        return MeteorClient.mc != null && MeteorClient.mc.field_1687 != null && MeteorClient.mc.field_1724 != null;
    }

    public static boolean canOpenGui() {
        if (Utils.canUpdate()) {
            return MeteorClient.mc.field_1755 == null;
        }
        return MeteorClient.mc.field_1755 instanceof class_442 || MeteorClient.mc.field_1755 instanceof class_500 || MeteorClient.mc.field_1755 instanceof class_526;
    }

    public static boolean canCloseGui() {
        return MeteorClient.mc.field_1755 instanceof TabScreen;
    }

    public static int random(int min, int max) {
        return random.nextInt(max - min) + min;
    }

    public static double random(double min, double max) {
        return min + (max - min) * random.nextDouble();
    }

    public static void leftClick() {
        MeteorClient.mc.field_1690.field_1886.method_23481(true);
        ((MinecraftClientAccessor)MeteorClient.mc).leftClick();
        MeteorClient.mc.field_1690.field_1886.method_23481(false);
    }

    public static void rightClick() {
        ((IMinecraftClient)MeteorClient.mc).rightClick();
    }

    public static boolean isShulker(class_1792 item) {
        return item == class_1802.field_8545 || item == class_1802.field_8722 || item == class_1802.field_8380 || item == class_1802.field_8050 || item == class_1802.field_8829 || item == class_1802.field_8271 || item == class_1802.field_8548 || item == class_1802.field_8520 || item == class_1802.field_8627 || item == class_1802.field_8451 || item == class_1802.field_8213 || item == class_1802.field_8816 || item == class_1802.field_8350 || item == class_1802.field_8584 || item == class_1802.field_8461 || item == class_1802.field_8676 || item == class_1802.field_8268;
    }

    public static boolean isThrowable(class_1792 item) {
        return item instanceof class_1779 || item instanceof class_1753 || item instanceof class_1764 || item instanceof class_1823 || item instanceof class_1771 || item instanceof class_1776 || item instanceof class_1828 || item instanceof class_1803 || item instanceof class_1787 || item instanceof class_1835;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static void addEnchantment(class_1799 itemStack, class_1887 enchantment, int level) {
        class_2499 listTag;
        class_2487 tag = itemStack.method_7948();
        if (!tag.method_10573("Enchantments", 9)) {
            listTag = new class_2499();
            tag.method_10566("Enchantments", (class_2520)listTag);
        } else {
            listTag = tag.method_10554("Enchantments", 10);
        }
        String enchId = class_7923.field_41176.method_10221((Object)enchantment).toString();
        for (class_2520 _t : listTag) {
            class_2487 t = (class_2487)_t;
            if (!t.method_10558("id").equals(enchId)) continue;
            t.method_10575("lvl", (short)level);
            return;
        }
        class_2487 enchTag = new class_2487();
        enchTag.method_10582("id", enchId);
        enchTag.method_10575("lvl", (short)level);
        listTag.add((Object)enchTag);
    }

    public static void clearEnchantments(class_1799 itemStack) {
        class_2487 nbt = itemStack.method_7969();
        if (nbt != null) {
            nbt.method_10551("Enchantments");
        }
    }

    public static void removeEnchantment(class_1799 itemStack, class_1887 enchantment) {
        class_2487 nbt = itemStack.method_7969();
        if (nbt == null) {
            return;
        }
        if (!nbt.method_10573("Enchantments", 9)) {
            return;
        }
        class_2499 list = nbt.method_10554("Enchantments", 10);
        String enchId = class_7923.field_41176.method_10221((Object)enchantment).toString();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            class_2487 ench = (class_2487)it.next();
            if (!ench.method_10558("id").equals(enchId)) continue;
            it.remove();
            break;
        }
    }

    public static Color lerp(Color first, Color second, @Range(from=0L, to=1L) float v) {
        return new Color((int)((float)first.r * (1.0f - v) + (float)second.r * v), (int)((float)first.g * (1.0f - v) + (float)second.g * v), (int)((float)first.b * (1.0f - v) + (float)second.b * v));
    }

    public static boolean isLoading() {
        class_6360.class_6363 state = ((ResourceReloadLoggerAccessor)((MinecraftClientAccessor)MeteorClient.mc).getResourceReloadLogger()).getReloadState();
        return state == null || !((ReloadStateAccessor)state).isFinished();
    }

    public static int parsePort(String full) {
        int port;
        if (full == null || full.isBlank() || !full.contains(":")) {
            return -1;
        }
        try {
            port = Integer.parseInt(full.substring(full.lastIndexOf(58) + 1, full.length() - 1));
        }
        catch (NumberFormatException ignored) {
            port = -1;
        }
        return port;
    }

    public static String parseAddress(String full) {
        if (full == null || full.isBlank() || !full.contains(":")) {
            return full;
        }
        return full.substring(0, full.lastIndexOf(58));
    }

    public static boolean resolveAddress(String address) {
        if (address == null || address.isBlank()) {
            return false;
        }
        int port = Utils.parsePort(address);
        if (port == -1) {
            port = 25565;
        } else {
            address = Utils.parseAddress(address);
        }
        return Utils.resolveAddress(address, port);
    }

    public static boolean resolveAddress(String address, int port) {
        if (port <= 0 || port > 65535 || address == null || address.isBlank()) {
            return false;
        }
        InetSocketAddress socketAddress = new InetSocketAddress(address, port);
        return !socketAddress.isUnresolved();
    }

    public static Vector3d set(Vector3d vec, class_243 v) {
        vec.x = v.field_1352;
        vec.y = v.field_1351;
        vec.z = v.field_1350;
        return vec;
    }

    public static Vector3d set(Vector3d vec, class_1297 entity, double tickDelta) {
        vec.x = class_3532.method_16436((double)tickDelta, (double)entity.field_6038, (double)entity.method_23317());
        vec.y = class_3532.method_16436((double)tickDelta, (double)entity.field_5971, (double)entity.method_23318());
        vec.z = class_3532.method_16436((double)tickDelta, (double)entity.field_5989, (double)entity.method_23321());
        return vec;
    }

    public static boolean nameFilter(String text, char character) {
        return character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z' || character >= '0' && character <= '9' || character == '_' || character == '-' || character == '.' || character == ' ';
    }

    public static boolean ipFilter(String text, char character) {
        if (text.contains(":") && character == ':') {
            return false;
        }
        return character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z' || character >= '0' && character <= '9' || character == '.';
    }

    private static /* synthetic */ void lambda$createStatusEffectMap$2(Object2IntMap map, class_1291 potion) {
        map.put((Object)potion, 0);
    }

    static {
        WHITE = new Color(255, 255, 255);
        rendering3D = true;
        FILE_NAME_INVALID_CHARS_PATTERN = Pattern.compile("[\\s\\\\/:*?\"<>|]");
    }
}

