/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.utils.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.systems.friends.Friends;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.entity.EntityUtils;
import meteordevelopment.meteorclient.utils.entity.SortPriority;
import meteordevelopment.meteorclient.utils.entity.fakeplayer.FakePlayerEntity;
import meteordevelopment.meteorclient.utils.entity.fakeplayer.FakePlayerManager;
import meteordevelopment.meteorclient.utils.player.PlayerUtils;
import meteordevelopment.meteorclient.utils.player.Rotations;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1934;

public class TargetUtils {
    private static final List<class_1297> ENTITIES = new ArrayList<class_1297>();

    public static class_1297 get(Predicate<class_1297> isGood, SortPriority sortPriority) {
        ENTITIES.clear();
        TargetUtils.getList(ENTITIES, isGood, sortPriority, 1);
        if (!ENTITIES.isEmpty()) {
            return ENTITIES.get(0);
        }
        return null;
    }

    public static void getList(List<class_1297> targetList, Predicate<class_1297> isGood, SortPriority sortPriority, int maxCount) {
        targetList.clear();
        for (class_1297 entity2 : MeteorClient.mc.field_1687.method_18112()) {
            if (entity2 == null || !isGood.test(entity2)) continue;
            targetList.add(entity2);
        }
        FakePlayerManager.forEach(fp -> {
            if (fp != null && isGood.test((class_1297)fp)) {
                targetList.add((class_1297)fp);
            }
        });
        targetList.sort((e1, e2) -> TargetUtils.sort(e1, e2, sortPriority));
        targetList.removeIf(entity -> targetList.indexOf(entity) > maxCount - 1);
    }

    public static class_1657 getPlayerTarget(double range, SortPriority priority) {
        if (!Utils.canUpdate()) {
            return null;
        }
        return (class_1657)TargetUtils.get(entity -> {
            if (!(entity instanceof class_1657) || entity == MeteorClient.mc.field_1724) {
                return false;
            }
            if (((class_1657)entity).method_29504() || ((class_1657)entity).method_6032() <= 0.0f) {
                return false;
            }
            if (!PlayerUtils.isWithin(entity, range)) {
                return false;
            }
            if (!Friends.get().shouldAttack((class_1657)entity)) {
                return false;
            }
            return EntityUtils.getGameMode((class_1657)entity) == class_1934.field_9215 || entity instanceof FakePlayerEntity;
        }, priority);
    }

    public static boolean isBadTarget(class_1657 target, double range) {
        if (target == null) {
            return true;
        }
        return !PlayerUtils.isWithin((class_1297)target, range) || !target.method_5805() || target.method_29504() || target.method_6032() <= 0.0f;
    }

    private static int sort(class_1297 e1, class_1297 e2, SortPriority priority) {
        return switch (priority) {
            default -> throw new IncompatibleClassChangeError();
            case SortPriority.LowestDistance -> Double.compare(PlayerUtils.squaredDistanceTo(e1), PlayerUtils.squaredDistanceTo(e2));
            case SortPriority.HighestDistance -> Double.compare(PlayerUtils.squaredDistanceTo(e2), PlayerUtils.squaredDistanceTo(e1));
            case SortPriority.LowestHealth -> TargetUtils.sortHealth(e1, e2);
            case SortPriority.HighestHealth -> TargetUtils.sortHealth(e2, e1);
            case SortPriority.ClosestAngle -> TargetUtils.sortAngle(e1, e2);
        };
    }

    private static int sortHealth(class_1297 e1, class_1297 e2) {
        boolean e1l = e1 instanceof class_1309;
        boolean e2l = e2 instanceof class_1309;
        if (!e1l && !e2l) {
            return 0;
        }
        if (e1l && !e2l) {
            return 1;
        }
        if (!e1l) {
            return -1;
        }
        return Float.compare(((class_1309)e1).method_6032(), ((class_1309)e2).method_6032());
    }

    private static int sortAngle(class_1297 e1, class_1297 e2) {
        boolean e1l = e1 instanceof class_1309;
        boolean e2l = e2 instanceof class_1309;
        if (!e1l && !e2l) {
            return 0;
        }
        if (e1l && !e2l) {
            return 1;
        }
        if (!e1l) {
            return -1;
        }
        double e1yaw = Math.abs(Rotations.getYaw(e1) - (double)MeteorClient.mc.field_1724.method_36454());
        double e2yaw = Math.abs(Rotations.getYaw(e2) - (double)MeteorClient.mc.field_1724.method_36454());
        double e1pitch = Math.abs(Rotations.getPitch(e1) - (double)MeteorClient.mc.field_1724.method_36455());
        double e2pitch = Math.abs(Rotations.getPitch(e2) - (double)MeteorClient.mc.field_1724.method_36455());
        return Double.compare(e1yaw * e1yaw + e1pitch * e1pitch, e2yaw * e2yaw + e2pitch * e2pitch);
    }
}

