/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.utils.misc;

public enum HorizontalDirection {
    South("South", "Z+", false, 0.0f, 0, 1),
    SouthEast("South East", "X+ Z+", true, -45.0f, 1, 1),
    West("West", "X-", false, 90.0f, -1, 0),
    NorthWest("North West", "X- Z-", true, 135.0f, -1, -1),
    North("North", "Z-", false, 180.0f, 0, -1),
    NorthEast("North East", "X+ Z-", true, -135.0f, 1, -1),
    East("East", "X+", false, -90.0f, 1, 0),
    SouthWest("South West", "X- Z+", true, 45.0f, -1, 1);

    public final String name;
    public final String axis;
    public final boolean diagonal;
    public final float yaw;
    public final int offsetX;
    public final int offsetZ;

    private HorizontalDirection(String name, String axis, boolean diagonal, float yaw, int offsetX, int offsetZ) {
        this.axis = axis;
        this.name = name;
        this.diagonal = diagonal;
        this.yaw = yaw;
        this.offsetX = offsetX;
        this.offsetZ = offsetZ;
    }

    public HorizontalDirection opposite() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case South -> North;
            case SouthEast -> NorthWest;
            case West -> East;
            case NorthWest -> SouthEast;
            case North -> South;
            case NorthEast -> SouthWest;
            case East -> West;
            case SouthWest -> NorthEast;
        };
    }

    public HorizontalDirection rotateLeft() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case South -> SouthEast;
            case SouthEast -> East;
            case East -> NorthEast;
            case NorthEast -> North;
            case North -> NorthWest;
            case NorthWest -> West;
            case West -> SouthWest;
            case SouthWest -> South;
        };
    }

    public HorizontalDirection rotateLeftSkipOne() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case South -> East;
            case East -> North;
            case North -> West;
            case West -> South;
            case SouthEast -> NorthEast;
            case NorthEast -> NorthWest;
            case NorthWest -> SouthWest;
            case SouthWest -> SouthEast;
        };
    }

    public HorizontalDirection rotateRight() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case South -> SouthWest;
            case SouthWest -> West;
            case West -> NorthWest;
            case NorthWest -> North;
            case North -> NorthEast;
            case NorthEast -> East;
            case East -> SouthEast;
            case SouthEast -> South;
        };
    }

    public static HorizontalDirection get(float yaw) {
        if ((yaw %= 360.0f) < 0.0f) {
            yaw += 360.0f;
        }
        if ((double)yaw >= 337.5 || (double)yaw < 22.5) {
            return South;
        }
        if ((double)yaw >= 22.5 && (double)yaw < 67.5) {
            return SouthWest;
        }
        if ((double)yaw >= 67.5 && (double)yaw < 112.5) {
            return West;
        }
        if ((double)yaw >= 112.5 && (double)yaw < 157.5) {
            return NorthWest;
        }
        if ((double)yaw >= 157.5 && (double)yaw < 202.5) {
            return North;
        }
        if ((double)yaw >= 202.5 && (double)yaw < 247.5) {
            return NorthEast;
        }
        if ((double)yaw >= 247.5 && (double)yaw < 292.5) {
            return East;
        }
        if ((double)yaw >= 292.5 && (double)yaw < 337.5) {
            return SouthEast;
        }
        return South;
    }
}

