/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.utils.misc;

import java.util.Objects;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.misc.ICopyable;
import meteordevelopment.meteorclient.utils.misc.ISerializable;
import meteordevelopment.meteorclient.utils.misc.input.Input;
import net.minecraft.class_2487;

public class Keybind
implements ISerializable<Keybind>,
ICopyable<Keybind> {
    private boolean isKey;
    private int value;

    private Keybind(boolean isKey, int value) {
        this.set(isKey, value);
    }

    public static Keybind none() {
        return new Keybind(true, -1);
    }

    public static Keybind fromKey(int key) {
        return new Keybind(true, key);
    }

    public static Keybind fromButton(int button) {
        return new Keybind(false, button);
    }

    public int getValue() {
        return this.value;
    }

    public boolean isSet() {
        return this.value != -1;
    }

    public boolean canBindTo(boolean isKey, int value) {
        if (isKey) {
            return value != 256;
        }
        return value != 0 && value != 1;
    }

    public void set(boolean isKey, int value) {
        this.isKey = isKey;
        this.value = value;
    }

    @Override
    public Keybind set(Keybind value) {
        this.isKey = value.isKey;
        this.value = value.value;
        return this;
    }

    public boolean matches(boolean isKey, int value) {
        if (this.isKey != isKey) {
            return false;
        }
        return this.value == value;
    }

    public boolean isValid() {
        return this.value != -1;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public boolean isPressed() {
        return this.isKey ? Input.isKeyPressed(this.value) : Input.isButtonPressed(this.value);
    }

    @Override
    public Keybind copy() {
        return new Keybind(this.isKey, this.value);
    }

    public String toString() {
        if (this.value == -1) {
            return "None";
        }
        return this.isKey ? Utils.getKeyName(this.value) : Utils.getButtonName(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Keybind keybind = (Keybind)o;
        return this.isKey == keybind.isKey && this.value == keybind.value;
    }

    public int hashCode() {
        return Objects.hash(this.isKey, this.value);
    }

    @Override
    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10556("isKey", this.isKey);
        tag.method_10569("value", this.value);
        return tag;
    }

    @Override
    public Keybind fromTag(class_2487 tag) {
        this.isKey = tag.method_10577("isKey");
        this.value = tag.method_10550("value");
        return this;
    }
}

