/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.utils.misc;

import java.util.HashMap;
import java.util.Map;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.game.ResourcePacksReloadedEvent;
import meteordevelopment.meteorclient.utils.PreInit;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1146;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3544;
import org.apache.commons.lang3.text.WordUtils;

public class Names {
    private static final Map<class_1291, String> statusEffectNames = new HashMap<class_1291, String>(16);
    private static final Map<class_1792, String> itemNames = new HashMap<class_1792, String>(128);
    private static final Map<class_2248, String> blockNames = new HashMap<class_2248, String>(128);
    private static final Map<class_1887, String> enchantmentNames = new HashMap<class_1887, String>(16);
    private static final Map<class_1299<?>, String> entityTypeNames = new HashMap(64);
    private static final Map<class_2396<?>, String> particleTypesNames = new HashMap(64);
    private static final Map<class_2960, String> soundNames = new HashMap<class_2960, String>(64);

    @PreInit
    public static void init() {
        MeteorClient.EVENT_BUS.subscribe(Names.class);
    }

    @EventHandler
    private static void onResourcePacksReloaded(ResourcePacksReloadedEvent event) {
        statusEffectNames.clear();
        itemNames.clear();
        blockNames.clear();
        enchantmentNames.clear();
        entityTypeNames.clear();
        particleTypesNames.clear();
        soundNames.clear();
    }

    public static String get(class_1291 effect) {
        return statusEffectNames.computeIfAbsent(effect, effect1 -> class_3544.method_15440((String)effect1.method_5560().getString()));
    }

    public static String get(class_1792 item) {
        return itemNames.computeIfAbsent(item, item1 -> class_3544.method_15440((String)item1.method_7848().getString()));
    }

    public static String get(class_2248 block) {
        return blockNames.computeIfAbsent(block, block1 -> class_3544.method_15440((String)block1.method_9518().getString()));
    }

    public static String get(class_1887 enchantment) {
        return enchantmentNames.computeIfAbsent(enchantment, enchantment1 -> class_3544.method_15440((String)class_2561.method_43471((String)enchantment1.method_8184()).getString()));
    }

    public static String get(class_1299<?> entityType) {
        return entityTypeNames.computeIfAbsent(entityType, entityType1 -> class_3544.method_15440((String)entityType1.method_5897().getString()));
    }

    public static String get(class_2396<?> type) {
        if (!(type instanceof class_2394)) {
            return "";
        }
        return particleTypesNames.computeIfAbsent(type, effect1 -> WordUtils.capitalize((String)((class_2394)effect1).method_10293().substring(10).replace("_", " ")));
    }

    public static String getSoundName(class_2960 id) {
        return soundNames.computeIfAbsent(id, identifier -> {
            class_1146 soundSet = MeteorClient.mc.method_1483().method_4869(identifier);
            if (soundSet == null) {
                return identifier.method_12832();
            }
            class_2561 text = soundSet.method_4886();
            if (text == null) {
                return identifier.method_12832();
            }
            return class_3544.method_15440((String)text.getString());
        });
    }
}

