/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.utils.misc;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.systems.System;
import meteordevelopment.meteorclient.utils.misc.ISerializable;
import meteordevelopment.meteorclient.utils.render.prompts.OkPrompt;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class NbtUtils {
    public static <T extends ISerializable<?>> class_2499 listToTag(Iterable<T> list) {
        class_2499 tag = new class_2499();
        for (ISerializable item : list) {
            tag.add((Object)item.toTag());
        }
        return tag;
    }

    public static <T> List<T> listFromTag(class_2499 tag, ToValue<T> toItem) {
        ArrayList<T> list = new ArrayList<T>(tag.size());
        for (class_2520 itemTag : tag) {
            T value = toItem.toValue(itemTag);
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    public static <K, V extends ISerializable<?>> class_2487 mapToTag(Map<K, V> map) {
        class_2487 tag = new class_2487();
        for (K key : map.keySet()) {
            tag.method_10566(key.toString(), (class_2520)((ISerializable)map.get(key)).toTag());
        }
        return tag;
    }

    public static <K, V> Map<K, V> mapFromTag(class_2487 tag, ToKey<K> toKey, ToValue<V> toValue) {
        HashMap<K, V> map = new HashMap<K, V>(tag.method_10546());
        for (String key : tag.method_10541()) {
            map.put(toKey.toKey(key), toValue.toValue(tag.method_10580(key)));
        }
        return map;
    }

    public static boolean toClipboard(System<?> system) {
        return NbtUtils.toClipboard(system.getName(), system.toTag());
    }

    public static boolean toClipboard(String name, class_2487 nbtCompound) {
        String preClipboard = MeteorClient.mc.field_1774.method_1460();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            class_2507.method_10634((class_2487)nbtCompound, (OutputStream)byteArrayOutputStream);
            MeteorClient.mc.field_1774.method_1455(Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray()));
            return true;
        }
        catch (Exception e) {
            MeteorClient.LOG.error(String.format("Error copying %s NBT to clipboard!", name));
            OkPrompt.create().title(String.format("Error copying %s NBT to clipboard!", name)).message("This shouldn't happen, please report it.").id("nbt-copying").show();
            MeteorClient.mc.field_1774.method_1455(preClipboard);
            return false;
        }
    }

    public static boolean fromClipboard(System<?> system) {
        class_2487 clipboard = NbtUtils.fromClipboard(system.toTag());
        if (clipboard != null) {
            system.fromTag(clipboard);
            return true;
        }
        return false;
    }

    public static class_2487 fromClipboard(class_2487 schema) {
        try {
            byte[] data = Base64.getDecoder().decode(MeteorClient.mc.field_1774.method_1460().trim());
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            class_2487 pasted = class_2507.method_10629((InputStream)new DataInputStream(bis));
            for (String key : schema.method_10541()) {
                if (pasted.method_10541().contains(key)) continue;
                return null;
            }
            if (!pasted.method_10558("name").equals(schema.method_10558("name"))) {
                return null;
            }
            return pasted;
        }
        catch (Exception e) {
            MeteorClient.LOG.error("Invalid NBT data pasted!");
            OkPrompt.create().title("Error pasting NBT data!").message("Please check that the data you pasted is valid.").id("nbt-pasting").show();
            return null;
        }
    }

    public static interface ToValue<T> {
        public T toValue(class_2520 var1);
    }

    public static interface ToKey<T> {
        public T toKey(String var1);
    }
}

