/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.utils.misc.text;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import meteordevelopment.meteorclient.utils.misc.text.ColoredText;
import meteordevelopment.meteorclient.utils.render.color.Color;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5481;

public class TextUtils {
    public static List<ColoredText> toColoredTextList(class_2561 text) {
        Stack<ColoredText> stack = new Stack<ColoredText>();
        ArrayList<ColoredText> coloredTexts = new ArrayList<ColoredText>();
        TextUtils.preOrderTraverse(text, stack, coloredTexts);
        coloredTexts.removeIf(e -> e.getText().isEmpty());
        return coloredTexts;
    }

    public static class_5250 parseOrderedText(class_5481 orderedText) {
        class_5250 parsedText = class_2561.method_43473();
        orderedText.accept((i, style, codePoint) -> {
            parsedText.method_10852((class_2561)class_2561.method_43470((String)new String(Character.toChars(codePoint))).method_10862(style));
            return true;
        });
        return parsedText;
    }

    public static Color getMostPopularColor(class_2561 text) {
        Object2IntMap.Entry biggestEntry = null;
        for (Object2IntMap.Entry entry : TextUtils.getColoredCharacterCount(TextUtils.toColoredTextList(text)).object2IntEntrySet()) {
            if (biggestEntry == null) {
                biggestEntry = entry;
                continue;
            }
            if (entry.getIntValue() <= biggestEntry.getIntValue()) continue;
            biggestEntry = entry;
        }
        return biggestEntry == null ? new Color(255, 255, 255) : (Color)biggestEntry.getKey();
    }

    public static Object2IntMap<Color> getColoredCharacterCount(List<ColoredText> coloredTexts) {
        Object2IntOpenHashMap colorCount = new Object2IntOpenHashMap();
        for (ColoredText coloredText : coloredTexts) {
            if (colorCount.containsKey((Object)coloredText.getColor())) {
                colorCount.put((Object)coloredText.getColor(), colorCount.getInt((Object)coloredText.getColor()) + coloredText.getText().length());
                continue;
            }
            colorCount.put((Object)coloredText.getColor(), coloredText.getText().length());
        }
        return colorCount;
    }

    private static void preOrderTraverse(class_2561 text, Stack<ColoredText> stack, List<ColoredText> coloredTexts) {
        if (text == null) {
            return;
        }
        String textString = text.getString();
        class_5251 mcTextColor = text.method_10866().method_10973();
        Color textColor = mcTextColor == null ? (stack.empty() ? new Color(255, 255, 255) : stack.peek().getColor()) : new Color(text.method_10866().method_10973().method_27716() | 0xFF000000);
        ColoredText coloredText = new ColoredText(textString, textColor);
        coloredTexts.add(coloredText);
        stack.push(coloredText);
        for (class_2561 child : text.method_10855()) {
            TextUtils.preOrderTraverse(child, stack, coloredTexts);
        }
        stack.pop();
    }
}

