/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.utils.network;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Date;
import java.util.stream.Stream;
import meteordevelopment.meteorclient.utils.other.JsonDateDeserializer;

public class Http {
    private static final HttpClient CLIENT = HttpClient.newHttpClient();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new JsonDateDeserializer()).create();

    public static Request get(String url) {
        return new Request(Method.GET, url);
    }

    public static Request post(String url) {
        return new Request(Method.POST, url);
    }

    public static class Request {
        private HttpRequest.Builder builder;
        private Method method;

        public Request(Method method, String url) {
            try {
                this.builder = HttpRequest.newBuilder().uri(new URI(url)).header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36");
                this.method = method;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }

        public Request bearer(String token) {
            this.builder.header("Authorization", "Bearer " + token);
            return this;
        }

        public Request bodyString(String string) {
            this.builder.header("Content-Type", "text/plain");
            this.builder.method(this.method.name(), HttpRequest.BodyPublishers.ofString(string));
            this.method = null;
            return this;
        }

        public Request bodyForm(String string) {
            this.builder.header("Content-Type", "application/x-www-form-urlencoded");
            this.builder.method(this.method.name(), HttpRequest.BodyPublishers.ofString(string));
            this.method = null;
            return this;
        }

        public Request bodyJson(String string) {
            this.builder.header("Content-Type", "application/json");
            this.builder.method(this.method.name(), HttpRequest.BodyPublishers.ofString(string));
            this.method = null;
            return this;
        }

        public Request bodyJson(Object object) {
            this.builder.header("Content-Type", "application/json");
            this.builder.method(this.method.name(), HttpRequest.BodyPublishers.ofString(GSON.toJson(object)));
            this.method = null;
            return this;
        }

        private <T> T _send(String accept, HttpResponse.BodyHandler<T> responseBodyHandler) {
            this.builder.header("Accept", accept);
            if (this.method != null) {
                this.builder.method(this.method.name(), HttpRequest.BodyPublishers.noBody());
            }
            try {
                HttpResponse<T> res = CLIENT.send(this.builder.build(), responseBodyHandler);
                return res.statusCode() == 200 ? (T)res.body() : null;
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
                return null;
            }
        }

        public void send() {
            this._send("*/*", HttpResponse.BodyHandlers.discarding());
        }

        public InputStream sendInputStream() {
            return this._send("*/*", HttpResponse.BodyHandlers.ofInputStream());
        }

        public String sendString() {
            return this._send("*/*", HttpResponse.BodyHandlers.ofString());
        }

        public Stream<String> sendLines() {
            return this._send("*/*", HttpResponse.BodyHandlers.ofLines());
        }

        public <T> T sendJson(Type type) {
            InputStream in = this._send("application/json", HttpResponse.BodyHandlers.ofInputStream());
            return (T)(in == null ? null : GSON.fromJson((Reader)new InputStreamReader(in), type));
        }
    }

    private static enum Method {
        GET,
        POST;

    }
}

