/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.utils.player;

import java.util.Objects;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.game.GameJoinedEvent;
import meteordevelopment.meteorclient.mixininterface.IExplosion;
import meteordevelopment.meteorclient.mixininterface.IRaycastContext;
import meteordevelopment.meteorclient.mixininterface.IVec3d;
import meteordevelopment.meteorclient.utils.PreInit;
import meteordevelopment.meteorclient.utils.entity.EntityUtils;
import meteordevelopment.meteorclient.utils.entity.fakeplayer.FakePlayerEntity;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1267;
import net.minecraft.class_1280;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5134;

public class DamageUtils {
    private static final class_243 vec3d = new class_243(0.0, 0.0, 0.0);
    private static class_1927 explosion;
    private static class_3959 raycastContext;

    @PreInit
    public static void init() {
        MeteorClient.EVENT_BUS.subscribe(DamageUtils.class);
    }

    @EventHandler
    private static void onGameJoined(GameJoinedEvent event) {
        explosion = new class_1927((class_1937)MeteorClient.mc.field_1687, null, 0.0, 0.0, 0.0, 6.0f, false, class_1927.class_4179.field_18687);
        raycastContext = new class_3959(null, null, class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)MeteorClient.mc.field_1724);
    }

    public static double crystalDamage(class_1657 player, class_243 crystal, boolean predictMovement, class_2338 obsidianPos, boolean ignoreTerrain) {
        double modDistance;
        if (player == null) {
            return 0.0;
        }
        if (EntityUtils.getGameMode(player) == class_1934.field_9220 && !(player instanceof FakePlayerEntity)) {
            return 0.0;
        }
        ((IVec3d)vec3d).set(player.method_19538().field_1352, player.method_19538().field_1351, player.method_19538().field_1350);
        if (predictMovement) {
            ((IVec3d)vec3d).set(DamageUtils.vec3d.field_1352 + player.method_18798().field_1352, DamageUtils.vec3d.field_1351 + player.method_18798().field_1351, DamageUtils.vec3d.field_1350 + player.method_18798().field_1350);
        }
        if ((modDistance = Math.sqrt(vec3d.method_1025(crystal))) > 12.0) {
            return 0.0;
        }
        double exposure = DamageUtils.getExposure(crystal, (class_1297)player, predictMovement, raycastContext, obsidianPos, ignoreTerrain);
        double impact = (1.0 - modDistance / 12.0) * exposure;
        double damage = (impact * impact + impact) / 2.0 * 7.0 * 12.0 + 1.0;
        damage = DamageUtils.getDamageForDifficulty(damage);
        damage = class_1280.method_5496((float)((float)damage), (float)player.method_6096(), (float)((float)player.method_5996(class_5134.field_23725).method_6194()));
        damage = DamageUtils.resistanceReduction((class_1309)player, damage);
        ((IExplosion)explosion).set(crystal, 6.0f, false);
        damage = DamageUtils.blastProtReduction((class_1297)player, damage, explosion);
        return damage < 0.0 ? 0.0 : damage;
    }

    public static double crystalDamage(class_1657 player, class_243 crystal) {
        return DamageUtils.crystalDamage(player, crystal, false, null, false);
    }

    public static double getSwordDamage(class_1657 entity, boolean charged) {
        double damage = 0.0;
        if (charged) {
            if (entity.method_6030().method_7909() == class_1802.field_22022) {
                damage += 8.0;
            } else if (entity.method_6030().method_7909() == class_1802.field_8802) {
                damage += 7.0;
            } else if (entity.method_6030().method_7909() == class_1802.field_8845) {
                damage += 4.0;
            } else if (entity.method_6030().method_7909() == class_1802.field_8371) {
                damage += 6.0;
            } else if (entity.method_6030().method_7909() == class_1802.field_8528) {
                damage += 5.0;
            } else if (entity.method_6030().method_7909() == class_1802.field_8091) {
                damage += 4.0;
            }
            damage *= 1.5;
        }
        if (entity.method_6030().method_7921() != null && class_1890.method_8222((class_1799)entity.method_6030()).containsKey(class_1893.field_9118)) {
            int level = class_1890.method_8225((class_1887)class_1893.field_9118, (class_1799)entity.method_6030());
            damage += 0.5 * (double)level + 0.5;
        }
        if (entity.method_6088().containsKey(class_1294.field_5910)) {
            int strength = Objects.requireNonNull(entity.method_6112(class_1294.field_5910)).method_5578() + 1;
            damage += (double)(3 * strength);
        }
        damage = DamageUtils.resistanceReduction((class_1309)entity, damage);
        damage = class_1280.method_5496((float)((float)damage), (float)entity.method_6096(), (float)((float)entity.method_5996(class_5134.field_23725).method_6194()));
        return (damage = DamageUtils.normalProtReduction((class_1297)entity, damage)) < 0.0 ? 0.0 : damage;
    }

    public static double bedDamage(class_1309 player, class_243 bed) {
        if (player instanceof class_1657 && ((class_1657)player).method_31549().field_7477) {
            return 0.0;
        }
        double modDistance = Math.sqrt(player.method_5707(bed));
        if (modDistance > 10.0) {
            return 0.0;
        }
        double exposure = class_1927.method_17752((class_243)bed, (class_1297)player);
        double impact = (1.0 - modDistance / 10.0) * exposure;
        double damage = (impact * impact + impact) / 2.0 * 7.0 * 10.0 + 1.0;
        damage = DamageUtils.getDamageForDifficulty(damage);
        damage = DamageUtils.resistanceReduction(player, damage);
        damage = class_1280.method_5496((float)((float)damage), (float)player.method_6096(), (float)((float)player.method_5996(class_5134.field_23725).method_6194()));
        ((IExplosion)explosion).set(bed, 5.0f, true);
        damage = DamageUtils.blastProtReduction((class_1297)player, damage, explosion);
        if (damage < 0.0) {
            damage = 0.0;
        }
        return damage;
    }

    public static double anchorDamage(class_1309 player, class_243 anchor) {
        MeteorClient.mc.field_1687.method_8650(class_2338.method_49638((class_2374)anchor), false);
        double damage = DamageUtils.bedDamage(player, anchor);
        MeteorClient.mc.field_1687.method_8501(class_2338.method_49638((class_2374)anchor), class_2246.field_23152.method_9564());
        return damage;
    }

    private static double getDamageForDifficulty(double damage) {
        return switch (MeteorClient.mc.field_1687.method_8407()) {
            case class_1267.field_5801 -> 0.0;
            case class_1267.field_5805 -> Math.min(damage / 2.0 + 1.0, damage);
            case class_1267.field_5807 -> damage * 3.0 / 2.0;
            default -> damage;
        };
    }

    private static double normalProtReduction(class_1297 player, double damage) {
        int protLevel = class_1890.method_8219((Iterable)player.method_5661(), (class_1282)MeteorClient.mc.field_1687.method_48963().method_48830());
        if (protLevel > 20) {
            protLevel = 20;
        }
        return (damage *= 1.0 - (double)protLevel / 25.0) < 0.0 ? 0.0 : damage;
    }

    private static double blastProtReduction(class_1297 player, double damage, class_1927 explosion) {
        int protLevel = class_1890.method_8219((Iterable)player.method_5661(), (class_1282)MeteorClient.mc.field_1687.method_48963().method_48807(explosion));
        if (protLevel > 20) {
            protLevel = 20;
        }
        return (damage *= 1.0 - (double)protLevel / 25.0) < 0.0 ? 0.0 : damage;
    }

    private static double resistanceReduction(class_1309 player, double damage) {
        if (player.method_6059(class_1294.field_5907)) {
            int lvl = player.method_6112(class_1294.field_5907).method_5578() + 1;
            damage *= 1.0 - (double)lvl * 0.2;
        }
        return damage < 0.0 ? 0.0 : damage;
    }

    private static double getExposure(class_243 source, class_1297 entity, boolean predictMovement, class_3959 raycastContext, class_2338 obsidianPos, boolean ignoreTerrain) {
        class_238 box = entity.method_5829();
        if (predictMovement) {
            class_243 v = entity.method_18798();
            box = box.method_989(v.field_1352, v.field_1351, v.field_1350);
        }
        double d = 1.0 / ((box.field_1320 - box.field_1323) * 2.0 + 1.0);
        double e = 1.0 / ((box.field_1325 - box.field_1322) * 2.0 + 1.0);
        double f = 1.0 / ((box.field_1324 - box.field_1321) * 2.0 + 1.0);
        double g = (1.0 - Math.floor(1.0 / d) * d) / 2.0;
        double h = (1.0 - Math.floor(1.0 / f) * f) / 2.0;
        if (!(d < 0.0 || e < 0.0 || f < 0.0)) {
            int i = 0;
            int j = 0;
            for (double k = 0.0; k <= 1.0; k += d) {
                for (double l = 0.0; l <= 1.0; l += e) {
                    for (double m = 0.0; m <= 1.0; m += f) {
                        double n = class_3532.method_16436((double)k, (double)box.field_1323, (double)box.field_1320);
                        double o = class_3532.method_16436((double)l, (double)box.field_1322, (double)box.field_1325);
                        double p = class_3532.method_16436((double)m, (double)box.field_1321, (double)box.field_1324);
                        ((IVec3d)vec3d).set(n + g, o, p + h);
                        ((IRaycastContext)raycastContext).set(vec3d, source, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity);
                        if (DamageUtils.raycast(raycastContext, obsidianPos, ignoreTerrain).method_17783() == class_239.class_240.field_1333) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
            return (double)i / (double)j;
        }
        return 0.0;
    }

    private static class_3965 raycast(class_3959 context, class_2338 obsidianPos, boolean ignoreTerrain) {
        return (class_3965)class_1922.method_17744((class_243)context.method_17750(), (class_243)context.method_17747(), (Object)context, (raycastContext, blockPos) -> {
            class_2680 blockState;
            if (blockPos.equals((Object)obsidianPos)) {
                blockState = class_2246.field_10540.method_9564();
            } else {
                blockState = MeteorClient.mc.field_1687.method_8320(blockPos);
                if (blockState.method_26204().method_9520() < 600.0f && ignoreTerrain) {
                    blockState = class_2246.field_10124.method_9564();
                }
            }
            class_243 vec3d = raycastContext.method_17750();
            class_243 vec3d2 = raycastContext.method_17747();
            class_265 voxelShape = raycastContext.method_17748(blockState, (class_1922)MeteorClient.mc.field_1687, blockPos);
            class_3965 blockHitResult = MeteorClient.mc.field_1687.method_17745(vec3d, vec3d2, blockPos, voxelShape, blockState);
            class_265 voxelShape2 = class_259.method_1073();
            class_3965 blockHitResult2 = voxelShape2.method_1092(vec3d, vec3d2, blockPos);
            double d = blockHitResult == null ? Double.MAX_VALUE : raycastContext.method_17750().method_1025(blockHitResult.method_17784());
            double e = blockHitResult2 == null ? Double.MAX_VALUE : raycastContext.method_17750().method_1025(blockHitResult2.method_17784());
            return d <= e ? blockHitResult : blockHitResult2;
        }, raycastContext -> {
            class_243 vec3d = raycastContext.method_17750().method_1020(raycastContext.method_17747());
            return class_3965.method_17778((class_243)raycastContext.method_17747(), (class_2350)class_2350.method_10142((double)vec3d.field_1352, (double)vec3d.field_1351, (double)vec3d.field_1350), (class_2338)class_2338.method_49638((class_2374)raycastContext.method_17747()));
        });
    }
}

