/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.utils.player;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.addons.AddonManager;
import meteordevelopment.meteorclient.addons.GithubRepo;
import meteordevelopment.meteorclient.addons.MeteorAddon;
import meteordevelopment.meteorclient.gui.GuiThemes;
import meteordevelopment.meteorclient.gui.screens.CommitsScreen;
import meteordevelopment.meteorclient.utils.network.Http;
import meteordevelopment.meteorclient.utils.network.MeteorExecutor;
import meteordevelopment.meteorclient.utils.render.color.Color;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class TitleScreenCredits {
    private static final int WHITE = Color.fromRGBA(255, 255, 255, 255);
    private static final int GRAY = Color.fromRGBA(175, 175, 175, 255);
    private static final int RED = Color.fromRGBA(225, 25, 25, 255);
    private static final List<Credit> credits = new ArrayList<Credit>();

    private static void init() {
        TitleScreenCredits.add(MeteorClient.ADDON);
        for (MeteorAddon addon : AddonManager.ADDONS) {
            TitleScreenCredits.add(addon);
        }
        credits.sort(Comparator.comparingInt(value -> value.sections.get((int)0).text.equals("Meteor Client ") ? Integer.MIN_VALUE : -value.width));
        MeteorExecutor.execute(() -> {
            for (Credit credit : credits) {
                if (credit.addon.getRepo() == null || credit.addon.getCommit() == null) continue;
                GithubRepo repo = credit.addon.getRepo();
                Response res = (Response)Http.get(String.format("https://api.github.com/repos/%s/branches/%s", repo.getOwnerName(), repo.branch())).sendJson((Type)((Object)Response.class));
                if (res == null || credit.addon.getCommit().equals(res.commit.sha)) continue;
                List<Section> list = credit.sections;
                synchronized (list) {
                    credit.sections.add(1, new Section("*", RED));
                    credit.calculateWidth();
                }
            }
        });
    }

    private static void add(MeteorAddon addon) {
        Credit credit = new Credit(addon);
        credit.sections.add(new Section(addon.name, addon.color.getPacked()));
        credit.sections.add(new Section(" by ", GRAY));
        for (int i = 0; i < addon.authors.length; ++i) {
            if (i > 0) {
                credit.sections.add(new Section(i == addon.authors.length - 1 ? " & " : ", ", GRAY));
            }
            credit.sections.add(new Section(addon.authors[i], WHITE));
        }
        credit.calculateWidth();
        credits.add(credit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void render(class_4587 matrices) {
        if (credits.isEmpty()) {
            TitleScreenCredits.init();
        }
        int y = 3;
        for (Credit credit : credits) {
            int x = MeteorClient.mc.field_1755.field_22789 - 3 - credit.width;
            List<Section> list = credit.sections;
            synchronized (list) {
                for (Section section : credit.sections) {
                    MeteorClient.mc.field_1772.method_1720(matrices, section.text, (float)x, (float)y, section.color);
                    x += section.width;
                }
            }
            Objects.requireNonNull(MeteorClient.mc.field_1772);
            y += 9 + 2;
        }
    }

    public static boolean onClicked(double mouseX, double mouseY) {
        int y = 3;
        for (Credit credit : credits) {
            int x = MeteorClient.mc.field_1755.field_22789 - 3 - credit.width;
            if (mouseX >= (double)x && mouseX <= (double)(x + credit.width) && mouseY >= (double)y) {
                Objects.requireNonNull(MeteorClient.mc.field_1772);
                if (mouseY <= (double)(y + 9 + 2) && credit.addon.getRepo() != null && credit.addon.getCommit() != null) {
                    MeteorClient.mc.method_1507((class_437)new CommitsScreen(GuiThemes.get(), credit.addon));
                    return true;
                }
            }
            Objects.requireNonNull(MeteorClient.mc.field_1772);
            y += 9 + 2;
        }
        return false;
    }

    private static class Credit {
        public final MeteorAddon addon;
        public final List<Section> sections = new ArrayList<Section>();
        public int width;

        public Credit(MeteorAddon addon) {
            this.addon = addon;
        }

        public void calculateWidth() {
            this.width = 0;
            for (Section section : this.sections) {
                this.width += section.width;
            }
        }
    }

    private static class Section {
        public final String text;
        public final int color;
        public final int width;

        public Section(String text, int color) {
            this.text = text;
            this.color = color;
            this.width = MeteorClient.mc.field_1772.method_1727(text);
        }
    }

    private static class Response {
        public Commit commit;

        private Response() {
        }
    }

    private static class Commit {
        public String sha;

        private Commit() {
        }
    }
}

