/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.utils.world;

import baritone.api.BaritoneAPI;
import baritone.api.pathing.goals.Goal;
import baritone.api.utils.SettingsUtil;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class GoalDirection
implements Goal {
    private static final double SQRT_2 = Math.sqrt(2.0);
    private final float yaw;
    private int x;
    private int z;

    public GoalDirection(class_243 origin, float yaw) {
        this.yaw = yaw;
        this.recalculate(origin);
    }

    public static double calculate(double xDiff, double zDiff) {
        double straight;
        double z;
        double x = Math.abs(xDiff);
        if (x < (z = Math.abs(zDiff))) {
            straight = z - x;
            diagonal = x;
        } else {
            straight = x - z;
            diagonal = z;
        }
        return ((diagonal *= SQRT_2) + straight) * (Double)BaritoneAPI.getSettings().costHeuristic.value;
    }

    public void recalculate(class_243 origin) {
        float theta = (float)Math.toRadians(this.yaw);
        this.x = (int)Math.floor(origin.field_1352 - (double)class_3532.method_15374((float)theta) * 100.0);
        this.z = (int)Math.floor(origin.field_1350 + (double)class_3532.method_15362((float)theta) * 100.0);
    }

    public boolean isInGoal(int x, int y, int z) {
        return x == this.x && z == this.z;
    }

    public double heuristic(int x, int y, int z) {
        int xDiff = x - this.x;
        int zDiff = z - this.z;
        return GoalDirection.calculate(xDiff, zDiff);
    }

    public String toString() {
        return String.format("GoalXZ{x=%s,z=%s}", SettingsUtil.maybeCensor((int)this.x), SettingsUtil.maybeCensor((int)this.z));
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }
}

